/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.io.stream.BytesStream;
import org.elasticsearch.common.io.stream.RecyclerBytesStreamOutput;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.rest.ChunkedRestResponseBodyPart;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.transport.Transports;

public final class ChunkedZipResponse
implements Releasable {
    public static final String ZIP_CONTENT_TYPE = "application/zip";
    @Nullable
    private BytesStream targetStream;
    private final ZipOutputStream zipOutputStream = new ZipOutputStream(new OutputStream(){

        @Override
        public void write(int b) throws IOException {
            assert (ChunkedZipResponse.this.targetStream != null);
            ChunkedZipResponse.this.targetStream.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            assert (ChunkedZipResponse.this.targetStream != null);
            ChunkedZipResponse.this.targetStream.write(b, off, len);
        }
    }, StandardCharsets.UTF_8);
    private final String filename;
    private final RestChannel restChannel;
    @Nullable
    private SubscribableListener<ChunkedRestResponseBodyPart> nextAvailableChunksListener;
    @Nullable
    private Releasable currentEntryReleasable;
    private final RefCounted listenersRefs;
    private final Releasable rootListenerRef;
    private final Queue<ChunkedZipEntry> entryQueue = new LinkedBlockingQueue<ChunkedZipEntry>();
    private final AtomicInteger queueLength = new AtomicInteger();
    private final RefCounted queueRefs = AbstractRefCounted.of(this::drainQueue);
    private final AtomicBoolean isRestResponseFinished = new AtomicBoolean();
    private static final ChunkedRestResponseBodyPart NO_MORE_ENTRIES = new ChunkedRestResponseBodyPart(){

        @Override
        public boolean isPartComplete() {
            assert (false) : "never called";
            return true;
        }

        @Override
        public boolean isLastPart() {
            assert (false) : "never called";
            return true;
        }

        @Override
        public void getNextPart(ActionListener<ChunkedRestResponseBodyPart> listener) {
            assert (false) : "never called";
            listener.onFailure(new IllegalStateException("impossible"));
        }

        @Override
        public ReleasableBytesReference encodeChunk(int sizeHint, Recycler<BytesRef> recycler) {
            assert (false) : "never called";
            return ReleasableBytesReference.empty();
        }

        @Override
        public String getResponseContentTypeString() {
            assert (false) : "never called";
            return ChunkedZipResponse.ZIP_CONTENT_TYPE;
        }
    };

    public ChunkedZipResponse(String filename, RestChannel restChannel, Releasable onCompletion) {
        this.filename = filename;
        this.restChannel = restChannel;
        this.listenersRefs = AbstractRefCounted.of(() -> this.enqueueEntry(null, NO_MORE_ENTRIES, onCompletion));
        this.rootListenerRef = Releasables.releaseOnce(this.listenersRefs::decRef);
    }

    @Override
    public void close() {
        this.rootListenerRef.close();
    }

    public ActionListener<ChunkedRestResponseBodyPart> newEntryListener(String entryName, final Releasable releasable) {
        if (this.listenersRefs.tryIncRef()) {
            final ZipEntry zipEntry = new ZipEntry(this.filename + "/" + entryName);
            return ActionListener.assertOnce(ActionListener.releaseAfter(new ActionListener<ChunkedRestResponseBodyPart>(){

                @Override
                public void onResponse(ChunkedRestResponseBodyPart chunkedRestResponseBodyPart) {
                    if (chunkedRestResponseBodyPart == null) {
                        Releasables.closeExpectNoException(releasable);
                    } else {
                        ChunkedZipResponse.this.enqueueEntry(zipEntry, chunkedRestResponseBodyPart, releasable);
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    Releasables.closeExpectNoException(releasable);
                }

                public String toString() {
                    return "ZipEntry[" + zipEntry.getName() + "]";
                }
            }, this.listenersRefs::decRef));
        }
        assert (false) : "already closed";
        throw new AlreadyClosedException("response already closed");
    }

    private boolean tryAcquireQueueRef() {
        return !this.isRestResponseFinished.get() && this.queueRefs.tryIncRef();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void enqueueEntry(ZipEntry zipEntry, ChunkedRestResponseBodyPart firstBodyPart, Releasable releasable) {
        if (this.tryAcquireQueueRef()) {
            try {
                this.entryQueue.add(new ChunkedZipEntry(zipEntry, firstBodyPart, releasable));
                if (this.queueLength.getAndIncrement() != 0) return;
                ChunkedZipEntry nextEntry = this.entryQueue.poll();
                assert (nextEntry != null);
                AvailableChunksZipResponseBodyPart availableChunks = new AvailableChunksZipResponseBodyPart(nextEntry.zipEntry(), nextEntry.firstBodyPart());
                assert (this.currentEntryReleasable == null);
                this.currentEntryReleasable = nextEntry.releasable();
                SubscribableListener<ChunkedRestResponseBodyPart> currentAvailableChunksListener = this.nextAvailableChunksListener;
                this.nextAvailableChunksListener = new SubscribableListener();
                if (currentAvailableChunksListener == null) {
                    RestResponse restResponse = RestResponse.chunked(RestStatus.OK, availableChunks, this::restResponseFinished);
                    restResponse.addHeader("content-disposition", Strings.format("attachment; filename=\"%s.zip\"", this.filename));
                    this.restChannel.sendResponse(restResponse);
                    return;
                }
                currentAvailableChunksListener.onResponse(availableChunks);
                return;
            }
            finally {
                this.queueRefs.decRef();
            }
        } else {
            Releasables.closeExpectNoException(releasable);
        }
    }

    private void restResponseFinished() {
        assert (Transports.assertTransportThread());
        if (this.isRestResponseFinished.compareAndSet(false, true)) {
            this.queueRefs.decRef();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainQueue() {
        assert (this.isRestResponseFinished.get());
        assert (!this.queueRefs.hasReferences());
        int taskCount = this.queueLength.get() + 1;
        ArrayList<Releasable> releasables = new ArrayList<Releasable>(taskCount);
        try {
            ChunkedZipEntry entry;
            releasables.add(this.currentEntryReleasable);
            this.currentEntryReleasable = null;
            while ((entry = this.entryQueue.poll()) != null) {
                releasables.add(entry.releasable());
            }
            assert (this.entryQueue.isEmpty()) : this.entryQueue.size();
            assert (releasables.size() == taskCount || releasables.size() == taskCount - 1) : taskCount + " vs " + releasables.size();
        }
        finally {
            Releasables.closeExpectNoException(Releasables.wrap(releasables));
        }
    }

    private record ChunkedZipEntry(ZipEntry zipEntry, ChunkedRestResponseBodyPart firstBodyPart, Releasable releasable) {
    }

    private final class AvailableChunksZipResponseBodyPart
    implements ChunkedRestResponseBodyPart {
        @Nullable
        private ZipEntry zipEntry;
        private ChunkedRestResponseBodyPart bodyPart;
        private boolean isResponsePaused;
        private boolean isResponseComplete;
        private SubscribableListener<ChunkedRestResponseBodyPart> getNextPartListener;
        private ArrayList<Releasable> nextReleasablesCache = new ArrayList();

        AvailableChunksZipResponseBodyPart(ZipEntry zipEntry, ChunkedRestResponseBodyPart bodyPart) {
            this.zipEntry = zipEntry;
            this.bodyPart = bodyPart;
        }

        @Override
        public boolean isPartComplete() {
            return this.isResponsePaused || this.isResponseComplete;
        }

        @Override
        public boolean isLastPart() {
            return this.isResponseComplete;
        }

        @Override
        public void getNextPart(ActionListener<ChunkedRestResponseBodyPart> listener) {
            assert (this.getNextPartListener != null);
            this.getNextPartListener.addListener(listener);
        }

        private void transferCurrentEntryReleasable(ArrayList<Releasable> releasables) {
            assert (ChunkedZipResponse.this.queueRefs.hasReferences());
            if (ChunkedZipResponse.this.currentEntryReleasable == null) {
                return;
            }
            if (releasables == this.nextReleasablesCache) {
                this.nextReleasablesCache = new ArrayList();
            }
            releasables.add(ChunkedZipResponse.this.currentEntryReleasable);
            ChunkedZipResponse.this.currentEntryReleasable = null;
        }

        /*
         * Exception decompiling
         */
        @Override
        public ReleasableBytesReference encodeChunk(int sizeHint, Recycler<BytesRef> recycler) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeNextBytes(int sizeHint, Recycler<BytesRef> recycler, ArrayList<Releasable> releasables) throws IOException {
            try {
                if (this.bodyPart == NO_MORE_ENTRIES) {
                    this.finishResponse(releasables);
                    return;
                }
                if (this.zipEntry != null) {
                    ChunkedZipResponse.this.zipOutputStream.putNextEntry(this.zipEntry);
                    this.zipEntry = null;
                }
                if (!this.bodyPart.isPartComplete()) {
                    try (ReleasableBytesReference innerChunk = this.bodyPart.encodeChunk(sizeHint, recycler);){
                        BytesRef bytesRef;
                        BytesRefIterator iterator = innerChunk.iterator();
                        while ((bytesRef = iterator.next()) != null) {
                            ChunkedZipResponse.this.zipOutputStream.write(bytesRef.bytes, bytesRef.offset, bytesRef.length);
                        }
                    }
                }
                if (this.bodyPart.isPartComplete()) {
                    this.finishCurrentPart(releasables);
                }
            }
            finally {
                ChunkedZipResponse.this.zipOutputStream.flush();
            }
        }

        private void finishCurrentPart(ArrayList<Releasable> releasables) throws IOException {
            if (this.bodyPart.isLastPart()) {
                ChunkedZipResponse.this.zipOutputStream.closeEntry();
                this.transferCurrentEntryReleasable(releasables);
                int newQueueLength = ChunkedZipResponse.this.queueLength.decrementAndGet();
                if (newQueueLength == 0) {
                    this.isResponsePaused = true;
                    assert (this.getNextPartListener == null);
                    assert (ChunkedZipResponse.this.nextAvailableChunksListener != null);
                    this.getNextPartListener = ChunkedZipResponse.this.nextAvailableChunksListener;
                } else {
                    ChunkedZipEntry nextEntry = ChunkedZipResponse.this.entryQueue.poll();
                    assert (nextEntry != null);
                    this.zipEntry = nextEntry.zipEntry();
                    this.bodyPart = nextEntry.firstBodyPart();
                    ChunkedZipResponse.this.currentEntryReleasable = nextEntry.releasable();
                }
            } else {
                assert (ChunkedZipResponse.this.queueLength.get() > 0);
                this.isResponsePaused = true;
                assert (this.getNextPartListener == null);
                this.getNextPartListener = SubscribableListener.newForked(l -> this.bodyPart.getNextPart(l.map(p -> new AvailableChunksZipResponseBodyPart(null, (ChunkedRestResponseBodyPart)p))));
            }
        }

        private void finishResponse(ArrayList<Releasable> releasables) throws IOException {
            assert (this.zipEntry == null);
            assert (ChunkedZipResponse.this.entryQueue.isEmpty()) : ChunkedZipResponse.this.entryQueue.size();
            ChunkedZipResponse.this.zipOutputStream.finish();
            this.isResponseComplete = true;
            this.transferCurrentEntryReleasable(releasables);
            assert (this.getNextPartListener == null);
        }

        @Override
        public String getResponseContentTypeString() {
            return ChunkedZipResponse.ZIP_CONTENT_TYPE;
        }

        private static /* synthetic */ void lambda$encodeChunk$1() {
        }

        private static /* synthetic */ void lambda$encodeChunk$0(RecyclerBytesStreamOutput chunkStream) {
            Releasables.closeExpectNoException((Releasable)chunkStream);
        }
    }
}

