/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import java.io.IOException;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.xcontent.XContentParser;

public record IndexShardCount(int count) {
    public static IndexShardCount fromIndexMetadata(XContentParser parser) throws IOException {
        String currentFieldName;
        parser.nextToken();
        parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.currentToken(), parser);
        XContentParser.Token token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
        IndexShardCount indexShardCount = null;
        while ((currentFieldName = parser.nextFieldName()) != null) {
            token = parser.nextToken();
            if (token == XContentParser.Token.START_OBJECT) {
                if (currentFieldName.equals("settings")) {
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        String fieldName = parser.currentName();
                        parser.nextToken();
                        if ("index.number_of_shards".equals(fieldName)) {
                            assert (indexShardCount == null) : "number_of_shards setting encountered multiple times in index settings";
                            indexShardCount = new IndexShardCount(parser.intValue());
                            continue;
                        }
                        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                            throw new IllegalArgumentException("Settings object contains nested object for key [" + fieldName + "], expected flat settings map");
                        }
                        parser.skipChildren();
                    }
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                parser.skipChildren();
                continue;
            }
            if (token.isValue()) continue;
            throw new IllegalArgumentException("Unexpected token " + String.valueOf((Object)token));
        }
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.END_OBJECT, parser.nextToken(), parser);
        return indexShardCount != null ? indexShardCount : new IndexShardCount(-1);
    }
}

