/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.io.IOException;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public record ProjectRepo(ProjectId projectId, String name) implements Writeable
{
    public static final DiffableUtils.KeySerializer<ProjectRepo> PROJECT_REPO_SERIALIZER = new DiffableUtils.KeySerializer<ProjectRepo>(){

        @Override
        public void writeKey(ProjectRepo key, StreamOutput out) throws IOException {
            key.writeTo(out);
        }

        @Override
        public ProjectRepo readKey(StreamInput in) throws IOException {
            return new ProjectRepo(in);
        }
    };

    public ProjectRepo(StreamInput in) throws IOException {
        this(ProjectId.readFrom(in), in.readString());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.projectId.writeTo(out);
        out.writeString(this.name);
    }

    @Override
    public String toString() {
        return ProjectRepo.projectRepoString(this.projectId, this.name);
    }

    public static String projectRepoString(ProjectId projectId, String repositoryName) {
        return "[" + String.valueOf(projectId) + "/" + repositoryName + "]";
    }
}

