/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.protocol.xpack.watcher;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class PutWatchResponse
extends ActionResponse
implements ToXContentObject {
    private final String id;
    private final long version;
    private final long seqNo;
    private final long primaryTerm;
    private final boolean created;

    public PutWatchResponse(String id, long version, long seqNo, long primaryTerm, boolean created) {
        this.id = id;
        this.version = version;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.created = created;
    }

    public String getId() {
        return this.id;
    }

    public long getVersion() {
        return this.version;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public boolean isCreated() {
        return this.created;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutWatchResponse that = (PutWatchResponse)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.version, that.version) && Objects.equals(this.seqNo, that.seqNo) && Objects.equals(this.primaryTerm, that.primaryTerm) && Objects.equals(this.created, that.created);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version, this.seqNo, this.primaryTerm, this.created);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeVLong(this.version);
        out.writeZLong(this.seqNo);
        out.writeVLong(this.primaryTerm);
        out.writeBoolean(this.created);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field("_id", this.id).field("_version", this.version).field("_seq_no", this.seqNo).field("_primary_term", this.primaryTerm).field("created", this.created).endObject();
    }
}

