/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.spi.annotation;

import java.util.Map;
import org.elasticsearch.painless.spi.annotation.AliasAnnotation;
import org.elasticsearch.painless.spi.annotation.WhitelistAnnotationParser;

public class AliasAnnotationParser
implements WhitelistAnnotationParser {
    public static final AliasAnnotationParser INSTANCE = new AliasAnnotationParser();

    private AliasAnnotationParser() {
    }

    @Override
    public Object parse(Map<String, String> arguments) {
        if (arguments.size() != 1) {
            throw new IllegalArgumentException("[@alias] requires one alias");
        }
        AliasAnnotation annotation = null;
        for (Map.Entry<String, String> entry : arguments.entrySet()) {
            if (!"class".equals(entry.getKey())) {
                throw new IllegalArgumentException("[@alias] only supports class aliases");
            }
            String alias = entry.getValue();
            if (alias == null || alias.isBlank()) {
                throw new IllegalArgumentException("[@alias] must be non-empty");
            }
            annotation = new AliasAnnotation(alias);
        }
        return annotation;
    }
}

