/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.lucene.queries;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.mapper.blockloader.docvalues.CustomBinaryDocValuesReader;

public final class SlowCustomBinaryDocValuesTermQuery
extends Query {
    private final String fieldName;
    private final BytesRef term;

    public SlowCustomBinaryDocValuesTermQuery(String fieldName, BytesRef term) {
        this.fieldName = Objects.requireNonNull(fieldName);
        this.term = Objects.requireNonNull(term);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                final BinaryDocValues values = context.reader().getBinaryDocValues(SlowCustomBinaryDocValuesTermQuery.this.fieldName);
                if (values == null) {
                    return null;
                }
                TwoPhaseIterator iterator = new TwoPhaseIterator(values){
                    final CustomBinaryDocValuesReader reader;
                    {
                        super(arg0);
                        this.reader = new CustomBinaryDocValuesReader();
                    }

                    @Override
                    public boolean matches() throws IOException {
                        BytesRef binaryValue = values.binaryValue();
                        return this.reader.match(binaryValue, SlowCustomBinaryDocValuesTermQuery.this.term::equals);
                    }

                    @Override
                    public float matchCost() {
                        return 10.0f;
                    }
                };
                return new Weight.DefaultScorerSupplier(new ConstantScoreScorer(this.score(), scoreMode, iterator));
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable(ctx, SlowCustomBinaryDocValuesTermQuery.this.fieldName);
            }
        };
    }

    @Override
    public String toString(String field) {
        return "SlowCustomBinaryDocValuesTermQuery(fieldName=" + field + ",term=" + this.term.utf8ToString() + ")";
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.fieldName)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.sameClassAs(o)) {
            return false;
        }
        SlowCustomBinaryDocValuesTermQuery that = (SlowCustomBinaryDocValuesTermQuery)o;
        return Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.term, that.term);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.classHash(), this.fieldName, this.term);
    }
}

