/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.lucene.comparators;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.AbstractDocIdSetIterator;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.FixedBitSet;

public final class XUpdateableDocIdSetIterator
extends AbstractDocIdSetIterator {
    private DocIdSetIterator in = DocIdSetIterator.empty();

    public void update(DocIdSetIterator iterator) {
        this.in = Objects.requireNonNull(iterator);
    }

    @Override
    public int nextDoc() throws IOException {
        return this.advance(this.doc + 1);
    }

    @Override
    public int advance(int target) throws IOException {
        int curDoc = this.in.docID();
        if (curDoc < target) {
            curDoc = this.in.advance(target);
        }
        this.doc = curDoc;
        return this.doc;
    }

    @Override
    public long cost() {
        return this.in.cost();
    }

    @Override
    public void intoBitSet(int upTo, FixedBitSet bitSet, int offset) throws IOException {
        if (this.in.docID() < this.doc) {
            this.in.advance(this.doc);
        }
        this.in.intoBitSet(upTo, bitSet, offset);
        this.doc = this.in.docID();
    }

    @Override
    public int docIDRunEnd() throws IOException {
        if (this.in.docID() < this.doc) {
            this.in.advance(this.doc);
        }
        if (this.in.docID() == this.doc) {
            return this.in.docIDRunEnd();
        }
        return super.docIDRunEnd();
    }

    public DocIdSetIterator getDelegate() {
        return this.in;
    }
}

