/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.logstashbridge.ingest;

import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.logstashbridge.StableBridgeAPI;
import org.elasticsearch.logstashbridge.ingest.PipelineBridge;
import org.elasticsearch.logstashbridge.ingest.ProxyInternalIngestDocumentBridge;
import org.elasticsearch.logstashbridge.script.MetadataBridge;
import org.elasticsearch.logstashbridge.script.TemplateScriptFactoryBridge;

public interface IngestDocumentBridge
extends StableBridgeAPI<IngestDocument> {
    public MetadataBridge getMetadata();

    public Map<String, Object> getSource();

    public boolean updateIndexHistory(String var1);

    public Set<String> getIndexHistory();

    public boolean isReroute();

    public void resetReroute();

    public Map<String, Object> getIngestMetadata();

    public <T> T getFieldValue(String var1, Class<T> var2);

    public <T> T getFieldValue(String var1, Class<T> var2, boolean var3);

    public String renderTemplate(TemplateScriptFactoryBridge var1);

    public void setFieldValue(String var1, Object var2);

    public void removeField(String var1);

    public void executePipeline(PipelineBridge var1, BiConsumer<IngestDocumentBridge, Exception> var2);

    public static IngestDocumentBridge fromInternalNullable(IngestDocument ingestDocument) {
        if (ingestDocument == null) {
            return null;
        }
        return new ProxyInternalIngestDocumentBridge(ingestDocument);
    }

    public static IngestDocumentBridge create(Map<String, Object> sourceAndMetadata, Map<String, Object> ingestMetadata) {
        IngestDocument internal = new IngestDocument(sourceAndMetadata, ingestMetadata);
        return IngestDocumentBridge.fromInternalNullable(internal);
    }

    public static final class Constants {
        public static final String METADATA_VERSION_FIELD_NAME = IngestDocument.Metadata.VERSION.getFieldName();

        private Constants() {
        }
    }
}

