/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.local.TransportLocalClusterStateAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.GetBasicStatusRequest;
import org.elasticsearch.license.GetBasicStatusResponse;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicensesMetadata;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportGetBasicStatusAction
extends TransportLocalClusterStateAction<GetBasicStatusRequest, GetBasicStatusResponse> {
    public static final ActionType<GetBasicStatusResponse> TYPE = new ActionType("cluster:admin/xpack/license/basic_status");

    @Inject
    public TransportGetBasicStatusAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters) {
        super(TYPE.name(), actionFilters, transportService.getTaskManager(), clusterService, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        transportService.registerRequestHandler(this.actionName, this.executor, false, true, GetBasicStatusRequest::new, (request, channel, task) -> this.executeDirect(task, request, new ChannelActionListener(channel)));
    }

    @Override
    protected void localClusterStateOperation(Task task, GetBasicStatusRequest request, ClusterState state, ActionListener<GetBasicStatusResponse> listener) throws Exception {
        LicensesMetadata licensesMetadata = (LicensesMetadata)state.metadata().custom("licenses");
        if (licensesMetadata == null) {
            listener.onResponse(new GetBasicStatusResponse(true));
        } else {
            License license = licensesMetadata.getLicense();
            listener.onResponse(new GetBasicStatusResponse(license == null || !License.LicenseType.isBasic(license.type())));
        }
    }

    @Override
    protected ClusterBlockException checkBlock(GetBasicStatusRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

