/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip.direct;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public record DatabaseConfiguration(String id, String name, Provider provider) implements Writeable,
ToXContentObject
{
    private static final Pattern ID_PATTERN = Pattern.compile("\\p{Alnum}[_\\-\\p{Alnum}]{0,126}");
    public static final Set<String> MAXMIND_NAMES = Set.of("GeoIP2-Anonymous-IP", "GeoIP2-City", "GeoIP2-Connection-Type", "GeoIP2-Country", "GeoIP2-Domain", "GeoIP2-Enterprise", "GeoIP2-ISP");
    public static final Set<String> IPINFO_NAMES = Set.of("asn", "country", "standard_asn", "standard_location", "standard_privacy");
    private static final ParseField NAME = new ParseField("name", new String[0]);
    private static final ParseField MAXMIND = new ParseField("maxmind", new String[0]);
    private static final ParseField IPINFO = new ParseField("ipinfo", new String[0]);
    private static final ParseField WEB = new ParseField("web", new String[0]);
    private static final ParseField LOCAL = new ParseField("local", new String[0]);
    private static final ConstructingObjectParser<DatabaseConfiguration, String> PARSER = new ConstructingObjectParser<DatabaseConfiguration, String>("database", false, (a, id) -> {
        String name = (String)a[0];
        long numNonNulls = Arrays.stream(a, 1, ((Object[])a).length).filter(Objects::nonNull).count();
        if (numNonNulls != 1L) {
            throw new IllegalArgumentException("Exactly one provider object must be specified, but [" + numNonNulls + "] were found");
        }
        Record provider = a[1] != null ? (Maxmind)a[1] : (a[2] != null ? (Ipinfo)a[2] : (a[3] != null ? (Web)a[3] : (Local)a[4]));
        return new DatabaseConfiguration((String)id, name, (Provider)((Object)provider));
    });

    public DatabaseConfiguration {
        Objects.requireNonNull(id);
        Objects.requireNonNull(name);
        Objects.requireNonNull(provider);
    }

    public DatabaseConfiguration(StreamInput in) throws IOException {
        this(in.readString(), in.readString(), DatabaseConfiguration.readProvider(in));
    }

    private static Provider readProvider(StreamInput in) throws IOException {
        return in.readNamedWriteable(Provider.class);
    }

    public static DatabaseConfiguration parse(XContentParser parser, String id) {
        return PARSER.apply(parser, id);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeString(this.name);
        out.writeNamedWriteable(this.provider);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("name", this.name);
        builder.field(this.provider.getWriteableName(), this.provider);
        builder.endObject();
        return builder;
    }

    static void validateId(String id) throws IllegalArgumentException {
        if (Strings.isNullOrEmpty(id)) {
            throw new IllegalArgumentException("invalid database configuration id [" + id + "]: must not be null or empty");
        }
        MetadataCreateIndexService.validateIndexOrAliasName(id, (id1, description) -> new IllegalArgumentException("invalid database configuration id [" + id1 + "]: " + description));
        int byteCount = id.getBytes(StandardCharsets.UTF_8).length;
        if (byteCount > 127) {
            throw new IllegalArgumentException("invalid database configuration id [" + id + "]: id is too long, (" + byteCount + " > 127)");
        }
        if (!ID_PATTERN.matcher(id).matches()) {
            throw new IllegalArgumentException("invalid database configuration id [" + id + "]: id doesn't match required rules (alphanumerics, dashes, and underscores, only)");
        }
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException err = new ActionRequestValidationException();
        if (!Strings.hasText(this.name)) {
            err.addValidationError("invalid name [" + this.name + "]: cannot be empty");
        }
        if (this.provider instanceof Maxmind && !MAXMIND_NAMES.contains(this.name)) {
            err.addValidationError("invalid name [" + this.name + "]: must be a supported name ([" + String.valueOf(MAXMIND_NAMES) + "])");
        }
        if (this.provider instanceof Ipinfo && !IPINFO_NAMES.contains(this.name)) {
            err.addValidationError("invalid name [" + this.name + "]: must be a supported name ([" + String.valueOf(IPINFO_NAMES) + "])");
        }
        try {
            DatabaseConfiguration.validateId(this.id);
        }
        catch (IllegalArgumentException e) {
            err.addValidationError(e.getMessage());
        }
        return err.validationErrors().isEmpty() ? null : err;
    }

    public boolean isReadOnly() {
        return this.provider.isReadOnly();
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (parser, id) -> Maxmind.PARSER.apply(parser, null), MAXMIND);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (parser, id) -> Ipinfo.PARSER.apply(parser, null), IPINFO);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (parser, id) -> Web.PARSER.apply(parser, null), WEB);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (parser, id) -> Local.PARSER.apply(parser, null), LOCAL);
    }

    public static interface Provider
    extends NamedWriteable,
    ToXContentObject {
        public boolean isReadOnly();
    }

    public record Maxmind(String accountId) implements Provider
    {
        public static final String NAME = "maxmind";
        private static final ParseField ACCOUNT_ID = new ParseField("account_id", new String[0]);
        private static final ConstructingObjectParser<Maxmind, Void> PARSER = new ConstructingObjectParser<Maxmind, Void>("maxmind", false, (a, id) -> {
            String accountId = (String)a[0];
            return new Maxmind(accountId);
        });

        public Maxmind {
            Objects.requireNonNull(accountId);
        }

        public Maxmind(StreamInput in) throws IOException {
            this(in.readString());
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.accountId);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("account_id", this.accountId);
            builder.endObject();
            return builder;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), ACCOUNT_ID);
        }
    }

    public record Ipinfo() implements Provider
    {
        public static final String NAME = "ipinfo";
        private static final ObjectParser<Ipinfo, Void> PARSER = new ObjectParser("ipinfo", Ipinfo::new);

        public Ipinfo(StreamInput in) throws IOException {
            this();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.endObject();
            return builder;
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }
    }

    public record Local(String type) implements Provider
    {
        public static final String NAME = "local";
        private static final ParseField TYPE = new ParseField("type", new String[0]);
        private static final ConstructingObjectParser<Local, Void> PARSER = new ConstructingObjectParser<Local, Void>("database", false, (a, id) -> {
            String type = (String)a[0];
            return new Local(type);
        });

        public Local(StreamInput in) throws IOException {
            this(in.readString());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.type);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("type", this.type);
            builder.endObject();
            return builder;
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), TYPE);
        }
    }

    public record Web() implements Provider
    {
        public static final String NAME = "web";
        private static final ObjectParser<Web, Void> PARSER = new ObjectParser("database", Web::new);

        public Web(StreamInput in) throws IOException {
            this();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.endObject();
            return builder;
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }
    }
}

