/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.ingest.geoip.direct.DatabaseConfigurationMetadata;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;

public final class IngestGeoIpMetadata
implements Metadata.ProjectCustom {
    public static final String TYPE = "ingest_geoip";
    private static final ParseField DATABASES_FIELD = new ParseField("databases", new String[0]);
    public static final IngestGeoIpMetadata EMPTY = new IngestGeoIpMetadata(Map.of());
    private static final ConstructingObjectParser<IngestGeoIpMetadata, Void> PARSER = new ConstructingObjectParser("ingest_geoip", a -> new IngestGeoIpMetadata(((List)a[0]).stream().collect(Collectors.toMap(m -> m.database().id(), Function.identity()))));
    private final Map<String, DatabaseConfigurationMetadata> databases;

    public IngestGeoIpMetadata(Map<String, DatabaseConfigurationMetadata> databases) {
        this.databases = Map.copyOf(databases);
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.minimumCompatible();
    }

    public Map<String, DatabaseConfigurationMetadata> getDatabases() {
        return this.databases;
    }

    public IngestGeoIpMetadata(StreamInput in) throws IOException {
        this.databases = in.readMap(StreamInput::readString, DatabaseConfigurationMetadata::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.databases, StreamOutput::writeWriteable);
    }

    public static IngestGeoIpMetadata fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params ignored) {
        return ChunkedToXContentHelper.xContentObjectFields(DATABASES_FIELD.getPreferredName(), this.databases);
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    @Override
    public Diff<Metadata.ProjectCustom> diff(Metadata.ProjectCustom before) {
        return new GeoIpMetadataDiff((IngestGeoIpMetadata)before, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngestGeoIpMetadata that = (IngestGeoIpMetadata)o;
        return Objects.equals(this.databases, that.databases);
    }

    public int hashCode() {
        return Objects.hash(this.databases);
    }

    static {
        PARSER.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, n) -> DatabaseConfigurationMetadata.parse(p, n), v -> {
            throw new IllegalArgumentException("ordered " + DATABASES_FIELD.getPreferredName() + " are not supported");
        }, DATABASES_FIELD);
    }

    static class GeoIpMetadataDiff
    implements NamedDiff<Metadata.ProjectCustom> {
        final Diff<Map<String, DatabaseConfigurationMetadata>> databases;

        GeoIpMetadataDiff(IngestGeoIpMetadata before, IngestGeoIpMetadata after) {
            this.databases = DiffableUtils.diff(before.databases, after.databases, DiffableUtils.getStringKeySerializer());
        }

        GeoIpMetadataDiff(StreamInput in) throws IOException {
            this.databases = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), DatabaseConfigurationMetadata::new, DatabaseConfigurationMetadata::readDiffFrom);
        }

        @Override
        public Metadata.ProjectCustom apply(Metadata.ProjectCustom part) {
            return new IngestGeoIpMetadata(this.databases.apply(((IngestGeoIpMetadata)part).databases));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.databases.writeTo(out);
        }

        @Override
        public String getWriteableName() {
            return IngestGeoIpMetadata.TYPE;
        }

        @Override
        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersion.minimumCompatible();
        }
    }
}

