/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class AbstractGeoIpDownloader
extends AllocatedPersistentTask {
    private final Logger logger;
    private final ThreadPool threadPool;
    private volatile Scheduler.ScheduledCancellable scheduledPeriodicRun;
    private final AtomicInteger queuedRuns = new AtomicInteger(0);
    private final Supplier<TimeValue> pollIntervalSupplier;

    public AbstractGeoIpDownloader(long id, String type, String action, String description, TaskId parentTask, Map<String, String> headers, ThreadPool threadPool, Supplier<TimeValue> pollIntervalSupplier) {
        super(id, type, action, description, parentTask, headers);
        this.logger = LogManager.getLogger(this.getClass());
        this.threadPool = threadPool;
        this.pollIntervalSupplier = pollIntervalSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartPeriodicRun() {
        if (this.isCancelled() || this.isCompleted() || this.threadPool.scheduler().isShutdown()) {
            this.logger.debug("Not restarting periodic run because task is cancelled, completed, or shutting down");
            return;
        }
        this.logger.debug("Restarting periodic run");
        AbstractGeoIpDownloader abstractGeoIpDownloader = this;
        synchronized (abstractGeoIpDownloader) {
            if (this.scheduledPeriodicRun != null) {
                boolean cancelSuccessful = this.scheduledPeriodicRun.cancel();
                this.logger.debug("Cancelled scheduled run: [{}]", (Object)cancelSuccessful);
            }
            this.scheduledPeriodicRun = this.threadPool.schedule(this::runPeriodic, this.pollIntervalSupplier.get(), this.threadPool.generic());
        }
        this.requestRunOnDemand();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPeriodic() {
        if (this.isCancelled() || this.isCompleted() || this.threadPool.scheduler().isShutdown()) {
            this.logger.debug("Not running periodic downloader because task is cancelled, completed, or shutting down");
            return;
        }
        this.logger.trace("Running periodic downloader");
        this.requestRunOnDemand();
        AbstractGeoIpDownloader abstractGeoIpDownloader = this;
        synchronized (abstractGeoIpDownloader) {
            this.scheduledPeriodicRun = this.threadPool.schedule(this::runPeriodic, this.pollIntervalSupplier.get(), this.threadPool.generic());
        }
    }

    public void requestRunOnDemand() {
        if (this.isCancelled() || this.isCompleted()) {
            this.logger.debug("Not requesting downloader to run on demand because task is cancelled or completed");
            return;
        }
        this.logger.trace("Requesting downloader run on demand");
        if (this.queuedRuns.getAndIncrement() == 0) {
            this.logger.trace("Scheduling downloader run on demand");
            this.threadPool.generic().submit(this::runOnDemand);
        }
    }

    private void runOnDemand() {
        if (this.isCancelled() || this.isCompleted()) {
            this.logger.debug("Not running downloader on demand because task is cancelled or completed");
            return;
        }
        int currentQueueSize = this.queuedRuns.get();
        this.logger.trace("Running downloader on demand");
        try {
            this.runDownloader();
            this.logger.trace("Downloader completed successfully");
        }
        finally {
            if (this.queuedRuns.addAndGet(-currentQueueSize) > 0) {
                this.logger.debug("Downloader on demand requested again while running, scheduling another run");
                this.threadPool.generic().submit(this::runOnDemand);
            }
        }
    }

    abstract void runDownloader();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onCancelled() {
        AbstractGeoIpDownloader abstractGeoIpDownloader = this;
        synchronized (abstractGeoIpDownloader) {
            if (this.scheduledPeriodicRun != null) {
                this.scheduledPeriodicRun.cancel();
            }
        }
        this.markAsCompleted();
    }
}

