/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.IngestMetric;
import org.elasticsearch.ingest.IngestProcessorException;
import org.elasticsearch.ingest.Processor;

public class CompoundProcessor
implements Processor {
    public static final String ON_FAILURE_MESSAGE_FIELD = "on_failure_message";
    public static final String ON_FAILURE_PROCESSOR_TYPE_FIELD = "on_failure_processor_type";
    public static final String ON_FAILURE_PROCESSOR_TAG_FIELD = "on_failure_processor_tag";
    public static final String ON_FAILURE_PIPELINE_FIELD = "on_failure_pipeline";
    public static final String PROCESSOR_TYPE_EXCEPTION_HEADER = "processor_type";
    public static final String PROCESSOR_TAG_EXCEPTION_HEADER = "processor_tag";
    public static final String PIPELINE_ORIGIN_EXCEPTION_HEADER = "pipeline_origin";
    private final boolean ignoreFailure;
    private final List<Processor> processors;
    private final List<Processor> onFailureProcessors;
    private final List<Tuple<Processor, IngestMetric>> processorsWithMetrics;
    private final LongSupplier relativeTimeProvider;
    private final boolean isAsync;

    public CompoundProcessor(Processor ... processors) {
        this(false, List.of(processors), List.of());
    }

    public CompoundProcessor(boolean ignoreFailure, List<Processor> processors, List<Processor> onFailureProcessors) {
        this(ignoreFailure, processors, onFailureProcessors, System::nanoTime);
    }

    CompoundProcessor(boolean ignoreFailure, List<Processor> processors, List<Processor> onFailureProcessors, LongSupplier relativeTimeProvider) {
        this.ignoreFailure = ignoreFailure;
        this.processors = List.copyOf(processors);
        this.onFailureProcessors = List.copyOf(onFailureProcessors);
        this.relativeTimeProvider = relativeTimeProvider;
        this.processorsWithMetrics = List.copyOf(processors.stream().map(p -> new Tuple<Processor, IngestMetric>((Processor)p, new IngestMetric())).toList());
        this.isAsync = this.flattenProcessors().stream().anyMatch(Processor::isAsync);
    }

    List<Tuple<Processor, IngestMetric>> getProcessorsWithMetrics() {
        return this.processorsWithMetrics;
    }

    public boolean isIgnoreFailure() {
        return this.ignoreFailure;
    }

    public List<Processor> getOnFailureProcessors() {
        return this.onFailureProcessors;
    }

    public List<Processor> getProcessors() {
        return this.processors;
    }

    public List<Processor> flattenProcessors() {
        ArrayList<Processor> allProcessors = new ArrayList<Processor>(CompoundProcessor.flattenProcessors(this.processors));
        allProcessors.addAll(CompoundProcessor.flattenProcessors(this.onFailureProcessors));
        return allProcessors;
    }

    private static List<Processor> flattenProcessors(List<Processor> processors) {
        ArrayList<Processor> flattened = new ArrayList<Processor>();
        for (Processor processor : processors) {
            if (processor instanceof CompoundProcessor) {
                CompoundProcessor compoundProcessor = (CompoundProcessor)processor;
                flattened.addAll(compoundProcessor.flattenProcessors());
                continue;
            }
            flattened.add(processor);
        }
        return flattened;
    }

    @Override
    public String getType() {
        return "compound";
    }

    @Override
    public String getTag() {
        return "CompoundProcessor-" + this.flattenProcessors().stream().map(CompoundProcessor::processorDescription).collect(Collectors.joining("-"));
    }

    private static String processorDescription(Processor p) {
        return p.getTag() != null ? p.getTag() : p.getType();
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public boolean isAsync() {
        return this.isAsync;
    }

    @Override
    public IngestDocument execute(IngestDocument document) throws Exception {
        assert (!this.isAsync);
        IngestDocument[] docHolder = new IngestDocument[1];
        Exception[] exHolder = new Exception[1];
        this.innerExecute(0, document, (result, e) -> {
            docHolder[0] = result;
            exHolder[0] = e;
        });
        if (exHolder[0] != null) {
            throw exHolder[0];
        }
        return docHolder[0];
    }

    @Override
    public void execute(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        this.innerExecute(0, ingestDocument, handler);
    }

    void innerExecute(int currentProcessor, IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        assert (currentProcessor <= this.processorsWithMetrics.size());
        if (currentProcessor == this.processorsWithMetrics.size() || ingestDocument.isReroute() || ingestDocument.isTerminate()) {
            handler.accept(ingestDocument, null);
            return;
        }
        while (!(currentProcessor >= this.processorsWithMetrics.size() || this.processorsWithMetrics.get(currentProcessor).v1().isAsync() || ingestDocument.isReroute() || ingestDocument.isTerminate())) {
            Tuple<Processor, IngestMetric> processorWithMetric = this.processorsWithMetrics.get(currentProcessor);
            Processor processor = processorWithMetric.v1();
            IngestMetric metric = processorWithMetric.v2();
            metric.preIngest();
            long startTimeInNanos = this.relativeTimeProvider.getAsLong();
            try {
                ingestDocument = processor.execute(ingestDocument);
                long ingestTimeInNanos = this.relativeTimeProvider.getAsLong() - startTimeInNanos;
                metric.postIngest(ingestTimeInNanos);
                if (ingestDocument == null) {
                    handler.accept(null, null);
                    return;
                }
            }
            catch (Exception e2) {
                long ingestTimeInNanos = this.relativeTimeProvider.getAsLong() - startTimeInNanos;
                metric.postIngest(ingestTimeInNanos);
                this.executeOnFailureOuter(currentProcessor, ingestDocument, handler, processor, metric, e2);
                return;
            }
            ++currentProcessor;
        }
        assert (currentProcessor <= this.processorsWithMetrics.size());
        if (currentProcessor == this.processorsWithMetrics.size() || ingestDocument.isReroute() || ingestDocument.isTerminate()) {
            handler.accept(ingestDocument, null);
            return;
        }
        int finalCurrentProcessor = currentProcessor;
        int nextProcessor = currentProcessor + 1;
        long startTimeInNanos = this.relativeTimeProvider.getAsLong();
        IngestMetric finalMetric = this.processorsWithMetrics.get(currentProcessor).v2();
        Processor finalProcessor = this.processorsWithMetrics.get(currentProcessor).v1();
        IngestDocument finalIngestDocument = ingestDocument;
        finalMetric.preIngest();
        try {
            finalProcessor.execute(ingestDocument, (result, e) -> {
                long ingestTimeInNanos = this.relativeTimeProvider.getAsLong() - startTimeInNanos;
                finalMetric.postIngest(ingestTimeInNanos);
                if (e != null) {
                    this.executeOnFailureOuter(finalCurrentProcessor, finalIngestDocument, handler, finalProcessor, finalMetric, (Exception)e);
                } else if (result != null) {
                    this.innerExecute(nextProcessor, (IngestDocument)result, handler);
                } else {
                    handler.accept(null, null);
                }
            });
        }
        catch (Exception e3) {
            long ingestTimeInNanos = this.relativeTimeProvider.getAsLong() - startTimeInNanos;
            finalMetric.postIngest(ingestTimeInNanos);
            this.executeOnFailureOuter(finalCurrentProcessor, finalIngestDocument, handler, finalProcessor, finalMetric, e3);
        }
    }

    private void executeOnFailureOuter(int currentProcessor, IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler, Processor processor, IngestMetric metric, Exception e) {
        metric.ingestFailed();
        if (this.ignoreFailure) {
            this.innerExecute(currentProcessor + 1, ingestDocument, handler);
        } else {
            IngestProcessorException compoundProcessorException = CompoundProcessor.newCompoundProcessorException(e, processor, ingestDocument);
            if (this.onFailureProcessors.isEmpty()) {
                handler.accept(null, compoundProcessorException);
            } else {
                this.executeOnFailure(0, ingestDocument, compoundProcessorException, handler);
            }
        }
    }

    void executeOnFailure(int currentOnFailureProcessor, IngestDocument ingestDocument, ElasticsearchException exception, BiConsumer<IngestDocument, Exception> handler) {
        if (currentOnFailureProcessor == 0) {
            CompoundProcessor.putFailureMetadata(ingestDocument, exception);
        }
        if (currentOnFailureProcessor == this.onFailureProcessors.size()) {
            CompoundProcessor.removeFailureMetadata(ingestDocument);
            handler.accept(ingestDocument, null);
            return;
        }
        Processor onFailureProcessor = this.onFailureProcessors.get(currentOnFailureProcessor);
        if (onFailureProcessor.isAsync()) {
            IngestDocument finalDoc = ingestDocument;
            onFailureProcessor.execute(finalDoc, (result, e) -> {
                if (e != null) {
                    CompoundProcessor.removeFailureMetadata(finalDoc);
                    handler.accept(null, CompoundProcessor.newCompoundProcessorException(e, onFailureProcessor, finalDoc));
                    return;
                }
                if (result == null) {
                    CompoundProcessor.removeFailureMetadata(finalDoc);
                    handler.accept(null, null);
                    return;
                }
                this.executeOnFailure(currentOnFailureProcessor + 1, finalDoc, exception, handler);
            });
        } else {
            try {
                ingestDocument = onFailureProcessor.execute(ingestDocument);
                if (ingestDocument == null) {
                    handler.accept(null, null);
                    return;
                }
            }
            catch (Exception e2) {
                if (ingestDocument != null) {
                    CompoundProcessor.removeFailureMetadata(ingestDocument);
                }
                handler.accept(null, CompoundProcessor.newCompoundProcessorException(e2, onFailureProcessor, ingestDocument));
                return;
            }
            this.executeOnFailure(currentOnFailureProcessor + 1, ingestDocument, exception, handler);
        }
    }

    private static void putFailureMetadata(IngestDocument ingestDocument, ElasticsearchException cause) {
        List<String> processorTypeHeader = cause.getBodyHeader(PROCESSOR_TYPE_EXCEPTION_HEADER);
        List<String> processorTagHeader = cause.getBodyHeader(PROCESSOR_TAG_EXCEPTION_HEADER);
        List<String> processorOriginHeader = cause.getBodyHeader(PIPELINE_ORIGIN_EXCEPTION_HEADER);
        String failedProcessorType = processorTypeHeader != null ? processorTypeHeader.get(0) : null;
        String failedProcessorTag = processorTagHeader != null ? processorTagHeader.get(0) : null;
        String failedPipelineId = processorOriginHeader != null ? processorOriginHeader.get(0) : null;
        Map<String, Object> ingestMetadata = ingestDocument.getIngestMetadata();
        ingestMetadata.put(ON_FAILURE_MESSAGE_FIELD, cause.getRootCause().getMessage());
        ingestMetadata.put(ON_FAILURE_PROCESSOR_TYPE_FIELD, failedProcessorType);
        ingestMetadata.put(ON_FAILURE_PROCESSOR_TAG_FIELD, failedProcessorTag);
        if (failedPipelineId != null) {
            ingestMetadata.put(ON_FAILURE_PIPELINE_FIELD, failedPipelineId);
        }
    }

    private static void removeFailureMetadata(IngestDocument ingestDocument) {
        Map<String, Object> ingestMetadata = ingestDocument.getIngestMetadata();
        ingestMetadata.remove(ON_FAILURE_MESSAGE_FIELD);
        ingestMetadata.remove(ON_FAILURE_PROCESSOR_TYPE_FIELD);
        ingestMetadata.remove(ON_FAILURE_PROCESSOR_TAG_FIELD);
        ingestMetadata.remove(ON_FAILURE_PIPELINE_FIELD);
    }

    static IngestProcessorException newCompoundProcessorException(Exception e, Processor processor, IngestDocument document) {
        List<String> pipelineStack;
        String processorTag;
        IngestProcessorException ipe;
        if (e instanceof IngestProcessorException && (ipe = (IngestProcessorException)e).getBodyHeader(PROCESSOR_TYPE_EXCEPTION_HEADER) != null) {
            return ipe;
        }
        IngestProcessorException exception = new IngestProcessorException(e);
        String processorType = processor.getType();
        if (processorType != null) {
            exception.addBodyHeader(PROCESSOR_TYPE_EXCEPTION_HEADER, processorType);
        }
        if ((processorTag = processor.getTag()) != null) {
            exception.addBodyHeader(PROCESSOR_TAG_EXCEPTION_HEADER, processorTag);
        }
        if (document != null && !(pipelineStack = document.getPipelineStack()).isEmpty()) {
            exception.addBodyHeader(PIPELINE_ORIGIN_EXCEPTION_HEADER, pipelineStack);
        }
        return exception;
    }
}

