/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.inference;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public record MinimalServiceSettings(@Nullable String service, TaskType taskType, @Nullable Integer dimensions, @Nullable SimilarityMeasure similarity, @Nullable DenseVectorFieldMapper.ElementType elementType) implements ServiceSettings,
SimpleDiffable<MinimalServiceSettings>
{
    public static final String NAME = "minimal_service_settings";
    public static final String SERVICE_FIELD = "service";
    public static final String TASK_TYPE_FIELD = "task_type";
    static final String DIMENSIONS_FIELD = "dimensions";
    static final String SIMILARITY_FIELD = "similarity";
    static final String ELEMENT_TYPE_FIELD = "element_type";
    private static final ConstructingObjectParser<MinimalServiceSettings, Void> PARSER = new ConstructingObjectParser("model_settings", true, args -> {
        String service = (String)args[0];
        TaskType taskType = TaskType.fromString((String)args[1]);
        Integer dimensions = (Integer)args[2];
        SimilarityMeasure similarity = args[3] == null ? null : SimilarityMeasure.fromString((String)args[3]);
        DenseVectorFieldMapper.ElementType elementType = args[4] == null ? null : DenseVectorFieldMapper.ElementType.fromString((String)args[4]);
        return new MinimalServiceSettings(service, taskType, dimensions, similarity, elementType);
    });
    private static final String UNKNOWN_SERVICE = "_unknown_";
    private static final TransportVersion INFERENCE_MODEL_REGISTRY_METADATA;

    public MinimalServiceSettings {
        Objects.requireNonNull(taskType, "task type must not be null");
        MinimalServiceSettings.validate(taskType, dimensions, similarity, elementType);
    }

    public MinimalServiceSettings(Model model) {
        this(model.getConfigurations().getService(), model.getTaskType(), model.getServiceSettings().dimensions(), model.getServiceSettings().similarity(), model.getServiceSettings().elementType());
    }

    public MinimalServiceSettings(StreamInput in) throws IOException {
        this(in.readOptionalString(), TaskType.fromStream(in), in.readOptionalInt(), in.readOptionalEnum(SimilarityMeasure.class), in.readOptionalEnum(DenseVectorFieldMapper.ElementType.class));
    }

    public static MinimalServiceSettings parse(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public static MinimalServiceSettings textEmbedding(String serviceName, int dimensions, SimilarityMeasure similarity, DenseVectorFieldMapper.ElementType elementType) {
        return new MinimalServiceSettings(serviceName, TaskType.TEXT_EMBEDDING, dimensions, similarity, elementType);
    }

    public static MinimalServiceSettings sparseEmbedding(String serviceName) {
        return new MinimalServiceSettings(serviceName, TaskType.SPARSE_EMBEDDING, null, null, null);
    }

    public static MinimalServiceSettings rerank(String serviceName) {
        return new MinimalServiceSettings(serviceName, TaskType.RERANK, null, null, null);
    }

    public static MinimalServiceSettings completion(String serviceName) {
        return new MinimalServiceSettings(serviceName, TaskType.COMPLETION, null, null, null);
    }

    public static MinimalServiceSettings chatCompletion(String serviceName) {
        return new MinimalServiceSettings(serviceName, TaskType.CHAT_COMPLETION, null, null, null);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.service);
        this.taskType.writeTo(out);
        out.writeOptionalInt(this.dimensions);
        out.writeOptionalEnum(this.similarity);
        out.writeOptionalEnum(this.elementType);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return INFERENCE_MODEL_REGISTRY_METADATA;
    }

    @Override
    public boolean supportsVersion(TransportVersion version) {
        return version.supports(INFERENCE_MODEL_REGISTRY_METADATA);
    }

    @Override
    public ToXContentObject getFilteredXContentObject() {
        return this::toXContent;
    }

    @Override
    public String modelId() {
        return null;
    }

    public static Diff<MinimalServiceSettings> readDiffFrom(StreamInput in) throws IOException {
        return SimpleDiffable.readDiffFrom(MinimalServiceSettings::new, in);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.service != null) {
            builder.field(SERVICE_FIELD, this.service);
        }
        builder.field(TASK_TYPE_FIELD, this.taskType.toString());
        if (this.dimensions != null) {
            builder.field(DIMENSIONS_FIELD, this.dimensions);
        }
        if (this.similarity != null) {
            builder.field(SIMILARITY_FIELD, this.similarity);
        }
        if (this.elementType != null) {
            builder.field(ELEMENT_TYPE_FIELD, this.elementType);
        }
        return builder.endObject();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("service=").append(this.service);
        sb.append(", task_type=").append(this.taskType);
        if (this.dimensions != null) {
            sb.append(", dimensions=").append(this.dimensions);
        }
        if (this.similarity != null) {
            sb.append(", similarity=").append((Object)this.similarity);
        }
        if (this.elementType != null) {
            sb.append(", element_type=").append((Object)this.elementType);
        }
        return sb.toString();
    }

    private static void validate(TaskType taskType, Integer dimensions, SimilarityMeasure similarity, DenseVectorFieldMapper.ElementType elementType) {
        switch (taskType) {
            case TEXT_EMBEDDING: 
            case EMBEDDING: {
                MinimalServiceSettings.validateFieldPresent(DIMENSIONS_FIELD, dimensions, taskType);
                MinimalServiceSettings.validateFieldPresent(SIMILARITY_FIELD, (Object)similarity, taskType);
                MinimalServiceSettings.validateFieldPresent(ELEMENT_TYPE_FIELD, (Object)elementType, taskType);
                break;
            }
            default: {
                MinimalServiceSettings.validateFieldNotPresent(DIMENSIONS_FIELD, dimensions, taskType);
                MinimalServiceSettings.validateFieldNotPresent(SIMILARITY_FIELD, (Object)similarity, taskType);
                MinimalServiceSettings.validateFieldNotPresent(ELEMENT_TYPE_FIELD, (Object)elementType, taskType);
            }
        }
    }

    private static void validateFieldPresent(String field, Object fieldValue, TaskType taskType) {
        if (fieldValue == null) {
            throw new IllegalArgumentException("required [" + field + "] field is missing for task_type [" + taskType.name() + "]");
        }
    }

    private static void validateFieldNotPresent(String field, Object fieldValue, TaskType taskType) {
        if (fieldValue != null) {
            throw new IllegalArgumentException("[" + field + "] is not allowed for task_type [" + taskType.name() + "]");
        }
    }

    public boolean canMergeWith(MinimalServiceSettings other) {
        return this.taskType == other.taskType && Objects.equals(this.dimensions, other.dimensions) && this.similarity == other.similarity && this.elementType == other.elementType;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(SERVICE_FIELD, new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(TASK_TYPE_FIELD, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField(DIMENSIONS_FIELD, new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(SIMILARITY_FIELD, new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(ELEMENT_TYPE_FIELD, new String[0]));
        INFERENCE_MODEL_REGISTRY_METADATA = TransportVersion.fromName("inference_model_registry_metadata");
    }
}

