/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.inference;

import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public record InferenceString(DataType dataType, DataFormat dataFormat, String value) implements Writeable,
ToXContentObject
{
    private static final String TYPE_FIELD = "type";
    private static final String FORMAT_FIELD = "format";
    private static final String VALUE_FIELD = "value";
    static final ConstructingObjectParser<InferenceString, Void> PARSER = new ConstructingObjectParser(InferenceString.class.getSimpleName(), args -> new InferenceString((DataType)((Object)((Object)args[0])), (DataFormat)((Object)((Object)args[1])), (String)args[2]));

    public InferenceString(DataType dataType, String value) {
        this(dataType, null, value);
    }

    public InferenceString(DataType dataType, @Nullable DataFormat dataFormat, String value) {
        this.dataType = Objects.requireNonNull(dataType);
        this.dataFormat = Objects.requireNonNullElse(dataFormat, this.dataType.defaultFormat);
        this.validateTypeAndFormat();
        this.value = Objects.requireNonNull(value);
    }

    public InferenceString(StreamInput in) throws IOException {
        this(in.readEnum(DataType.class), in.readEnum(DataFormat.class), in.readString());
    }

    private void validateTypeAndFormat() {
        if (!InferenceString.supportedFormatsForType(this.dataType).contains((Object)this.dataFormat)) {
            throw new IllegalArgumentException(Strings.format("Data type [%s] does not support data format [%s], supported formats are %s", new Object[]{this.dataType, this.dataFormat, InferenceString.supportedFormatsForType(this.dataType)}));
        }
    }

    public boolean isImage() {
        return DataType.IMAGE.equals((Object)this.dataType);
    }

    public boolean isText() {
        return DataType.TEXT.equals((Object)this.dataType);
    }

    public static EnumSet<DataFormat> supportedFormatsForType(DataType type) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> EnumSet.of(DataFormat.TEXT);
            case 1 -> EnumSet.of(DataFormat.BASE64);
        };
    }

    public static List<String> toStringList(List<InferenceString> inferenceStrings) {
        return inferenceStrings.stream().map(InferenceString::textValue).toList();
    }

    public static String textValue(InferenceString inferenceString) {
        assert (inferenceString.isText()) : "Non-text input returned from InferenceString.textValue";
        return inferenceString.value();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this.dataType);
        out.writeEnum(this.dataFormat);
        out.writeString(this.value);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TYPE_FIELD, this.dataType);
        builder.field(FORMAT_FIELD, this.dataFormat);
        builder.field(VALUE_FIELD, this.value);
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), DataType::fromString, new ParseField(TYPE_FIELD, new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), DataFormat::fromString, new ParseField(FORMAT_FIELD, new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(VALUE_FIELD, new String[0]));
    }

    public static enum DataType {
        TEXT(DataFormat.TEXT),
        IMAGE(DataFormat.BASE64);

        private final DataFormat defaultFormat;

        private DataType(DataFormat defaultFormat) {
            this.defaultFormat = defaultFormat;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static DataType fromString(String name) {
            try {
                return DataType.valueOf(name.trim().toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException(Strings.format("Unrecognized type [%s], must be one of %s", name, Arrays.toString((Object[])DataType.values())));
            }
        }
    }

    public static enum DataFormat {
        TEXT,
        BASE64;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static DataFormat fromString(String name) {
            try {
                return DataFormat.valueOf(name.trim().toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException(Strings.format("Unrecognized format [%s], must be one of %s", name, Arrays.toString((Object[])DataFormat.values())));
            }
        }
    }
}

