/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.inference;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InferenceStringGroup;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;

public record EmbeddingRequest(List<InferenceStringGroup> inputs, InputType inputType) implements Writeable,
ToXContentFragment
{
    private static final String INPUT_FIELD = "input";
    private static final String INPUT_TYPE_FIELD = "input_type";
    public static final ConstructingObjectParser<EmbeddingRequest, Void> PARSER = new ConstructingObjectParser(EmbeddingRequest.class.getSimpleName(), args -> new EmbeddingRequest((List)args[0], (InputType)((Object)((Object)args[1]))));

    public EmbeddingRequest(List<InferenceStringGroup> inputs, @Nullable InputType inputType) {
        this.inputs = inputs;
        this.inputType = Objects.requireNonNullElse(inputType, InputType.UNSPECIFIED);
    }

    public EmbeddingRequest(StreamInput in) throws IOException {
        this(in.readCollectionAsImmutableList(InferenceStringGroup::new), in.readEnum(InputType.class));
    }

    public static EmbeddingRequest of(List<InferenceStringGroup> contents) {
        return new EmbeddingRequest(contents, null);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.inputs);
        out.writeEnum(this.inputType);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(INPUT_FIELD, (Iterable<?>)this.inputs);
        builder.field(INPUT_TYPE_FIELD, this.inputType);
        return builder;
    }

    private static List<InferenceStringGroup> parseInput(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_STRING || token == XContentParser.Token.START_OBJECT) {
            return Collections.singletonList(InferenceStringGroup.parse(parser));
        }
        if (token == XContentParser.Token.START_ARRAY) {
            return XContentParserUtils.parseList(parser, InferenceStringGroup::parse);
        }
        throw new XContentParseException("Unsupported token [" + String.valueOf((Object)token) + "]");
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (parser, context) -> EmbeddingRequest.parseInput(parser), new ParseField(INPUT_FIELD, new String[0]), ObjectParser.ValueType.OBJECT_ARRAY_OR_STRING);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (parser, context) -> InputType.fromString(parser.text()), new ParseField(INPUT_TYPE_FIELD, new String[0]), ObjectParser.ValueType.STRING);
    }
}

