/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import org.apache.lucene.misc.store.DirectIODirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FileSwitchDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.store.ReadAdvice;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.StandardIOBehaviorHint;
import org.elasticsearch.index.codec.vectors.es818.DirectIOHint;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.store.AsyncDirectIOIndexInput;
import org.elasticsearch.index.store.LuceneFilesExtensions;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.plugins.IndexStorePlugin;

public class FsDirectoryFactory
implements IndexStorePlugin.DirectoryFactory {
    private static final Logger Log = LogManager.getLogger(FsDirectoryFactory.class);
    private static final int sharedArenaMaxPermits;
    public static final Setting<LockFactory> INDEX_LOCK_FACTOR_SETTING;
    public static final Setting<Integer> ASYNC_PREFETCH_LIMIT;

    @Override
    public Directory newDirectory(IndexSettings indexSettings, ShardPath path) throws IOException {
        Path location = path.resolveIndex();
        LockFactory lockFactory = indexSettings.getValue(INDEX_LOCK_FACTOR_SETTING);
        Files.createDirectories(location, new FileAttribute[0]);
        return this.newFSDirectory(location, lockFactory, indexSettings);
    }

    protected Directory newFSDirectory(Path location, LockFactory lockFactory, IndexSettings indexSettings) throws IOException {
        int asyncPrefetchLimit = indexSettings.getValue(ASYNC_PREFETCH_LIMIT);
        String storeType = indexSettings.getSettings().get(IndexModule.INDEX_STORE_TYPE_SETTING.getKey(), IndexModule.Type.FS.getSettingsKey());
        IndexModule.Type type = IndexModule.Type.FS.match(storeType) ? IndexModule.defaultStoreType(IndexModule.NODE_STORE_ALLOW_MMAP.get(indexSettings.getNodeSettings())) : IndexModule.Type.fromSettingsKey(storeType);
        HashSet<String> preLoadExtensions = new HashSet<String>((Collection)indexSettings.getValue(IndexModule.INDEX_STORE_PRE_LOAD_SETTING));
        switch (type) {
            case HYBRIDFS: {
                FSDirectory primaryDirectory = FSDirectory.open(location, lockFactory);
                if (primaryDirectory instanceof MMapDirectory) {
                    MMapDirectory mMapDirectory = (MMapDirectory)primaryDirectory;
                    mMapDirectory = this.adjustSharedArenaGrouping(mMapDirectory);
                    return new HybridDirectory(lockFactory, this.setMMapFunctions(mMapDirectory, preLoadExtensions), asyncPrefetchLimit);
                }
                return primaryDirectory;
            }
            case MMAPFS: {
                MMapDirectory mMapDirectory = this.adjustSharedArenaGrouping(new MMapDirectory(location, lockFactory));
                return this.setMMapFunctions(mMapDirectory, preLoadExtensions);
            }
            case SIMPLEFS: 
            case NIOFS: {
                return new NIOFSDirectory(location, lockFactory);
            }
        }
        throw new AssertionError((Object)("unexpected built-in store type [" + String.valueOf((Object)type) + "]"));
    }

    public MMapDirectory setMMapFunctions(MMapDirectory mMapDirectory, Set<String> preLoadExtensions) {
        mMapDirectory.setPreload(FsDirectoryFactory.getPreloadFunc(preLoadExtensions));
        mMapDirectory.setReadAdvice(FsDirectoryFactory.getReadAdviceFunc());
        return mMapDirectory;
    }

    public MMapDirectory adjustSharedArenaGrouping(MMapDirectory mMapDirectory) {
        if (sharedArenaMaxPermits <= 1) {
            mMapDirectory.setGroupingFunction(MMapDirectory.NO_GROUPING);
        }
        return mMapDirectory;
    }

    static BiPredicate<String, IOContext> getPreloadFunc(Set<String> preLoadExtensions) {
        if (!preLoadExtensions.isEmpty()) {
            if (preLoadExtensions.contains("*")) {
                return MMapDirectory.ALL_FILES;
            }
            return (name, context) -> preLoadExtensions.contains(FileSwitchDirectory.getExtension(name));
        }
        return MMapDirectory.NO_FILES;
    }

    private static BiFunction<String, IOContext, Optional<ReadAdvice>> getReadAdviceFunc() {
        return (name, context) -> {
            if (context.hints().contains(StandardIOBehaviorHint.INSTANCE)) {
                return Optional.of(ReadAdvice.NORMAL);
            }
            if (name.endsWith(".cfs")) {
                return Optional.of(ReadAdvice.NORMAL);
            }
            return MMapDirectory.ADVISE_BY_CONTEXT.apply((String)name, (IOContext)context);
        };
    }

    public static boolean isHybridFs(Directory directory) {
        Directory unwrap = FilterDirectory.unwrap(directory);
        return unwrap instanceof HybridDirectory;
    }

    @SuppressForbidden(reason="requires Files.getFileStore for blockSize")
    private static int getBlockSize(Path path) throws IOException {
        return Math.toIntExact(Files.getFileStore(path).getBlockSize());
    }

    static {
        String prop = System.getProperty("org.apache.lucene.store.MMapDirectory.sharedArenaMaxPermits");
        int value = 1;
        if (prop != null) {
            try {
                value = Integer.parseInt(prop);
            }
            catch (NumberFormatException e) {
                Log.warn(() -> "unable to parse system property [org.apache.lucene.store.MMapDirectory.sharedArenaMaxPermits] with value [" + prop + "]", (Throwable)e);
            }
        }
        sharedArenaMaxPermits = value;
        INDEX_LOCK_FACTOR_SETTING = new Setting<LockFactory>("index.store.fs.fs_lock", "native", s -> switch (s) {
            case "native" -> NativeFSLockFactory.INSTANCE;
            case "simple" -> SimpleFSLockFactory.INSTANCE;
            default -> throw new IllegalArgumentException("unrecognized [index.store.fs.fs_lock] \"" + s + "\": must be native or simple");
        }, Setting.Property.IndexScope, Setting.Property.NodeScope);
        ASYNC_PREFETCH_LIMIT = Setting.intSetting("index.store.fs.directio_async_prefetch_limit", 64, 0, 256, Setting.Property.IndexScope, Setting.Property.NodeScope);
    }

    public static final class HybridDirectory
    extends NIOFSDirectory {
        private final MMapDirectory delegate;
        private final DirectIODirectory directIODelegate;
        static final Set<String> NO_MMAP_FILE_SUFFIXES = Set.of("fdt", "disi", "address-data", "block-addresses", "block-doc-ranges");

        public HybridDirectory(LockFactory lockFactory, MMapDirectory delegate, int asyncPrefetchLimit) throws IOException {
            super(delegate.getDirectory(), lockFactory);
            AlwaysDirectIODirectory directIO;
            this.delegate = delegate;
            try {
                directIO = new AlwaysDirectIODirectory(delegate, 8192, 0xA00000L, asyncPrefetchLimit);
            }
            catch (Exception e) {
                Log.warn("Could not initialize DirectIO access", (Throwable)e);
                directIO = null;
            }
            this.directIODelegate = directIO;
        }

        @Override
        public IndexInput openInput(String name, IOContext context) throws IOException {
            FileSystemException directIOException = null;
            if (this.directIODelegate != null && context.hints().contains(DirectIOHint.INSTANCE)) {
                this.ensureOpen();
                this.ensureCanRead(name);
                try {
                    Log.debug("Opening {} with direct IO", name);
                    return this.directIODelegate.openInput(name, context);
                }
                catch (FileSystemException e) {
                    Log.debug(() -> Strings.format("Could not open %s with direct IO", name), (Throwable)e);
                    directIOException = e;
                }
            }
            try {
                if (HybridDirectory.useDelegate(name, context)) {
                    this.ensureOpen();
                    this.ensureCanRead(name);
                    return this.delegate.openInput(name, context);
                }
                return super.openInput(name, context);
            }
            catch (Throwable t) {
                if (directIOException != null) {
                    t.addSuppressed(directIOException);
                }
                throw t;
            }
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(() -> super.close(), this.delegate);
        }

        private static String getExtension(String name) {
            int lastDotIndex = name.lastIndexOf(46);
            if (lastDotIndex == -1) {
                return "";
            }
            return name.substring(lastDotIndex + 1);
        }

        static boolean useDelegate(String name, IOContext ioContext) {
            if (ioContext.hints().contains(Store.FileFooterOnly.INSTANCE)) {
                return false;
            }
            LuceneFilesExtensions extension = LuceneFilesExtensions.fromExtension(HybridDirectory.getExtension(name));
            return extension != null && extension.shouldMmap() && !HybridDirectory.avoidDelegateForFdtTempFiles(name, extension);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static boolean avoidDelegateForFdtTempFiles(String name, LuceneFilesExtensions extension) {
            if (extension != LuceneFilesExtensions.TMP) return false;
            if (!NO_MMAP_FILE_SUFFIXES.stream().anyMatch(name::contains)) return false;
            return true;
        }

        MMapDirectory getDelegate() {
            return this.delegate;
        }
    }

    static final class AlwaysDirectIODirectory
    extends DirectIODirectory {
        private final int blockSize;
        private final int asyncPrefetchLimit;

        AlwaysDirectIODirectory(FSDirectory delegate, int mergeBufferSize, long minBytesDirect, int asyncPrefetchLimit) throws IOException {
            super(delegate, mergeBufferSize, minBytesDirect);
            this.blockSize = FsDirectoryFactory.getBlockSize(delegate.getDirectory());
            this.asyncPrefetchLimit = asyncPrefetchLimit;
        }

        protected boolean useDirectIO(String name, IOContext context, OptionalLong fileLength) {
            return true;
        }

        public IndexInput openInput(String name, IOContext context) throws IOException {
            this.ensureOpen();
            if (this.asyncPrefetchLimit > 0) {
                return new AsyncDirectIOIndexInput(this.getDirectory().resolve(name), this.blockSize, 8192, this.asyncPrefetchLimit);
            }
            return super.openInput(name, context);
        }
    }
}

