/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.stats;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class FieldUsageStats
implements ToXContentObject,
Writeable {
    public static final String ANY = "any";
    public static final String INVERTED_INDEX = "inverted_index";
    public static final String TERMS = "terms";
    public static final String POSTINGS = "postings";
    public static final String TERM_FREQUENCIES = "term_frequencies";
    public static final String POSITIONS = "positions";
    public static final String OFFSETS = "offsets";
    public static final String DOC_VALUES = "doc_values";
    public static final String STORED_FIELDS = "stored_fields";
    public static final String NORMS = "norms";
    public static final String PAYLOADS = "payloads";
    public static final String TERM_VECTORS = "term_vectors";
    public static final String POINTS = "points";
    public static final String PROXIMITY = "proximity";
    public static final String KNN_VECTORS = "knn_vectors";
    private final Map<String, PerFieldUsageStats> stats;

    public FieldUsageStats() {
        this.stats = new HashMap<String, PerFieldUsageStats>();
    }

    public FieldUsageStats(Map<String, PerFieldUsageStats> stats) {
        this.stats = new HashMap<String, PerFieldUsageStats>(stats);
    }

    public FieldUsageStats(StreamInput in) throws IOException {
        this.stats = in.readMap(PerFieldUsageStats::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.stats, StreamOutput::writeWriteable);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("all_fields");
        this.total().toXContent(builder, params);
        builder.endObject();
        builder.startObject("fields");
        List sortedEntries = this.stats.entrySet().stream().sorted(Map.Entry.comparingByKey()).toList();
        for (Map.Entry entry : sortedEntries) {
            builder.startObject((String)entry.getKey());
            ((PerFieldUsageStats)entry.getValue()).toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    PerFieldUsageStats total() {
        PerFieldUsageStats total = PerFieldUsageStats.EMPTY;
        for (PerFieldUsageStats value : this.stats.values()) {
            total = total.add(value);
        }
        return total;
    }

    public String toString() {
        return Strings.toString(this);
    }

    public boolean hasField(String field) {
        return this.stats.containsKey(field);
    }

    public PerFieldUsageStats get(String field) {
        return this.stats.get(field);
    }

    public FieldUsageStats add(FieldUsageStats other) {
        FieldUsageStats newStats = new FieldUsageStats(this.stats);
        other.stats.forEach((k, v) -> newStats.stats.merge((String)k, (PerFieldUsageStats)v, PerFieldUsageStats::add));
        return newStats;
    }

    public static class PerFieldUsageStats
    implements ToXContentFragment,
    Writeable {
        static final PerFieldUsageStats EMPTY = new PerFieldUsageStats(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
        private final long any;
        private final long proximity;
        private final long terms;
        private final long postings;
        private final long termFrequencies;
        private final long positions;
        private final long offsets;
        private final long docValues;
        private final long storedFields;
        private final long norms;
        private final long payloads;
        private final long termVectors;
        private final long points;
        private final long knnVectors;

        public PerFieldUsageStats(long any, long proximity, long terms, long postings, long termFrequencies, long positions, long offsets, long docValues, long storedFields, long norms, long payloads, long termVectors, long points, long knnVectors) {
            this.any = any;
            this.proximity = proximity;
            this.terms = terms;
            this.postings = postings;
            this.termFrequencies = termFrequencies;
            this.positions = positions;
            this.offsets = offsets;
            this.docValues = docValues;
            this.storedFields = storedFields;
            this.norms = norms;
            this.payloads = payloads;
            this.termVectors = termVectors;
            this.points = points;
            this.knnVectors = knnVectors;
        }

        private PerFieldUsageStats add(PerFieldUsageStats other) {
            return new PerFieldUsageStats(this.any + other.any, this.proximity + other.proximity, this.terms + other.terms, this.postings + other.postings, this.termFrequencies + other.termFrequencies, this.positions + other.positions, this.offsets + other.offsets, this.docValues + other.docValues, this.storedFields + other.storedFields, this.norms + other.norms, this.payloads + other.payloads, this.termVectors + other.termVectors, this.points + other.points, this.knnVectors + other.knnVectors);
        }

        public PerFieldUsageStats(StreamInput in) throws IOException {
            this.any = in.readVLong();
            this.proximity = in.readVLong();
            this.terms = in.readVLong();
            this.postings = in.readVLong();
            this.termFrequencies = in.readVLong();
            this.positions = in.readVLong();
            this.offsets = in.readVLong();
            this.docValues = in.readVLong();
            this.storedFields = in.readVLong();
            this.norms = in.readVLong();
            this.payloads = in.readVLong();
            this.termVectors = in.readVLong();
            this.points = in.readVLong();
            this.knnVectors = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.any);
            out.writeVLong(this.proximity);
            out.writeVLong(this.terms);
            out.writeVLong(this.postings);
            out.writeVLong(this.termFrequencies);
            out.writeVLong(this.positions);
            out.writeVLong(this.offsets);
            out.writeVLong(this.docValues);
            out.writeVLong(this.storedFields);
            out.writeVLong(this.norms);
            out.writeVLong(this.payloads);
            out.writeVLong(this.termVectors);
            out.writeVLong(this.points);
            out.writeVLong(this.knnVectors);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(FieldUsageStats.ANY, this.any);
            builder.startObject(FieldUsageStats.INVERTED_INDEX);
            builder.field(FieldUsageStats.TERMS, this.terms);
            builder.field(FieldUsageStats.POSTINGS, this.postings);
            builder.field(FieldUsageStats.TERM_FREQUENCIES, this.termFrequencies);
            builder.field(FieldUsageStats.POSITIONS, this.positions);
            builder.field(FieldUsageStats.OFFSETS, this.offsets);
            builder.field(FieldUsageStats.PAYLOADS, this.payloads);
            builder.field(FieldUsageStats.PROXIMITY, this.proximity);
            builder.endObject();
            builder.field(FieldUsageStats.STORED_FIELDS, this.storedFields);
            builder.field(FieldUsageStats.DOC_VALUES, this.docValues);
            builder.field(FieldUsageStats.POINTS, this.points);
            builder.field(FieldUsageStats.NORMS, this.norms);
            builder.field(FieldUsageStats.TERM_VECTORS, this.termVectors);
            builder.field(FieldUsageStats.KNN_VECTORS, this.knnVectors);
            return builder;
        }

        public Set<UsageContext> keySet() {
            EnumSet<UsageContext> set = EnumSet.noneOf(UsageContext.class);
            if (this.terms > 0L) {
                set.add(UsageContext.TERMS);
            }
            if (this.postings > 0L) {
                set.add(UsageContext.POSTINGS);
            }
            if (this.termFrequencies > 0L) {
                set.add(UsageContext.FREQS);
            }
            if (this.positions > 0L) {
                set.add(UsageContext.POSITIONS);
            }
            if (this.offsets > 0L) {
                set.add(UsageContext.OFFSETS);
            }
            if (this.docValues > 0L) {
                set.add(UsageContext.DOC_VALUES);
            }
            if (this.storedFields > 0L) {
                set.add(UsageContext.STORED_FIELDS);
            }
            if (this.norms > 0L) {
                set.add(UsageContext.NORMS);
            }
            if (this.payloads > 0L) {
                set.add(UsageContext.PAYLOADS);
            }
            if (this.termVectors > 0L) {
                set.add(UsageContext.TERM_VECTORS);
            }
            if (this.points > 0L) {
                set.add(UsageContext.POINTS);
            }
            if (this.knnVectors > 0L) {
                set.add(UsageContext.KNN_VECTORS);
            }
            return set;
        }

        public long getTerms() {
            return this.terms;
        }

        public long getPostings() {
            return this.postings;
        }

        public long getTermFrequencies() {
            return this.termFrequencies;
        }

        public long getPositions() {
            return this.positions;
        }

        public long getOffsets() {
            return this.offsets;
        }

        public long getDocValues() {
            return this.docValues;
        }

        public long getStoredFields() {
            return this.storedFields;
        }

        public long getNorms() {
            return this.norms;
        }

        public long getPayloads() {
            return this.payloads;
        }

        public long getTermVectors() {
            return this.termVectors;
        }

        public long getPoints() {
            return this.points;
        }

        public long getKnnVectors() {
            return this.knnVectors;
        }

        public long getProximity() {
            return this.proximity;
        }

        public long getAny() {
            return this.any;
        }

        public String toString() {
            return Strings.toString(this);
        }
    }

    public static enum UsageContext {
        DOC_VALUES,
        STORED_FIELDS,
        TERMS,
        POSTINGS,
        FREQS,
        POSITIONS,
        OFFSETS,
        NORMS,
        PAYLOADS,
        TERM_VECTORS,
        POINTS,
        KNN_VECTORS;

    }
}

