/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.support;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.BoostingQueryBuilder;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.DisMaxQueryBuilder;
import org.elasticsearch.index.query.InterceptedQueryBuilderWrapper;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.functionscore.FunctionScoreQueryBuilder;

public final class AutoPrefilteringUtils {
    private AutoPrefilteringUtils() {
    }

    public static Optional<QueryBuilder> pruneQuery(QueryBuilder query, Set<Class<? extends QueryBuilder>> prunedTypes) {
        if (prunedTypes.contains(query.getClass())) {
            return Optional.empty();
        }
        QueryBuilder queryBuilder = query;
        Objects.requireNonNull(queryBuilder);
        QueryBuilder queryBuilder2 = queryBuilder;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BoolQueryBuilder.class, BoostingQueryBuilder.class, ConstantScoreQueryBuilder.class, DisMaxQueryBuilder.class, FunctionScoreQueryBuilder.class, InterceptedQueryBuilderWrapper.class, NestedQueryBuilder.class}, (Object)queryBuilder2, n)) {
            case 0 -> {
                BoolQueryBuilder boolQuery = (BoolQueryBuilder)queryBuilder2;
                yield AutoPrefilteringUtils.pruneBoolQuery(boolQuery, prunedTypes);
            }
            case 1 -> {
                BoostingQueryBuilder boostingQuery = (BoostingQueryBuilder)queryBuilder2;
                yield AutoPrefilteringUtils.pruneQuery(boostingQuery.positiveQuery(), prunedTypes);
            }
            case 2 -> {
                ConstantScoreQueryBuilder constantScoreQuery = (ConstantScoreQueryBuilder)queryBuilder2;
                Optional<QueryBuilder> pruned = AutoPrefilteringUtils.pruneQuery(constantScoreQuery.innerQuery(), prunedTypes);
                yield pruned.map(q -> q == constantScoreQuery.innerQuery() ? constantScoreQuery : new ConstantScoreQueryBuilder((QueryBuilder)q));
            }
            case 3 -> {
                DisMaxQueryBuilder disMaxQuery = (DisMaxQueryBuilder)queryBuilder2;
                yield AutoPrefilteringUtils.pruneDisMaxQuery(disMaxQuery, prunedTypes);
            }
            case 4 -> {
                FunctionScoreQueryBuilder functionScoreQuery = (FunctionScoreQueryBuilder)queryBuilder2;
                yield AutoPrefilteringUtils.pruneFunctionScoreQuery(functionScoreQuery, prunedTypes);
            }
            case 5 -> {
                InterceptedQueryBuilderWrapper interceptedQuery = (InterceptedQueryBuilderWrapper)queryBuilder2;
                Optional<QueryBuilder> pruned = AutoPrefilteringUtils.pruneQuery(interceptedQuery.query(), prunedTypes);
                yield pruned.map(q -> q == interceptedQuery.query() ? interceptedQuery : new InterceptedQueryBuilderWrapper((QueryBuilder)q));
            }
            case 6 -> {
                NestedQueryBuilder nestedQuery = (NestedQueryBuilder)queryBuilder2;
                Optional<QueryBuilder> pruned = AutoPrefilteringUtils.pruneQuery(nestedQuery.query(), prunedTypes);
                yield pruned.map(q -> q == nestedQuery.query() ? nestedQuery : new NestedQueryBuilder(nestedQuery.path(), (QueryBuilder)q, nestedQuery.scoreMode()));
            }
            default -> Optional.of(query);
        };
    }

    private static Optional<QueryBuilder> pruneBoolQuery(BoolQueryBuilder boolQuery, Set<Class<? extends QueryBuilder>> prunedTypes) {
        BoolQueryBuilder prunedBool = new BoolQueryBuilder();
        AutoPrefilteringUtils.pruneQueries(boolQuery.must(), prunedTypes).forEach(prunedBool::must);
        AutoPrefilteringUtils.pruneQueries(boolQuery.should(), prunedTypes).forEach(prunedBool::should);
        AutoPrefilteringUtils.pruneQueries(boolQuery.filter(), prunedTypes).forEach(prunedBool::filter);
        AutoPrefilteringUtils.pruneQueries(boolQuery.mustNot(), prunedTypes).forEach(prunedBool::mustNot);
        AutoPrefilteringUtils.adjustMinimumShouldMatchForPrunedShouldClauses(boolQuery, prunedBool);
        if (prunedBool.equals(boolQuery)) {
            return Optional.of(boolQuery);
        }
        return prunedBool.hasClauses() ? Optional.of(prunedBool) : Optional.empty();
    }

    private static void adjustMinimumShouldMatchForPrunedShouldClauses(BoolQueryBuilder originalBool, BoolQueryBuilder prunedBool) {
        if (originalBool.minimumShouldMatch() == null) {
            return;
        }
        if (prunedBool.should().size() == originalBool.should().size()) {
            prunedBool.minimumShouldMatch(originalBool.minimumShouldMatch());
        } else {
            int originalMsm = Queries.calculateMinShouldMatch(originalBool.should().size(), originalBool.minimumShouldMatch());
            int numPrunedClauses = originalBool.should().size() - prunedBool.should().size();
            int prunedMsm = Math.max(0, originalMsm - numPrunedClauses);
            prunedBool.minimumShouldMatch(prunedMsm);
        }
    }

    private static Optional<QueryBuilder> pruneDisMaxQuery(DisMaxQueryBuilder disMaxQuery, Set<Class<? extends QueryBuilder>> prunedTypes) {
        DisMaxQueryBuilder builder = new DisMaxQueryBuilder();
        for (QueryBuilder innerQuery : disMaxQuery.innerQueries()) {
            Optional<QueryBuilder> pruned = AutoPrefilteringUtils.pruneQuery(innerQuery, prunedTypes);
            pruned.ifPresent(builder::add);
        }
        if (builder.innerQueries().equals(disMaxQuery.innerQueries())) {
            return Optional.of(disMaxQuery);
        }
        return builder.innerQueries().isEmpty() ? Optional.empty() : Optional.of(builder);
    }

    private static Optional<QueryBuilder> pruneFunctionScoreQuery(FunctionScoreQueryBuilder functionScoreQuery, Set<Class<? extends QueryBuilder>> prunedTypes) {
        Optional<QueryBuilder> pruned = AutoPrefilteringUtils.pruneQuery(functionScoreQuery.query(), prunedTypes);
        return pruned.map(q -> q == functionScoreQuery.query() ? functionScoreQuery : new FunctionScoreQueryBuilder((QueryBuilder)q, functionScoreQuery.filterFunctionBuilders()));
    }

    private static List<QueryBuilder> pruneQueries(List<QueryBuilder> queries, Set<Class<? extends QueryBuilder>> prunedTypes) {
        return queries.stream().map(q -> AutoPrefilteringUtils.pruneQuery(q, prunedTypes)).filter(Optional::isPresent).map(Optional::get).toList();
    }
}

