/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.ToChildBlockJoinQuery;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.mapper.NestedObjectMapper;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class ToChildBlockJoinQueryBuilder
extends AbstractQueryBuilder<ToChildBlockJoinQueryBuilder> {
    public static final String NAME = "to_child_block_join";
    private static final TransportVersion TO_CHILD_BLOCK_JOIN_QUERY = TransportVersion.fromName("to_child_block_join_query");
    private final QueryBuilder parentQueryBuilder;

    public ToChildBlockJoinQueryBuilder(QueryBuilder parentQueryBuilder) {
        this.parentQueryBuilder = parentQueryBuilder;
    }

    public ToChildBlockJoinQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.parentQueryBuilder = in.readNamedWriteable(QueryBuilder.class);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.parentQueryBuilder);
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field("query");
        this.parentQueryBuilder.toXContent(builder, params);
        this.boostAndQueryNameToXContent(builder);
        builder.endObject();
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        QueryBuilder rewritten = this.parentQueryBuilder.rewrite(queryRewriteContext);
        if (rewritten instanceof MatchNoneQueryBuilder) {
            return rewritten;
        }
        if (rewritten != this.parentQueryBuilder) {
            return new ToChildBlockJoinQueryBuilder(rewritten);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        Query parentFilter;
        NestedObjectMapper originalObjectMapper = context.nestedScope().getObjectMapper();
        if (originalObjectMapper != null) {
            try {
                context.nestedScope().previousLevel();
                NestedObjectMapper objectMapper = context.nestedScope().getObjectMapper();
                parentFilter = objectMapper == null ? Queries.newNonNestedFilter(context.indexVersionCreated()) : objectMapper.nestedTypeFilter();
            }
            finally {
                context.nestedScope().nextLevel(originalObjectMapper);
            }
        } else {
            parentFilter = Queries.newNonNestedFilter(context.indexVersionCreated());
        }
        BitSetProducer parentBitSet = context.bitsetFilter(parentFilter);
        Query parentQuery = this.parentQueryBuilder.toQuery(context);
        return new ToChildBlockJoinQuery((Query)Queries.filtered(parentQuery, parentFilter), parentBitSet);
    }

    @Override
    protected boolean doEquals(ToChildBlockJoinQueryBuilder other) {
        return Objects.equals(this.parentQueryBuilder, other.parentQueryBuilder);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.parentQueryBuilder);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TO_CHILD_BLOCK_JOIN_QUERY;
    }
}

