/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ResolvedIndices;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.routing.allocation.DataTier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.TextFieldMapper;
import org.elasticsearch.index.query.CoordinatorRewriteContext;
import org.elasticsearch.index.query.DataRewriteContext;
import org.elasticsearch.index.query.InnerHitsRewriteContext;
import org.elasticsearch.index.query.QueryRewriteAsyncAction;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.plugins.internal.rewriter.QueryRewriteInterceptor;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.builder.PointInTimeBuilder;
import org.elasticsearch.xcontent.XContentParserConfiguration;

public class QueryRewriteContext {
    protected final MapperService mapperService;
    protected final MappingLookup mappingLookup;
    protected final Map<String, MappedFieldType> runtimeMappings;
    protected final IndexSettings indexSettings;
    private final TransportVersion minTransportVersion;
    private final String localClusterAlias;
    protected final Index fullyQualifiedIndex;
    protected final Predicate<String> indexNameMatcher;
    protected final NamedWriteableRegistry writeableRegistry;
    protected final ValuesSourceRegistry valuesSourceRegistry;
    protected final BooleanSupplier allowExpensiveQueries;
    protected final ScriptCompiler scriptService;
    private final XContentParserConfiguration parserConfiguration;
    protected final Client client;
    protected final LongSupplier nowInMillis;
    private final List<BiConsumer<Client, ActionListener<?>>> asyncActions = new ArrayList();
    private final Map<QueryRewriteAsyncAction<?, ?>, List<Consumer<?>>> uniqueAsyncActions = new HashMap();
    protected boolean allowUnmappedFields;
    protected boolean mapUnmappedFieldAsString;
    protected Predicate<String> allowedFields;
    private final ResolvedIndices resolvedIndices;
    private final PointInTimeBuilder pit;
    private QueryRewriteInterceptor queryRewriteInterceptor;
    private final Boolean ccsMinimizeRoundTrips;
    private final boolean isExplain;
    private final boolean isProfile;
    private Long timeRangeFilterFromMillis;
    private boolean trackTimeRangeFilterFrom = true;
    private final boolean allowPartialSearchResults;

    public QueryRewriteContext(XContentParserConfiguration parserConfiguration, Client client, LongSupplier nowInMillis, MapperService mapperService, MappingLookup mappingLookup, Map<String, MappedFieldType> runtimeMappings, IndexSettings indexSettings, TransportVersion minTransportVersion, String localClusterAlias, Index fullyQualifiedIndex, Predicate<String> indexNameMatcher, NamedWriteableRegistry namedWriteableRegistry, ValuesSourceRegistry valuesSourceRegistry, BooleanSupplier allowExpensiveQueries, ScriptCompiler scriptService, ResolvedIndices resolvedIndices, PointInTimeBuilder pit, QueryRewriteInterceptor queryRewriteInterceptor, Boolean ccsMinimizeRoundTrips, boolean isExplain, boolean isProfile, boolean allowPartialSearchResults) {
        this.parserConfiguration = parserConfiguration;
        this.client = client;
        this.nowInMillis = nowInMillis;
        this.mapperService = mapperService;
        this.mappingLookup = Objects.requireNonNull(mappingLookup);
        this.allowUnmappedFields = indexSettings == null || indexSettings.isDefaultAllowUnmappedFields();
        this.runtimeMappings = runtimeMappings;
        this.indexSettings = indexSettings;
        this.minTransportVersion = minTransportVersion;
        this.localClusterAlias = localClusterAlias;
        this.fullyQualifiedIndex = fullyQualifiedIndex;
        this.indexNameMatcher = indexNameMatcher;
        this.writeableRegistry = namedWriteableRegistry;
        this.valuesSourceRegistry = valuesSourceRegistry;
        this.allowExpensiveQueries = allowExpensiveQueries;
        this.scriptService = scriptService;
        this.resolvedIndices = resolvedIndices;
        this.pit = pit;
        this.queryRewriteInterceptor = queryRewriteInterceptor;
        this.ccsMinimizeRoundTrips = ccsMinimizeRoundTrips;
        this.isExplain = isExplain;
        this.isProfile = isProfile;
        this.allowPartialSearchResults = allowPartialSearchResults;
    }

    public QueryRewriteContext(XContentParserConfiguration parserConfiguration, Client client, LongSupplier nowInMillis, MapperService mapperService, MappingLookup mappingLookup, Map<String, MappedFieldType> runtimeMappings, IndexSettings indexSettings, TransportVersion minTransportVersion, String localClusterAlias, Index fullyQualifiedIndex, Predicate<String> indexNameMatcher, NamedWriteableRegistry namedWriteableRegistry, ValuesSourceRegistry valuesSourceRegistry, BooleanSupplier allowExpensiveQueries, ScriptCompiler scriptService, ResolvedIndices resolvedIndices, PointInTimeBuilder pit, QueryRewriteInterceptor queryRewriteInterceptor, Boolean ccsMinimizeRoundTrips, boolean isExplain, boolean isProfile) {
        this(parserConfiguration, client, nowInMillis, mapperService, Objects.requireNonNull(mappingLookup), runtimeMappings, indexSettings, minTransportVersion, localClusterAlias, fullyQualifiedIndex, indexNameMatcher, namedWriteableRegistry, valuesSourceRegistry, allowExpensiveQueries, scriptService, resolvedIndices, pit, queryRewriteInterceptor, ccsMinimizeRoundTrips, isExplain, isProfile, true);
    }

    public QueryRewriteContext(XContentParserConfiguration parserConfiguration, Client client, LongSupplier nowInMillis) {
        this(parserConfiguration, client, nowInMillis, null, MappingLookup.EMPTY, Collections.emptyMap(), null, null, null, null, null, null, null, null, null, null, null, null, null, false, false, true);
    }

    public QueryRewriteContext(XContentParserConfiguration parserConfiguration, Client client, LongSupplier nowInMillis, TransportVersion minTransportVersion, String localClusterAlias, ResolvedIndices resolvedIndices, PointInTimeBuilder pit, QueryRewriteInterceptor queryRewriteInterceptor, Boolean ccsMinimizeRoundTrips) {
        this(parserConfiguration, client, nowInMillis, minTransportVersion, localClusterAlias, resolvedIndices, pit, queryRewriteInterceptor, ccsMinimizeRoundTrips, false, false, true);
    }

    public QueryRewriteContext(XContentParserConfiguration parserConfiguration, Client client, LongSupplier nowInMillis, TransportVersion minTransportVersion, String localClusterAlias, ResolvedIndices resolvedIndices, PointInTimeBuilder pit, QueryRewriteInterceptor queryRewriteInterceptor, Boolean ccsMinimizeRoundTrips, boolean isExplain, boolean isProfile, boolean allowPartialSearchResults) {
        this(parserConfiguration, client, nowInMillis, null, MappingLookup.EMPTY, Collections.emptyMap(), null, minTransportVersion, localClusterAlias, null, null, null, null, null, null, resolvedIndices, pit, queryRewriteInterceptor, ccsMinimizeRoundTrips, isExplain, isProfile, allowPartialSearchResults);
    }

    public QueryRewriteContext(XContentParserConfiguration parserConfiguration, Client client, LongSupplier nowInMillis, TransportVersion minTransportVersion, String localClusterAlias, ResolvedIndices resolvedIndices, PointInTimeBuilder pit, QueryRewriteInterceptor queryRewriteInterceptor, Boolean ccsMinimizeRoundTrips, boolean isExplain, boolean isProfile) {
        this(parserConfiguration, client, nowInMillis, null, MappingLookup.EMPTY, Collections.emptyMap(), null, minTransportVersion, localClusterAlias, null, null, null, null, null, null, resolvedIndices, pit, queryRewriteInterceptor, ccsMinimizeRoundTrips, isExplain, isProfile, true);
    }

    public XContentParserConfiguration getParserConfig() {
        return this.parserConfiguration;
    }

    public long nowInMillis() {
        return this.nowInMillis.getAsLong();
    }

    public SearchExecutionContext convertToSearchExecutionContext() {
        return null;
    }

    public CoordinatorRewriteContext convertToCoordinatorRewriteContext() {
        return null;
    }

    public QueryRewriteContext convertToIndexMetadataContext() {
        return this.mapperService != null ? this : null;
    }

    public DataRewriteContext convertToDataRewriteContext() {
        return null;
    }

    public InnerHitsRewriteContext convertToInnerHitsRewriteContext() {
        return null;
    }

    public MappedFieldType getFieldType(String name) {
        return this.failIfFieldMappingNotFound(name, this.fieldType(name));
    }

    protected MappedFieldType fieldType(String name) {
        if (this.allowedFields != null && !this.allowedFields.test(name)) {
            return null;
        }
        MappedFieldType fieldType = this.runtimeMappings.get(name);
        return fieldType == null ? this.mappingLookup.getFieldType(name) : fieldType;
    }

    public IndexAnalyzers getIndexAnalyzers() {
        if (this.mapperService == null) {
            return IndexAnalyzers.of(Collections.emptyMap());
        }
        return this.mapperService.getIndexAnalyzers();
    }

    MappedFieldType failIfFieldMappingNotFound(String name, MappedFieldType fieldMapping) {
        if (fieldMapping != null || this.allowUnmappedFields) {
            return fieldMapping;
        }
        if (this.mapUnmappedFieldAsString) {
            TextFieldMapper.Builder builder = new TextFieldMapper.Builder(name, this.getIndexAnalyzers());
            return builder.build(MapperBuilderContext.root(false, false)).fieldType();
        }
        throw new QueryShardException(this, "No field mapping can be found for the field with name [{}]", name);
    }

    public void setAllowUnmappedFields(boolean allowUnmappedFields) {
        this.allowUnmappedFields = allowUnmappedFields;
    }

    public void setMapUnmappedFieldAsString(boolean mapUnmappedFieldAsString) {
        this.mapUnmappedFieldAsString = mapUnmappedFieldAsString;
    }

    public Boolean isCcsMinimizeRoundTrips() {
        return this.ccsMinimizeRoundTrips;
    }

    public boolean isExplain() {
        return this.isExplain;
    }

    public boolean isProfile() {
        return this.isProfile;
    }

    public boolean allowPartialSearchResults() {
        return this.allowPartialSearchResults;
    }

    public NamedWriteableRegistry getWriteableRegistry() {
        return this.writeableRegistry;
    }

    public ValuesSourceRegistry getValuesSourceRegistry() {
        return this.valuesSourceRegistry;
    }

    public boolean allowExpensiveQueries() {
        assert (this.allowExpensiveQueries != null);
        return this.allowExpensiveQueries.getAsBoolean();
    }

    public void registerAsyncAction(BiConsumer<Client, ActionListener<?>> asyncAction) {
        this.asyncActions.add(asyncAction);
    }

    public boolean hasAsyncActions() {
        return !this.asyncActions.isEmpty() || !this.uniqueAsyncActions.isEmpty();
    }

    public void executeAsyncActions(final ActionListener<Void> listener) {
        if (!this.hasAsyncActions()) {
            listener.onResponse(null);
        } else {
            int actionCount = this.asyncActions.size() + this.uniqueAsyncActions.size();
            final CountDown countDown = new CountDown(actionCount);
            ActionListener<Object> internalListener = new ActionListener<Object>(this){

                @Override
                public void onResponse(Object o) {
                    if (countDown.countDown()) {
                        listener.onResponse(null);
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    if (countDown.fastForward()) {
                        listener.onFailure(e);
                    }
                }
            };
            ArrayList biConsumers = new ArrayList(this.asyncActions);
            this.asyncActions.clear();
            for (BiConsumer biConsumer : biConsumers) {
                biConsumer.accept(this.client, internalListener);
            }
            HashMap copyUniqueAsyncActions = new HashMap(this.uniqueAsyncActions);
            this.uniqueAsyncActions.clear();
            for (QueryRewriteAsyncAction<Object, Object> queryRewriteAsyncAction : copyUniqueAsyncActions.keySet()) {
                queryRewriteAsyncAction.execute(this.client, internalListener, copyUniqueAsyncActions.get(queryRewriteAsyncAction));
            }
        }
    }

    public String getLocalClusterAlias() {
        return this.localClusterAlias != null ? this.localClusterAlias : "";
    }

    public TransportVersion getMinTransportVersion() {
        return this.minTransportVersion;
    }

    public Index getFullyQualifiedIndex() {
        return this.fullyQualifiedIndex;
    }

    public IndexSettings getIndexSettings() {
        return this.indexSettings;
    }

    public MappingLookup getMappingLookup() {
        return this.mappingLookup;
    }

    public boolean indexMatches(String pattern) {
        assert (this.indexNameMatcher != null);
        return this.indexNameMatcher.test(pattern);
    }

    public Set<String> getMatchingFieldNames(String pattern) {
        Set<String> matches;
        if (this.runtimeMappings.isEmpty()) {
            matches = this.mappingLookup.getMatchingFieldNames(pattern);
        } else {
            matches = new HashSet<String>(this.mappingLookup.getMatchingFieldNames(pattern));
            if ("*".equals(pattern)) {
                matches.addAll(this.runtimeMappings.keySet());
            } else if (!Regex.isSimpleMatchPattern(pattern)) {
                if (this.runtimeMappings.containsKey(pattern)) {
                    matches.add(pattern);
                }
            } else {
                for (String name : this.runtimeMappings.keySet()) {
                    if (!Regex.simpleMatch(pattern, name)) continue;
                    matches.add(name);
                }
            }
        }
        return this.allowedFields == null ? matches : matches.stream().filter(this.allowedFields).collect(Collectors.toSet());
    }

    public Iterable<Map.Entry<String, MappedFieldType>> getAllFields() {
        Set<Map.Entry<String, MappedFieldType>> allEntrySet;
        Map<String, MappedFieldType> allFromMapping = this.mappingLookup.getFullNameToFieldType();
        Set<Map.Entry<String, MappedFieldType>> set = allEntrySet = this.allowedFields == null ? allFromMapping.entrySet() : allFromMapping.entrySet().stream().filter(entry -> this.allowedFields.test((String)entry.getKey())).collect(Collectors.toSet());
        if (this.runtimeMappings.isEmpty()) {
            return allEntrySet;
        }
        Set<Map.Entry<String, MappedFieldType>> runtimeEntrySet = this.allowedFields == null ? this.runtimeMappings.entrySet() : this.runtimeMappings.entrySet().stream().filter(entry -> this.allowedFields.test((String)entry.getKey())).collect(Collectors.toSet());
        return () -> Iterators.concat(allEntrySet.iterator(), runtimeEntrySet.iterator());
    }

    public ResolvedIndices getResolvedIndices() {
        return this.resolvedIndices;
    }

    @Nullable
    public PointInTimeBuilder getPointInTimeBuilder() {
        return this.pit;
    }

    @Nullable
    public String getTierPreference() {
        Settings settings = this.getIndexSettings().getSettings();
        String value = DataTier.TIER_PREFERENCE_SETTING.get(settings);
        if (!Strings.hasText(value)) {
            return null;
        }
        return value.split(",")[0].trim();
    }

    public QueryRewriteInterceptor getQueryRewriteInterceptor() {
        return this.queryRewriteInterceptor;
    }

    public void setQueryRewriteInterceptor(QueryRewriteInterceptor queryRewriteInterceptor) {
        this.queryRewriteInterceptor = queryRewriteInterceptor;
    }

    public Long getTimeRangeFilterFromMillis() {
        return this.timeRangeFilterFromMillis;
    }

    public void setTimeRangeFilterFromMillis(String fieldName, long timeRangeFilterFromMillis, DateFieldMapper.Resolution resolution) {
        if (this.trackTimeRangeFilterFrom && ("@timestamp".equals(fieldName) || "event.ingested".equals(fieldName))) {
            if (resolution == DateFieldMapper.Resolution.NANOSECONDS) {
                timeRangeFilterFromMillis /= 1000000L;
            }
            this.timeRangeFilterFromMillis = this.timeRangeFilterFromMillis == null ? Long.valueOf(timeRangeFilterFromMillis) : Long.valueOf(Math.min(timeRangeFilterFromMillis, this.timeRangeFilterFromMillis));
        }
    }

    public void setTimeRangeFilterFromMillis(long timeRangeFilterFromMillis) {
        this.timeRangeFilterFromMillis = timeRangeFilterFromMillis;
    }

    public void setTrackTimeRangeFilterFrom(boolean trackTimeRangeFilterFrom) {
        this.trackTimeRangeFilterFrom = trackTimeRangeFilterFrom;
    }

    public <T, U extends QueryRewriteAsyncAction<T, U>> void registerUniqueAsyncAction(QueryRewriteAsyncAction<T, U> action, Consumer<T> consumer) {
        this.uniqueAsyncActions.computeIfAbsent(action, k -> new ArrayList()).add(consumer);
    }
}

