/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.blockloader.docvalues.fn;

import java.io.IOException;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.AbstractBooleansBlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.BlockDocValuesReader;

public class MvMinBooleansBlockLoader
extends AbstractBooleansBlockLoader {
    public MvMinBooleansBlockLoader(String fieldName) {
        super(fieldName);
    }

    @Override
    protected BlockLoader.AllReader singletonReader(NumericDocValues docValues) {
        return new AbstractBooleansBlockLoader.Singleton(docValues);
    }

    @Override
    protected BlockLoader.AllReader sortedReader(SortedNumericDocValues docValues) {
        return new MvMinSorted(docValues);
    }

    public String toString() {
        return "BooleansFromDocValues[" + this.fieldName + "]";
    }

    private static class MvMinSorted
    extends BlockDocValuesReader {
        private final SortedNumericDocValues numericDocValues;

        MvMinSorted(SortedNumericDocValues numericDocValues) {
            this.numericDocValues = numericDocValues;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            try (BlockLoader.BooleanBuilder builder = factory.booleansFromDocValues(docs.count() - offset);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    this.read(doc, builder);
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            this.read(docId, (BlockLoader.BooleanBuilder)builder);
        }

        private void read(int doc, BlockLoader.BooleanBuilder builder) throws IOException {
            if (!this.numericDocValues.advanceExact(doc)) {
                builder.appendNull();
                return;
            }
            builder.appendBoolean(this.numericDocValues.nextValue() != 0L);
        }

        @Override
        public int docId() {
            return this.numericDocValues.docID();
        }

        @Override
        public String toString() {
            return "MvMinBooleansFromDocValues.Sorted";
        }
    }
}

