/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.blockloader.docvalues.fn;

import java.io.IOException;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.AbstractLongsFromDocValuesBlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.BlockDocValuesReader;

public class MvMaxLongsFromDocValuesBlockLoader
extends AbstractLongsFromDocValuesBlockLoader {
    public MvMaxLongsFromDocValuesBlockLoader(String fieldName) {
        super(fieldName);
    }

    @Override
    protected BlockLoader.AllReader singletonReader(NumericDocValues docValues) {
        return new AbstractLongsFromDocValuesBlockLoader.Singleton(docValues);
    }

    @Override
    protected BlockLoader.AllReader sortedReader(SortedNumericDocValues docValues) {
        return new MvMaxSorted(docValues);
    }

    public String toString() {
        return "LongsFromDocValues[" + this.fieldName + "]";
    }

    static void discardAllButLast(SortedNumericDocValues numericDocValues) throws IOException {
        int count = numericDocValues.docValueCount();
        for (int i = 0; i < count - 1; ++i) {
            numericDocValues.nextValue();
        }
    }

    private static class MvMaxSorted
    extends BlockDocValuesReader {
        private final SortedNumericDocValues numericDocValues;

        MvMaxSorted(SortedNumericDocValues numericDocValues) {
            this.numericDocValues = numericDocValues;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            try (BlockLoader.LongBuilder builder = factory.longsFromDocValues(docs.count() - offset);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    this.read(doc, builder);
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            this.read(docId, (BlockLoader.LongBuilder)builder);
        }

        private void read(int doc, BlockLoader.LongBuilder builder) throws IOException {
            if (!this.numericDocValues.advanceExact(doc)) {
                builder.appendNull();
                return;
            }
            MvMaxLongsFromDocValuesBlockLoader.discardAllButLast(this.numericDocValues);
            builder.appendLong(this.numericDocValues.nextValue());
        }

        @Override
        public int docId() {
            return this.numericDocValues.docID();
        }

        @Override
        public String toString() {
            return "MvMaxLongsFromDocValues.Sorted";
        }
    }
}

