/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.blockloader.docvalues;

import java.io.IOException;
import java.util.function.Predicate;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.ByteArrayStreamInput;
import org.elasticsearch.index.mapper.BlockLoader;

public final class CustomBinaryDocValuesReader {
    private final BytesRef scratch = new BytesRef();
    private final ByteArrayStreamInput in = new ByteArrayStreamInput();

    public void read(BytesRef bytes, BlockLoader.BytesRefBuilder builder) throws IOException {
        int count = this.getCount(bytes);
        if (count == 1) {
            this.scratch.length = this.in.readVInt();
            this.scratch.offset = this.in.getPosition();
            builder.appendBytesRef(this.scratch);
            return;
        }
        builder.beginPositionEntry();
        for (int v = 0; v < count; ++v) {
            this.initializeScratch();
            builder.appendBytesRef(this.scratch);
        }
        builder.endPositionEntry();
    }

    public boolean match(BytesRef bytes, Predicate<BytesRef> predicate) throws IOException {
        int count = this.getCount(bytes);
        for (int v = 0; v < count; ++v) {
            this.initializeScratch();
            boolean match = predicate.test(this.scratch);
            if (!match) continue;
            return true;
        }
        return false;
    }

    private void initializeScratch() throws IOException {
        this.scratch.length = this.in.readVInt();
        this.scratch.offset = this.in.getPosition();
        this.in.setPosition(this.scratch.offset + this.scratch.length);
    }

    private int getCount(BytesRef bytes) throws IOException {
        assert (bytes.length > 0);
        this.in.reset(bytes.bytes, bytes.offset, bytes.length);
        int count = this.in.readVInt();
        this.scratch.bytes = bytes.bytes;
        return count;
    }
}

