/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.blockloader.docvalues;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.BlockDocValuesReader;
import org.elasticsearch.index.mapper.blockloader.docvalues.BytesRefsFromCustomBinaryBlockLoader;

public class BytesRefsFromBinaryBlockLoader
extends BlockDocValuesReader.DocValuesBlockLoader {
    private final String fieldName;

    public BytesRefsFromBinaryBlockLoader(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
        return factory.bytesRefs(expectedCount);
    }

    @Override
    public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
        BinaryDocValues docValues = context.reader().getBinaryDocValues(this.fieldName);
        return BytesRefsFromBinaryBlockLoader.createReader(docValues);
    }

    public static BlockLoader.AllReader createReader(@Nullable BinaryDocValues docValues) {
        if (docValues == null) {
            return new BlockLoader.ConstantNullsReader();
        }
        return new BytesRefsFromBinary(docValues);
    }

    static class BytesRefsFromBinary
    extends BytesRefsFromCustomBinaryBlockLoader.AbstractBytesRefsFromBinary {
        BytesRefsFromBinary(BinaryDocValues docValues) {
            super(docValues);
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            BlockLoader.OptionalColumnAtATimeReader direct;
            BlockLoader.Block block;
            BinaryDocValues binaryDocValues = this.docValues;
            if (binaryDocValues instanceof BlockLoader.OptionalColumnAtATimeReader && (block = (direct = (BlockLoader.OptionalColumnAtATimeReader)((Object)binaryDocValues)).tryRead(factory, docs, offset, nullsFiltered, null, false, false)) != null) {
                return block;
            }
            return super.read(factory, docs, offset, nullsFiltered);
        }

        @Override
        public void read(int doc, BlockLoader.BytesRefBuilder builder) throws IOException {
            if (!this.docValues.advanceExact(doc)) {
                builder.appendNull();
                return;
            }
            BytesRef bytes = this.docValues.binaryValue();
            builder.appendBytesRef(bytes);
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.Bytes";
        }
    }
}

