/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public final class XContentDataHelper {
    private static final char STRING_ENCODING = 'S';
    private static final char INTEGER_ENCODING = 'I';
    private static final char LONG_ENCODING = 'L';
    private static final char DOUBLE_ENCODING = 'D';
    private static final char FLOAT_ENCODING = 'F';
    private static final char BIG_INTEGER_ENCODING = 'i';
    private static final char BIG_DECIMAL_ENCODING = 'd';
    private static final char FALSE_ENCODING = 'f';
    private static final char TRUE_ENCODING = 't';
    private static final char BINARY_ENCODING = 'b';
    private static final char NULL_ENCODING = 'n';
    private static final char CBOR_OBJECT_ENCODING = 'c';
    private static final char JSON_OBJECT_ENCODING = 'j';
    private static final char YAML_OBJECT_ENCODING = 'y';
    private static final char SMILE_OBJECT_ENCODING = 's';
    private static final char VOID_ENCODING = 'v';

    static StoredField storedField(String name, XContentParser parser) throws IOException {
        return (StoredField)XContentDataHelper.processToken(parser, typeUtils -> typeUtils.buildStoredField(name, parser));
    }

    static StoredField storedField(String name, XContentBuilder builder) throws IOException {
        return new StoredField(name, TypeUtils.encode(builder));
    }

    static BytesRef encodeToken(XContentParser parser) throws IOException {
        return new BytesRef((byte[])XContentDataHelper.processToken(parser, typeUtils -> typeUtils.encode(parser)));
    }

    public static BytesRef encodeXContentBuilder(XContentBuilder builder) throws IOException {
        return new BytesRef(TypeUtils.encode(builder));
    }

    public static BytesRef voidValue() {
        return new BytesRef(new byte[]{118});
    }

    static void decodeAndWrite(XContentBuilder b, BytesRef r) throws IOException {
        switch ((char)r.bytes[r.offset]) {
            case 'b': {
                TypeUtils.EMBEDDED_OBJECT.decodeAndWrite(b, r);
                break;
            }
            case 'c': 
            case 'j': 
            case 's': 
            case 'y': {
                TypeUtils.START.decodeAndWrite(b, r);
                break;
            }
            case 'd': {
                TypeUtils.BIG_DECIMAL.decodeAndWrite(b, r);
                break;
            }
            case 'f': 
            case 't': {
                TypeUtils.BOOLEAN.decodeAndWrite(b, r);
                break;
            }
            case 'i': {
                TypeUtils.BIG_INTEGER.decodeAndWrite(b, r);
                break;
            }
            case 'S': {
                TypeUtils.STRING.decodeAndWrite(b, r);
                break;
            }
            case 'I': {
                TypeUtils.INTEGER.decodeAndWrite(b, r);
                break;
            }
            case 'L': {
                TypeUtils.LONG.decodeAndWrite(b, r);
                break;
            }
            case 'D': {
                TypeUtils.DOUBLE.decodeAndWrite(b, r);
                break;
            }
            case 'F': {
                TypeUtils.FLOAT.decodeAndWrite(b, r);
                break;
            }
            case 'n': {
                TypeUtils.NULL.decodeAndWrite(b, r);
                break;
            }
            case 'v': {
                TypeUtils.VOID.decodeAndWrite(b, r);
                break;
            }
            default: {
                throw new IllegalArgumentException("Can't decode " + String.valueOf(r));
            }
        }
    }

    static Optional<Object> decode(BytesRef r) {
        return switch ((char)r.bytes[r.offset]) {
            case 'b' -> Optional.of(TypeUtils.EMBEDDED_OBJECT.decode(r));
            case 'c', 'j', 's', 'y' -> Optional.empty();
            case 'd' -> Optional.of(TypeUtils.BIG_DECIMAL.decode(r));
            case 'f', 't' -> Optional.of(TypeUtils.BOOLEAN.decode(r));
            case 'i' -> Optional.of(TypeUtils.BIG_INTEGER.decode(r));
            case 'S' -> Optional.of(TypeUtils.STRING.decode(r));
            case 'I' -> Optional.of(TypeUtils.INTEGER.decode(r));
            case 'L' -> Optional.of(TypeUtils.LONG.decode(r));
            case 'D' -> Optional.of(TypeUtils.DOUBLE.decode(r));
            case 'F' -> Optional.of(TypeUtils.FLOAT.decode(r));
            case 'n' -> Optional.ofNullable(TypeUtils.NULL.decode(r));
            case 'v' -> Optional.of(TypeUtils.VOID.decode(r));
            default -> throw new IllegalArgumentException("Can't decode " + String.valueOf(r));
        };
    }

    static boolean isEncodedObject(BytesRef encoded) {
        return switch ((char)encoded.bytes[encoded.offset]) {
            case 'c', 'j', 's', 'y' -> true;
            default -> false;
        };
    }

    static Optional<XContentType> decodeType(BytesRef encodedValue) {
        return switch ((char)encodedValue.bytes[encodedValue.offset]) {
            case 'c', 'j', 's', 'y' -> Optional.of(XContentDataHelper.getXContentType(encodedValue));
            default -> Optional.empty();
        };
    }

    static void writeMerged(XContentParserConfiguration parserConfig, XContentBuilder b, String fieldName, List<BytesRef> encodedParts) throws IOException {
        if (encodedParts.isEmpty()) {
            return;
        }
        boolean isArray = encodedParts.size() > 1;
        CheckedRunnable startField = () -> {
            if (isArray) {
                b.startArray(fieldName);
            } else {
                b.field(fieldName);
            }
        };
        for (BytesRef encodedValue : encodedParts) {
            Optional encodedXContentType;
            switch ((char)encodedValue.bytes[encodedValue.offset]) {
                case 'c': 
                case 'j': 
                case 's': 
                case 'y': {
                    Optional<Object> optional = Optional.of(XContentDataHelper.getXContentType(encodedValue));
                    break;
                }
                default: {
                    Optional<Object> optional = encodedXContentType = Optional.empty();
                }
            }
            if (encodedXContentType.isEmpty()) {
                if (startField != null) {
                    startField.run();
                    startField = null;
                }
                XContentDataHelper.decodeAndWrite(b, encodedValue);
                continue;
            }
            XContentParser parser = ((XContentType)encodedXContentType.get()).xContent().createParser(parserConfig, encodedValue.bytes, encodedValue.offset + 1, encodedValue.length - 1);
            try {
                if (parser.currentToken() == null && parser.nextToken() == null) continue;
                if (startField != null) {
                    startField.run();
                    startField = null;
                }
                if (isArray && parser.currentToken() == XContentParser.Token.START_ARRAY) {
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        b.copyCurrentStructure(parser);
                    }
                    continue;
                }
                b.copyCurrentStructure(parser);
            }
            finally {
                if (parser == null) continue;
                parser.close();
            }
        }
        if (isArray) {
            b.endArray();
        }
    }

    public static boolean isDataPresent(BytesRef encoded) {
        return encoded.bytes[encoded.offset] != 118;
    }

    public static XContentType getXContentType(BytesRef r) {
        return switch ((char)r.bytes[r.offset]) {
            case 'j' -> XContentType.JSON;
            case 'y' -> XContentType.YAML;
            case 's' -> XContentType.SMILE;
            default -> XContentType.CBOR;
        };
    }

    static Tuple<DocumentParserContext, XContentBuilder> cloneSubContext(DocumentParserContext context) throws IOException {
        Tuple<XContentParserConfiguration, XContentBuilder> tuple = XContentDataHelper.cloneSubContextParserConfiguration(context);
        return Tuple.tuple(XContentDataHelper.cloneDocumentParserContext(context, tuple.v1(), tuple.v2()), tuple.v2());
    }

    static Tuple<DocumentParserContext, XContentParser> cloneSubContextWithParser(DocumentParserContext context) throws IOException {
        Tuple<XContentParserConfiguration, XContentBuilder> tuple = XContentDataHelper.cloneSubContextParserConfiguration(context);
        XContentParser parser = XContentHelper.createParserNotCompressed(tuple.v1(), BytesReference.bytes(tuple.v2()), context.parser().contentType());
        assert (parser.currentToken() == null);
        parser.nextToken();
        return Tuple.tuple(XContentDataHelper.cloneDocumentParserContext(context, tuple.v1(), tuple.v2()), parser);
    }

    private static Tuple<XContentParserConfiguration, XContentBuilder> cloneSubContextParserConfiguration(DocumentParserContext context) throws IOException {
        XContentParser parser = context.parser();
        boolean oldValue = context.path().isWithinLeafObject();
        context.path().setWithinLeafObject(true);
        XContentBuilder builder = XContentBuilder.builder(parser.contentType().xContent());
        builder.copyCurrentStructure(parser);
        context.path().setWithinLeafObject(oldValue);
        XContentParserConfiguration configuration = XContentParserConfiguration.EMPTY.withRegistry(parser.getXContentRegistry()).withDeprecationHandler(parser.getDeprecationHandler()).withRestApiVersion(parser.getRestApiVersion());
        return Tuple.tuple(configuration, builder);
    }

    private static DocumentParserContext cloneDocumentParserContext(DocumentParserContext context, XContentParserConfiguration configuration, XContentBuilder builder) throws IOException {
        XContentParser newParser = XContentHelper.createParserNotCompressed(configuration, BytesReference.bytes(builder), context.parser().contentType());
        newParser = context.parser().switchParser(newParser);
        DocumentParserContext subcontext = context.switchParser(newParser);
        subcontext.setRecordedSource();
        subcontext.parser().nextToken();
        return subcontext;
    }

    private static Object processToken(XContentParser parser, CheckedFunction<TypeUtils, Object, IOException> visitor) throws IOException {
        return switch (parser.currentToken()) {
            case XContentParser.Token.VALUE_STRING -> visitor.apply(TypeUtils.STRING);
            case XContentParser.Token.VALUE_NUMBER -> {
                switch (parser.numberType()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case INT: {
                        yield visitor.apply(TypeUtils.INTEGER);
                    }
                    case LONG: {
                        yield visitor.apply(TypeUtils.LONG);
                    }
                    case DOUBLE: {
                        yield visitor.apply(TypeUtils.DOUBLE);
                    }
                    case FLOAT: {
                        yield visitor.apply(TypeUtils.FLOAT);
                    }
                    case BIG_INTEGER: {
                        yield visitor.apply(TypeUtils.BIG_INTEGER);
                    }
                    case BIG_DECIMAL: 
                }
                yield visitor.apply(TypeUtils.BIG_DECIMAL);
            }
            case XContentParser.Token.VALUE_BOOLEAN -> visitor.apply(TypeUtils.BOOLEAN);
            case XContentParser.Token.VALUE_NULL -> visitor.apply(TypeUtils.NULL);
            case XContentParser.Token.VALUE_EMBEDDED_OBJECT -> visitor.apply(TypeUtils.EMBEDDED_OBJECT);
            case XContentParser.Token.START_OBJECT, XContentParser.Token.START_ARRAY -> visitor.apply(TypeUtils.START);
            default -> throw new IllegalArgumentException("synthetic _source doesn't support malformed objects");
        };
    }

    public static void decodeAndWriteXContent(XContentParserConfiguration parserConfig, XContentBuilder b, XContentType type, BytesRef r) throws IOException {
        try (XContentParser parser = type.xContent().createParser(parserConfig, r.bytes, r.offset + 1, r.length - 1);){
            if (parser.currentToken() == null && parser.nextToken() == null) {
                b.startObject().endObject();
            } else {
                b.copyCurrentStructure(parser);
            }
        }
    }

    private static abstract sealed class TypeUtils
    extends Enum<TypeUtils> {
        public static final /* enum */ TypeUtils STRING = new TypeUtils('S'){

            @Override
            StoredField buildStoredField(String name, XContentParser parser) throws IOException {
                return new StoredField(name, parser.text());
            }

            @Override
            byte[] encode(XContentParser parser) throws IOException {
                byte[] text = parser.text().getBytes(StandardCharsets.UTF_8);
                byte[] bytes = new byte[text.length + 1];
                bytes[0] = this.getEncoding();
                System.arraycopy(text, 0, bytes, 1, text.length);
                this.assertValidEncoding(bytes);
                return bytes;
            }

            @Override
            Object decode(BytesRef r) {
                return new BytesRef(r.bytes, r.offset + 1, r.length - 1);
            }

            @Override
            void decodeAndWrite(XContentBuilder b, BytesRef r) throws IOException {
                b.value(new BytesRef(r.bytes, r.offset + 1, r.length - 1).utf8ToString());
            }
        };
        public static final /* enum */ TypeUtils INTEGER = new TypeUtils('I'){

            @Override
            StoredField buildStoredField(String name, XContentParser parser) throws IOException {
                return new StoredField(name, parser.intValue());
            }

            @Override
            byte[] encode(XContentParser parser) throws IOException {
                byte[] bytes = new byte[5];
                bytes[0] = this.getEncoding();
                ByteUtils.writeIntLE(parser.intValue(), bytes, 1);
                this.assertValidEncoding(bytes);
                return bytes;
            }

            @Override
            Object decode(BytesRef r) {
                return ByteUtils.readIntLE(r.bytes, 1 + r.offset);
            }

            @Override
            void decodeAndWrite(XContentBuilder b, BytesRef r) throws IOException {
                b.value(ByteUtils.readIntLE(r.bytes, 1 + r.offset));
            }
        };
        public static final /* enum */ TypeUtils LONG = new TypeUtils('L'){

            @Override
            StoredField buildStoredField(String name, XContentParser parser) throws IOException {
                return new StoredField(name, parser.longValue());
            }

            @Override
            byte[] encode(XContentParser parser) throws IOException {
                byte[] bytes = new byte[9];
                bytes[0] = this.getEncoding();
                ByteUtils.writeLongLE(parser.longValue(), bytes, 1);
                this.assertValidEncoding(bytes);
                return bytes;
            }

            @Override
            Object decode(BytesRef r) {
                return ByteUtils.readLongLE(r.bytes, 1 + r.offset);
            }

            @Override
            void decodeAndWrite(XContentBuilder b, BytesRef r) throws IOException {
                b.value(ByteUtils.readLongLE(r.bytes, 1 + r.offset));
            }
        };
        public static final /* enum */ TypeUtils DOUBLE = new TypeUtils('D'){

            @Override
            StoredField buildStoredField(String name, XContentParser parser) throws IOException {
                return new StoredField(name, parser.doubleValue());
            }

            @Override
            byte[] encode(XContentParser parser) throws IOException {
                byte[] bytes = new byte[9];
                bytes[0] = this.getEncoding();
                ByteUtils.writeDoubleLE(parser.doubleValue(), bytes, 1);
                this.assertValidEncoding(bytes);
                return bytes;
            }

            @Override
            Object decode(BytesRef r) {
                return ByteUtils.readDoubleLE(r.bytes, 1 + r.offset);
            }

            @Override
            void decodeAndWrite(XContentBuilder b, BytesRef r) throws IOException {
                b.value(ByteUtils.readDoubleLE(r.bytes, 1 + r.offset));
            }
        };
        public static final /* enum */ TypeUtils FLOAT = new TypeUtils('F'){

            @Override
            StoredField buildStoredField(String name, XContentParser parser) throws IOException {
                return new StoredField(name, parser.floatValue());
            }

            @Override
            byte[] encode(XContentParser parser) throws IOException {
                byte[] bytes = new byte[5];
                bytes[0] = this.getEncoding();
                ByteUtils.writeFloatLE(parser.floatValue(), bytes, 1);
                this.assertValidEncoding(bytes);
                return bytes;
            }

            @Override
            Object decode(BytesRef r) {
                return Float.valueOf(ByteUtils.readFloatLE(r.bytes, 1 + r.offset));
            }

            @Override
            void decodeAndWrite(XContentBuilder b, BytesRef r) throws IOException {
                b.value(ByteUtils.readFloatLE(r.bytes, 1 + r.offset));
            }
        };
        public static final /* enum */ TypeUtils BIG_INTEGER = new TypeUtils('i'){

            @Override
            StoredField buildStoredField(String name, XContentParser parser) throws IOException {
                return new StoredField(name, this.encode(parser));
            }

            @Override
            byte[] encode(XContentParser parser) throws IOException {
                byte[] bytes = 6.encode((BigInteger)parser.numberValue(), (Byte)this.getEncoding());
                this.assertValidEncoding(bytes);
                return bytes;
            }

            @Override
            Object decode(BytesRef r) {
                return new BigInteger(r.bytes, r.offset + 1, r.length - 1);
            }

            @Override
            void decodeAndWrite(XContentBuilder b, BytesRef r) throws IOException {
                b.value(new BigInteger(r.bytes, r.offset + 1, r.length - 1));
            }
        };
        public static final /* enum */ TypeUtils BIG_DECIMAL = new TypeUtils('d'){

            @Override
            StoredField buildStoredField(String name, XContentParser parser) throws IOException {
                return new StoredField(name, this.encode(parser));
            }

            @Override
            byte[] encode(XContentParser parser) throws IOException {
                byte[] bytes = 7.encode((BigDecimal)parser.numberValue(), (Byte)this.getEncoding());
                this.assertValidEncoding(bytes);
                return bytes;
            }

            @Override
            Object decode(BytesRef r) {
                if (r.length < 5) {
                    throw new IllegalArgumentException("Can't decode " + String.valueOf(r));
                }
                int scale = ByteUtils.readIntLE(r.bytes, r.offset + 1);
                return new BigDecimal(new BigInteger(r.bytes, r.offset + 5, r.length - 5), scale);
            }

            @Override
            void decodeAndWrite(XContentBuilder b, BytesRef r) throws IOException {
                if (r.length < 5) {
                    throw new IllegalArgumentException("Can't decode " + String.valueOf(r));
                }
                int scale = ByteUtils.readIntLE(r.bytes, r.offset + 1);
                b.value(new BigDecimal(new BigInteger(r.bytes, r.offset + 5, r.length - 5), scale));
            }
        };
        public static final /* enum */ TypeUtils BOOLEAN = new TypeUtils(new Character[]{Character.valueOf('t'), Character.valueOf('f')}){

            @Override
            StoredField buildStoredField(String name, XContentParser parser) throws IOException {
                return new StoredField(name, this.encode(parser));
            }

            @Override
            byte[] encode(XContentParser parser) throws IOException {
                byte[] bytes = new byte[]{parser.booleanValue() ? (byte)116 : 102};
                this.assertValidEncoding(bytes);
                return bytes;
            }

            @Override
            Object decode(BytesRef r) {
                if (r.length != 1) {
                    throw new IllegalArgumentException("Can't decode " + String.valueOf(r));
                }
                assert (r.bytes[r.offset] == 116 || r.bytes[r.offset] == 102) : r.bytes[r.offset];
                return r.bytes[r.offset] == 116;
            }

            @Override
            void decodeAndWrite(XContentBuilder b, BytesRef r) throws IOException {
                if (r.length != 1) {
                    throw new IllegalArgumentException("Can't decode " + String.valueOf(r));
                }
                assert (r.bytes[r.offset] == 116 || r.bytes[r.offset] == 102) : r.bytes[r.offset];
                b.value(r.bytes[r.offset] == 116);
            }
        };
        public static final /* enum */ TypeUtils NULL = new TypeUtils('n'){

            @Override
            StoredField buildStoredField(String name, XContentParser parser) throws IOException {
                return new StoredField(name, this.encode(parser));
            }

            @Override
            byte[] encode(XContentParser parser) throws IOException {
                byte[] bytes = new byte[]{this.getEncoding()};
                this.assertValidEncoding(bytes);
                return bytes;
            }

            @Override
            Object decode(BytesRef r) {
                return null;
            }

            @Override
            void decodeAndWrite(XContentBuilder b, BytesRef r) throws IOException {
                b.nullValue();
            }
        };
        public static final /* enum */ TypeUtils EMBEDDED_OBJECT = new TypeUtils('b'){

            @Override
            StoredField buildStoredField(String name, XContentParser parser) throws IOException {
                return new StoredField(name, 10.encode(parser.binaryValue()));
            }

            @Override
            byte[] encode(XContentParser parser) throws IOException {
                byte[] bytes = 10.encode(parser.binaryValue());
                this.assertValidEncoding(bytes);
                return bytes;
            }

            @Override
            Object decode(BytesRef r) {
                return new BytesRef(r.bytes, r.offset + 1, r.length - 1);
            }

            @Override
            void decodeAndWrite(XContentBuilder b, BytesRef r) throws IOException {
                b.value(r.bytes, r.offset + 1, r.length - 1);
            }
        };
        public static final /* enum */ TypeUtils START = new TypeUtils(new Character[]{Character.valueOf('c'), Character.valueOf('j'), Character.valueOf('y'), Character.valueOf('s')}){

            @Override
            StoredField buildStoredField(String name, XContentParser parser) throws IOException {
                return new StoredField(name, this.encode(parser));
            }

            @Override
            byte[] encode(XContentParser parser) throws IOException {
                try (XContentBuilder builder = XContentBuilder.builder(parser.contentType().xContent());){
                    builder.copyCurrentStructure(parser);
                    byte[] bytes = 11.encode(builder);
                    this.assertValidEncoding(bytes);
                    byte[] byArray = bytes;
                    return byArray;
                }
            }

            @Override
            Object decode(BytesRef r) {
                throw new UnsupportedOperationException();
            }

            @Override
            void decodeAndWrite(XContentBuilder b, BytesRef r) throws IOException {
                switch ((char)r.bytes[r.offset]) {
                    case 'c': {
                        XContentDataHelper.decodeAndWriteXContent(XContentParserConfiguration.EMPTY, b, XContentType.CBOR, r);
                        break;
                    }
                    case 'j': {
                        XContentDataHelper.decodeAndWriteXContent(XContentParserConfiguration.EMPTY, b, XContentType.JSON, r);
                        break;
                    }
                    case 's': {
                        XContentDataHelper.decodeAndWriteXContent(XContentParserConfiguration.EMPTY, b, XContentType.SMILE, r);
                        break;
                    }
                    case 'y': {
                        XContentDataHelper.decodeAndWriteXContent(XContentParserConfiguration.EMPTY, b, XContentType.YAML, r);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Can't decode " + String.valueOf(r));
                    }
                }
            }
        };
        public static final /* enum */ TypeUtils VOID = new TypeUtils('v'){

            @Override
            StoredField buildStoredField(String name, XContentParser parser) throws IOException {
                return new StoredField(name, this.encode(parser));
            }

            @Override
            byte[] encode(XContentParser parser) {
                byte[] bytes = new byte[]{this.getEncoding()};
                this.assertValidEncoding(bytes);
                return bytes;
            }

            @Override
            Object decode(BytesRef r) {
                throw new UnsupportedOperationException();
            }

            @Override
            void decodeAndWrite(XContentBuilder b, BytesRef r) {
            }
        };
        final Character[] encoding;
        private static final /* synthetic */ TypeUtils[] $VALUES;

        public static TypeUtils[] values() {
            return (TypeUtils[])$VALUES.clone();
        }

        public static TypeUtils valueOf(String name) {
            return Enum.valueOf(TypeUtils.class, name);
        }

        private TypeUtils(char encoding) {
            this.encoding = new Character[]{Character.valueOf(encoding)};
        }

        private TypeUtils(Character[] encoding) {
            this.encoding = encoding;
        }

        byte getEncoding() {
            assert (this.encoding.length == 1);
            return (byte)this.encoding[0].charValue();
        }

        void assertValidEncoding(byte[] encodedValue) {
            assert (Arrays.asList(this.encoding).contains(Character.valueOf((char)encodedValue[0])));
        }

        abstract StoredField buildStoredField(String var1, XContentParser var2) throws IOException;

        abstract byte[] encode(XContentParser var1) throws IOException;

        abstract Object decode(BytesRef var1);

        abstract void decodeAndWrite(XContentBuilder var1, BytesRef var2) throws IOException;

        static byte[] encode(BigInteger n, Byte encoding) throws IOException {
            byte[] twosCompliment = n.toByteArray();
            byte[] encoded = new byte[1 + twosCompliment.length];
            encoded[0] = encoding;
            System.arraycopy(twosCompliment, 0, encoded, 1, twosCompliment.length);
            return encoded;
        }

        static byte[] encode(BigDecimal n, Byte encoding) {
            byte[] twosCompliment = n.unscaledValue().toByteArray();
            byte[] encoded = new byte[5 + twosCompliment.length];
            encoded[0] = 100;
            ByteUtils.writeIntLE(n.scale(), encoded, 1);
            System.arraycopy(twosCompliment, 0, encoded, 5, twosCompliment.length);
            return encoded;
        }

        static byte[] encode(byte[] b) {
            byte[] encoded = new byte[1 + b.length];
            encoded[0] = 98;
            System.arraycopy(b, 0, encoded, 1, b.length);
            return encoded;
        }

        static byte[] encode(XContentBuilder builder) throws IOException {
            BytesRef ref;
            BytesReference b = BytesReference.bytes(builder);
            byte[] encoded = new byte[1 + b.length()];
            encoded[0] = switch (builder.contentType()) {
                case XContentType.JSON -> 106;
                case XContentType.SMILE -> 115;
                case XContentType.YAML -> 121;
                case XContentType.CBOR -> 99;
                default -> throw new IllegalArgumentException("unsupported type " + String.valueOf(builder.contentType()));
            };
            int position = 1;
            BytesRefIterator itr = b.iterator();
            while ((ref = itr.next()) != null) {
                System.arraycopy(ref.bytes, ref.offset, encoded, position, ref.length);
                position += ref.length;
            }
            assert (position == encoded.length);
            return encoded;
        }

        private static /* synthetic */ TypeUtils[] $values() {
            return new TypeUtils[]{STRING, INTEGER, LONG, DOUBLE, FLOAT, BIG_INTEGER, BIG_DECIMAL, BOOLEAN, NULL, EMBEDDED_OBJECT, START, VOID};
        }

        static {
            $VALUES = TypeUtils.$values();
        }
    }
}

