/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.BlockStoredFieldsReader;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.IgnoredSourceFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.search.fetch.StoredFieldsSpec;

public final class TimeSeriesMetadataFieldBlockLoader
implements BlockLoader {
    private final Set<String> dimensions;

    public TimeSeriesMetadataFieldBlockLoader(MappedFieldType.BlockLoaderContext context) {
        this.dimensions = TimeSeriesMetadataFieldBlockLoader.dimensionFields(context);
    }

    @Override
    public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
        return factory.bytesRefs(expectedCount);
    }

    @Override
    public BlockLoader.ColumnAtATimeReader columnAtATimeReader(LeafReaderContext context) {
        return null;
    }

    @Override
    public BlockLoader.RowStrideReader rowStrideReader(LeafReaderContext context) throws IOException {
        return new TimeSeries();
    }

    @Override
    public StoredFieldsSpec rowStrideStoredFieldSpec() {
        return StoredFieldsSpec.withSourcePaths(IgnoredSourceFieldMapper.IgnoredSourceFormat.COALESCED_SINGLE_IGNORED_SOURCE, this.dimensions);
    }

    @Override
    public boolean supportsOrdinals() {
        return false;
    }

    @Override
    public SortedSetDocValues ordinals(LeafReaderContext context) {
        throw new UnsupportedOperationException();
    }

    private static Set<String> dimensionFields(MappedFieldType.BlockLoaderContext ctx) {
        if (ctx.indexSettings().getMode() == IndexMode.TIME_SERIES) {
            IndexMetadata indexMetadata = ctx.indexSettings().getIndexMetadata();
            List<String> dimensionFieldsFromSettings = indexMetadata.getTimeSeriesDimensions();
            if (dimensionFieldsFromSettings != null && !dimensionFieldsFromSettings.isEmpty()) {
                return new LinkedHashSet<String>(dimensionFieldsFromSettings);
            }
            LinkedHashSet<String> dimensionFields = new LinkedHashSet<String>();
            MappingLookup mappingLookup = ctx.mappingLookup();
            for (Mapper mapper : mappingLookup.fieldMappers()) {
                FieldMapper fieldMapper;
                MappedFieldType fieldType;
                if (!(mapper instanceof FieldMapper) || !(fieldType = (fieldMapper = (FieldMapper)mapper).fieldType()).isDimension()) continue;
                dimensionFields.add(fieldType.name());
            }
            return dimensionFields;
        }
        throw new IllegalStateException("The TimeSeriesMetadataFieldBlockLoader cannot be used in non-time series mode.");
    }

    private static class TimeSeries
    extends BlockStoredFieldsReader {
        private TimeSeries() {
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            ((BlockLoader.BytesRefBuilder)builder).appendBytesRef(storedFields.source().internalSourceRef().toBytesRef());
        }

        public String toString() {
            return "BlockStoredFieldsReader.TimeSeries";
        }
    }
}

