/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentParser;
import org.elasticsearch.index.mapper.DynamicTemplate;
import org.elasticsearch.index.mapper.IdFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperMetrics;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperRegistry;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MappingParser;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.NestedLookup;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.indices.IndicesModule;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class MapperService
extends AbstractIndexComponent
implements Closeable {
    public static final String SINGLE_MAPPING_NAME = "_doc";
    public static final String TYPE_FIELD_NAME = "_type";
    private static final int LEGACY_NESTED_FIELDS_LIMIT = 50;
    private static final int DEFAULT_NESTED_FIELDS_LIMIT = 100;
    public static final Setting<Long> INDEX_MAPPING_NESTED_FIELDS_LIMIT_SETTING = Setting.longSetting("index.mapping.nested_fields.limit", settings -> {
        IndexVersion indexVersionCreated = IndexMetadata.SETTING_INDEX_VERSION_CREATED.get((Settings)settings);
        return Integer.toString(indexVersionCreated.onOrAfter(IndexVersions.NESTED_PATH_LIMIT) ? 100 : 50);
    }, 0L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    private static final int LEGACY_NESTED_PARENTS_LIMIT = Integer.MAX_VALUE;
    private static final int DEFAULT_NESTED_PARENTS_LIMIT = 50;
    public static final Setting<Long> INDEX_MAPPING_NESTED_PARENTS_LIMIT_SETTING = Setting.longSetting("index.mapping.nested_parents.limit", settings -> {
        IndexVersion indexVersionCreated = IndexMetadata.SETTING_INDEX_VERSION_CREATED.get((Settings)settings);
        return Integer.toString(indexVersionCreated.onOrAfter(IndexVersions.NESTED_PATH_LIMIT) ? 50 : Integer.MAX_VALUE);
    }, 0L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_NESTED_DOCS_LIMIT_SETTING = Setting.longSetting("index.mapping.nested_objects.limit", 10000L, 0L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING = Setting.longSetting("index.mapping.total_fields.limit", 1000L, 0L, Setting.Property.Dynamic, Setting.Property.IndexScope, Setting.Property.ServerlessPublic);
    public static final NodeFeature LOGSDB_DEFAULT_IGNORE_DYNAMIC_BEYOND_LIMIT = new NodeFeature("mapper.logsdb_default_ignore_dynamic_beyond_limit");
    public static final Setting<Boolean> INDEX_MAPPING_IGNORE_DYNAMIC_BEYOND_LIMIT_SETTING = Setting.boolSetting("index.mapping.total_fields.ignore_dynamic_beyond_limit", settings -> {
        boolean isLogsDBIndexMode = IndexSettings.MODE.get((Settings)settings) == IndexMode.LOGSDB;
        IndexVersion indexVersionCreated = IndexMetadata.SETTING_INDEX_VERSION_CREATED.get((Settings)settings);
        boolean isNewIndexVersion = indexVersionCreated.between(IndexVersions.LOGSDB_DEFAULT_IGNORE_DYNAMIC_BEYOND_LIMIT_BACKPORT, IndexVersions.UPGRADE_TO_LUCENE_10_0_0) || indexVersionCreated.onOrAfter(IndexVersions.LOGSDB_DEFAULT_IGNORE_DYNAMIC_BEYOND_LIMIT);
        return String.valueOf(isLogsDBIndexMode && isNewIndexVersion);
    }, Setting.Property.Dynamic, Setting.Property.IndexScope, Setting.Property.ServerlessPublic);
    public static final Setting<Long> INDEX_MAPPING_DEPTH_LIMIT_SETTING = Setting.longSetting("index.mapping.depth.limit", 20L, 1L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_FIELD_NAME_LENGTH_LIMIT_SETTING = Setting.longSetting("index.mapping.field_name_length.limit", Long.MAX_VALUE, 1L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Boolean> INDEX_MAPPING_IGNORE_DYNAMIC_BEYOND_FIELD_NAME_LENGTH_SETTING = Setting.boolSetting("index.mapping.field_name_length.ignore_dynamic_beyond_limit", false, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_DIMENSION_FIELDS_LIMIT_SETTING = Setting.longSetting("index.mapping.dimension_fields.limit", 32768L, 0L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    @Deprecated
    public static final Setting<Boolean> INDEX_MAPPER_DYNAMIC_SETTING = Setting.boolSetting("index.mapper.dynamic", true, Setting.Property.Dynamic, Setting.Property.IndexScope, Setting.Property.IndexSettingDeprecatedInV7AndRemovedInV8);
    private final IndexAnalyzers indexAnalyzers;
    private final MappingParser mappingParser;
    private final DocumentParser documentParser;
    private final IndexVersion indexVersionCreated;
    private final MapperRegistry mapperRegistry;
    private final Supplier<MappingParserContext> mappingParserContextSupplier;
    private final Function<Query, BitSetProducer> bitSetProducer;
    private final MapperMetrics mapperMetrics;
    private volatile DocumentMapper mapper;
    private volatile long mappingVersion;

    public MapperService(ClusterService clusterService, IndexSettings indexSettings, IndexAnalyzers indexAnalyzers, XContentParserConfiguration parserConfiguration, SimilarityService similarityService, MapperRegistry mapperRegistry, Supplier<SearchExecutionContext> searchExecutionContextSupplier, IdFieldMapper idFieldMapper, ScriptCompiler scriptCompiler, Function<Query, BitSetProducer> bitSetProducer, MapperMetrics mapperMetrics, @Nullable DocumentMapper documentMapper) {
        this(() -> clusterService.state().getMinTransportVersion(), indexSettings, indexAnalyzers, parserConfiguration, similarityService, mapperRegistry, searchExecutionContextSupplier, idFieldMapper, scriptCompiler, bitSetProducer, mapperMetrics, documentMapper);
    }

    public MapperService(Supplier<TransportVersion> clusterTransportVersion, IndexSettings indexSettings, IndexAnalyzers indexAnalyzers, XContentParserConfiguration parserConfiguration, SimilarityService similarityService, MapperRegistry mapperRegistry, Supplier<SearchExecutionContext> searchExecutionContextSupplier, IdFieldMapper idFieldMapper, ScriptCompiler scriptCompiler, Function<Query, BitSetProducer> bitSetProducer, MapperMetrics mapperMetrics, @Nullable DocumentMapper documentMapper) {
        super(indexSettings);
        this.indexVersionCreated = indexSettings.getIndexVersionCreated();
        this.indexAnalyzers = indexAnalyzers;
        this.mapperRegistry = mapperRegistry;
        this.mappingParserContextSupplier = () -> new MappingParserContext(similarityService::getSimilarity, type -> mapperRegistry.getMapperParser((String)type, this.indexVersionCreated), mapperRegistry.getRuntimeFieldParsers()::get, this.indexVersionCreated, clusterTransportVersion, searchExecutionContextSupplier, scriptCompiler, indexAnalyzers, indexSettings, idFieldMapper, bitSetProducer, mapperRegistry.getVectorsFormatProviders(), mapperRegistry.getNamespaceValidator());
        this.documentParser = new DocumentParser(parserConfiguration, this.mappingParserContextSupplier.get());
        Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers = mapperRegistry.getMetadataMapperParsers(indexSettings.getIndexVersionCreated());
        this.mappingParser = new MappingParser(this.mappingParserContextSupplier, metadataMapperParsers, this::getMetadataMappers, this::resolveDocumentType);
        this.bitSetProducer = bitSetProducer;
        this.mapperMetrics = mapperMetrics;
        this.mapper = documentMapper;
    }

    public boolean hasNested() {
        return this.mappingLookup().nestedLookup() != NestedLookup.EMPTY;
    }

    public IndexAnalyzers getIndexAnalyzers() {
        return this.indexAnalyzers;
    }

    public MappingParserContext parserContext() {
        return this.mappingParserContextSupplier.get();
    }

    public DocumentParser documentParser() {
        return this.documentParser;
    }

    Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> getMetadataMappers() {
        MappingParserContext mappingParserContext = this.parserContext();
        DocumentMapper existingMapper = this.mapper;
        Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers = this.mapperRegistry.getMetadataMapperParsers(this.indexSettings.getIndexVersionCreated());
        LinkedHashMap<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> metadataMappers = new LinkedHashMap<Class<? extends MetadataFieldMapper>, MetadataFieldMapper>();
        if (existingMapper == null) {
            for (MetadataFieldMapper.TypeParser parser : metadataMapperParsers.values()) {
                MetadataFieldMapper metadataFieldMapper = parser.getDefault(mappingParserContext);
                if (metadataFieldMapper == null) continue;
                metadataMappers.put(metadataFieldMapper.getClass(), metadataFieldMapper);
            }
        } else {
            metadataMappers.putAll(existingMapper.mapping().getMetadataMappersMap());
        }
        return metadataMappers;
    }

    public static Map<String, Object> parseMapping(NamedXContentRegistry xContentRegistry, String mappingSource) throws IOException {
        if ("{}".equals(mappingSource)) {
            return Map.of();
        }
        try (XContentParser parser = XContentType.JSON.xContent().createParser(MapperService.parserConfig(xContentRegistry), mappingSource);){
            Map<String, Object> map = parser.map();
            return map;
        }
    }

    public static Map<String, Object> parseMapping(NamedXContentRegistry xContentRegistry, CompressedXContent mappingSource) throws IOException {
        try (InputStream in = CompressorFactory.COMPRESSOR.threadLocalInputStream(mappingSource.compressedReference().streamInput());){
            Map<String, Object> map;
            block12: {
                XContentParser parser = XContentType.JSON.xContent().createParser(MapperService.parserConfig(xContentRegistry), in);
                try {
                    map = parser.map();
                    if (parser == null) break block12;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return map;
        }
    }

    private static XContentParserConfiguration parserConfig(NamedXContentRegistry xContentRegistry) {
        return XContentParserConfiguration.EMPTY.withRegistry(xContentRegistry).withDeprecationHandler(LoggingDeprecationHandler.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMapping(IndexMetadata currentIndexMetadata, IndexMetadata newIndexMetadata) {
        assert (newIndexMetadata.getIndex().equals(this.index())) : "index mismatch: expected " + String.valueOf(this.index()) + " but was " + String.valueOf(newIndexMetadata.getIndex());
        if (currentIndexMetadata != null && currentIndexMetadata.getMappingVersion() == newIndexMetadata.getMappingVersion()) {
            assert (this.assertNoUpdateRequired(newIndexMetadata));
            return;
        }
        MappingMetadata newMappingMetadata = newIndexMetadata.mapping();
        if (newMappingMetadata != null) {
            String op;
            DocumentMapper previousMapper;
            String type = newMappingMetadata.type();
            CompressedXContent incomingMappingSource = newMappingMetadata.source();
            Mapping incomingMapping = this.parseMapping(type, MergeReason.MAPPING_UPDATE, incomingMappingSource);
            MapperService mapperService = this;
            synchronized (mapperService) {
                previousMapper = this.mapper;
                assert (this.assertRefreshIsNotNeeded(previousMapper, type, incomingMapping));
                this.mapper = this.newDocumentMapper(incomingMapping, MergeReason.MAPPING_RECOVERY, incomingMappingSource);
                this.mappingVersion = newIndexMetadata.getMappingVersion();
            }
            String string = op = previousMapper != null ? "updated" : "added";
            if (this.logger.isDebugEnabled() && incomingMappingSource.compressed().length < 512) {
                this.logger.debug("[{}] {} mapping, source [{}]", (Object)this.index(), (Object)op, (Object)incomingMappingSource.string());
            } else if (this.logger.isTraceEnabled()) {
                this.logger.trace("[{}] {} mapping, source [{}]", (Object)this.index(), (Object)op, (Object)incomingMappingSource.string());
            } else {
                this.logger.debug("[{}] {} mapping (source suppressed due to length, use TRACE level if needed)", (Object)this.index(), (Object)op);
            }
        }
    }

    private boolean assertRefreshIsNotNeeded(DocumentMapper currentMapper, String type, Mapping incomingMapping) {
        CompressedXContent incomingMappingSource;
        CompressedXContent mergedMappingSource;
        Mapping mergedMapping = MapperService.mergeMappings(currentMapper, incomingMapping, MergeReason.MAPPING_RECOVERY, this.indexSettings);
        ToXContent.MapParams params = new ToXContent.MapParams(Collections.singletonMap("skip_runtime", "true"));
        try {
            mergedMappingSource = new CompressedXContent(mergedMapping, params);
        }
        catch (Exception e) {
            throw new AssertionError("failed to serialize source for type [" + type + "]", e);
        }
        try {
            incomingMappingSource = new CompressedXContent(incomingMapping, params);
        }
        catch (Exception e) {
            throw new AssertionError("failed to serialize source for type [" + type + "]", e);
        }
        assert (mergedMappingSource.equals(incomingMappingSource)) : "[" + String.valueOf(this.index()) + "] parsed mapping, and got different sources\nincoming:\n" + String.valueOf(incomingMappingSource) + "\nmerged:\n" + String.valueOf(mergedMappingSource);
        return true;
    }

    boolean assertNoUpdateRequired(IndexMetadata newIndexMetadata) {
        MappingMetadata mapping = newIndexMetadata.mapping();
        if (mapping != null) {
            CompressedXContent newSource;
            Mapping newMapping = this.parseMapping(mapping.type(), MergeReason.MAPPING_UPDATE, mapping.source());
            CompressedXContent currentSource = this.mapper.mappingSource();
            if (!Objects.equals(currentSource, newSource = newMapping.toCompressedXContent()) && !this.mapper.isSyntheticSourceMalformed(currentSource, this.indexVersionCreated)) {
                throw new IllegalStateException("expected current mapping [" + String.valueOf(currentSource) + "] to be the same as new mapping [" + String.valueOf(newSource) + "]");
            }
        }
        return true;
    }

    public void merge(IndexMetadata indexMetadata, MergeReason reason) {
        assert (reason != MergeReason.MAPPING_AUTO_UPDATE_PREFLIGHT);
        MappingMetadata mappingMetadata = indexMetadata.mapping();
        if (mappingMetadata != null) {
            this.merge(mappingMetadata.type(), mappingMetadata.source(), reason);
        }
    }

    public DocumentMapper merge(String type, List<CompressedXContent> mappingSources, MergeReason reason) {
        DocumentMapper currentMapper = this.mapper;
        if (currentMapper != null && mappingSources.size() == 1 && currentMapper.mappingSource().equals(mappingSources.get(0))) {
            return currentMapper;
        }
        Map<String, Object> mergedRawMapping = null;
        for (CompressedXContent mappingSource : mappingSources) {
            Map<String, Object> rawMapping = MappingParser.convertToMap(mappingSource);
            if (rawMapping.containsKey(type)) {
                if (rawMapping.size() > 1) {
                    throw new MapperParsingException("cannot merge a map with multiple roots, one of which is [" + type + "]");
                }
            } else {
                rawMapping = Map.of(type, rawMapping);
            }
            if (mergedRawMapping == null) {
                mergedRawMapping = rawMapping;
                continue;
            }
            XContentHelper.merge(type, mergedRawMapping, rawMapping, RawFieldMappingMerge.INSTANCE);
        }
        if (mergedRawMapping != null && mergedRawMapping.size() > 1) {
            throw new MapperParsingException("cannot merge mapping sources with different roots");
        }
        return mergedRawMapping != null ? this.doMerge(type, reason, mergedRawMapping) : null;
    }

    public DocumentMapper merge(String type, CompressedXContent mappingSource, MergeReason reason) {
        DocumentMapper currentMapper = this.mapper;
        if (currentMapper != null && currentMapper.mappingSource().equals(mappingSource)) {
            return currentMapper;
        }
        Map<String, Object> mappingSourceAsMap = MappingParser.convertToMap(mappingSource);
        return this.doMerge(type, reason, mappingSourceAsMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentMapper doMerge(String type, MergeReason reason, Map<String, Object> mappingSourceAsMap) {
        Mapping incomingMapping = this.parseMapping(type, reason, mappingSourceAsMap);
        if (reason == MergeReason.MAPPING_AUTO_UPDATE_PREFLIGHT) {
            Mapping mapping = MapperService.mergeMappings(this.mapper, incomingMapping, MergeReason.MAPPING_AUTO_UPDATE_PREFLIGHT, this.indexSettings);
            return this.newDocumentMapper(mapping, MergeReason.MAPPING_AUTO_UPDATE_PREFLIGHT, mapping.toCompressedXContent());
        }
        MapperService mapperService = this;
        synchronized (mapperService) {
            DocumentMapper newMapper;
            Mapping mapping = MapperService.mergeMappings(this.mapper, incomingMapping, reason, this.indexSettings);
            this.mapper = newMapper = this.newDocumentMapper(mapping, reason, mapping.toCompressedXContent());
            assert (this.assertSerialization(newMapper, reason));
            return newMapper;
        }
    }

    private DocumentMapper newDocumentMapper(Mapping mapping, MergeReason reason, CompressedXContent mappingSource) {
        DocumentMapper newMapper = new DocumentMapper(this.documentParser, mapping, mappingSource, this.indexVersionCreated, this.mapperMetrics, this.index().getName());
        newMapper.validate(this.indexSettings, reason != MergeReason.MAPPING_RECOVERY);
        return newMapper;
    }

    public Mapping parseMapping(String mappingType, MergeReason reason, CompressedXContent mappingSource) {
        try {
            return this.mappingParser.parse(mappingType, reason, mappingSource);
        }
        catch (Exception e) {
            throw new MapperParsingException("Failed to parse mapping: {}", (Throwable)e, e.getMessage());
        }
    }

    public Mapping parseMapping(String mappingType, MergeReason reason, Map<String, Object> mappingSource) {
        try {
            return this.mappingParser.parse(mappingType, reason, mappingSource);
        }
        catch (Exception e) {
            throw new MapperParsingException("Failed to parse mapping: {}", (Throwable)e, e.getMessage());
        }
    }

    public static Mapping mergeMappings(DocumentMapper currentMapper, Mapping incomingMapping, MergeReason reason, IndexSettings indexSettings) {
        return MapperService.mergeMappings(currentMapper, incomingMapping, reason, MapperService.getMaxFieldsToAddDuringMerge(currentMapper, indexSettings, reason));
    }

    private static long getMaxFieldsToAddDuringMerge(DocumentMapper currentMapper, IndexSettings indexSettings, MergeReason reason) {
        if (reason.isAutoUpdate() && indexSettings.isIgnoreDynamicFieldsBeyondLimit()) {
            long totalFieldsLimit = indexSettings.getMappingTotalFieldsLimit();
            return Optional.ofNullable(currentMapper).map(DocumentMapper::mappers).map(ml -> ml.remainingFieldsUntilLimit(totalFieldsLimit)).orElse(totalFieldsLimit);
        }
        return Long.MAX_VALUE;
    }

    static Mapping mergeMappings(DocumentMapper currentMapper, Mapping incomingMapping, MergeReason reason, long newFieldsBudget) {
        Mapping newMapping = currentMapper == null ? incomingMapping.withFieldsBudget(newFieldsBudget) : currentMapper.mapping().merge(incomingMapping, reason, newFieldsBudget);
        return newMapping;
    }

    private boolean assertSerialization(DocumentMapper mapper, MergeReason reason) {
        CompressedXContent mappingSource = mapper.mappingSource();
        Mapping newMapping = this.parseMapping(mapper.type(), reason, mappingSource);
        if (!newMapping.toCompressedXContent().equals(mappingSource)) {
            throw new AssertionError((Object)("Mapping serialization result is different from source. \n--> Source [" + String.valueOf(mappingSource) + "]\n--> Result [" + String.valueOf(newMapping.toCompressedXContent()) + "]"));
        }
        return true;
    }

    public DocumentMapper documentMapper() {
        return this.mapper;
    }

    public long mappingVersion() {
        return this.mappingVersion;
    }

    public static boolean isMappingSourceTyped(String type, Map<String, Object> mapping) {
        return mapping.size() == 1 && mapping.keySet().iterator().next().equals(type);
    }

    private String resolveDocumentType(String type) {
        if (SINGLE_MAPPING_NAME.equals(type) && this.mapper != null) {
            return this.mapper.type();
        }
        return type;
    }

    public MappedFieldType fieldType(String fullName) {
        return this.mappingLookup().fieldTypesLookup().get(fullName);
    }

    public MappingLookup mappingLookup() {
        DocumentMapper mapper = this.mapper;
        return mapper == null ? MappingLookup.EMPTY : mapper.mappers();
    }

    public Iterable<MappedFieldType> getEagerGlobalOrdinalsFields() {
        DocumentMapper mapper = this.mapper;
        if (mapper == null) {
            return Collections.emptySet();
        }
        MappingLookup mappingLookup = mapper.mappers();
        return mappingLookup.getMatchingFieldNames("*").stream().map(mappingLookup::getFieldType).filter(MappedFieldType::eagerGlobalOrdinals).toList();
    }

    public NamedAnalyzer indexAnalyzer(String field, Function<String, NamedAnalyzer> unindexedFieldAnalyzer) {
        return this.mappingLookup().indexAnalyzer(field, unindexedFieldAnalyzer);
    }

    @Override
    public void close() throws IOException {
        this.indexAnalyzers.close();
    }

    @Deprecated
    public static boolean isMetadataFieldStatic(String fieldName) {
        if (IndicesModule.getBuiltInMetadataFields().contains(fieldName)) {
            return true;
        }
        return fieldName.equals("_size");
    }

    public boolean isMetadataField(String field) {
        Mapper mapper = this.mappingLookup().getMapper(field);
        return mapper instanceof MetadataFieldMapper;
    }

    public boolean isMultiField(String field) {
        return this.mappingLookup().isMultiField(field);
    }

    public synchronized List<String> reloadSearchAnalyzers(AnalysisRegistry registry, @Nullable String resource, boolean preview) throws IOException {
        this.logger.debug("reloading search analyzers for index [{}]", (Object)this.indexSettings.getIndex().getName());
        return this.indexAnalyzers.reload(registry, this.indexSettings, resource, preview);
    }

    public DynamicTemplate[] getAllDynamicTemplates() {
        return this.documentMapper().mapping().getRoot().dynamicTemplates();
    }

    public MapperRegistry getMapperRegistry() {
        return this.mapperRegistry;
    }

    public Function<Query, BitSetProducer> getBitSetProducer() {
        return this.bitSetProducer;
    }

    public MapperMetrics getMapperMetrics() {
        return this.mapperMetrics;
    }

    public static enum MergeReason {
        MAPPING_AUTO_UPDATE_PREFLIGHT{

            @Override
            public boolean isAutoUpdate() {
                return true;
            }
        }
        ,
        MAPPING_AUTO_UPDATE{

            @Override
            public boolean isAutoUpdate() {
                return true;
            }
        }
        ,
        MAPPING_UPDATE,
        INDEX_TEMPLATE,
        MAPPING_RECOVERY;


        public boolean isAutoUpdate() {
            return false;
        }
    }

    private static class RawFieldMappingMerge
    implements XContentHelper.CustomMerge {
        private static final XContentHelper.CustomMerge INSTANCE = new RawFieldMappingMerge();
        private static final Set<String> MERGEABLE_OBJECT_TYPES = Set.of("object", "nested");

        private RawFieldMappingMerge() {
        }

        @Override
        public Object merge(String parent, String key, Object oldValue, Object newValue) {
            if (oldValue instanceof Map && newValue instanceof Map) {
                if ("properties".equals(parent)) {
                    Map baseMap = (Map)oldValue;
                    Map mapToMerge = (Map)newValue;
                    if (this.shouldMergeFieldMappings(baseMap, mapToMerge)) {
                        HashMap<String, Object> mergedMappings = new HashMap<String, Object>();
                        if (baseMap.containsKey("properties")) {
                            mergedMappings.put("properties", new HashMap((Map)baseMap.get("properties")));
                        }
                        if (baseMap.containsKey("subobjects")) {
                            mergedMappings.put("subobjects", baseMap.get("subobjects"));
                        }
                        XContentHelper.merge(mergedMappings, mapToMerge, INSTANCE);
                        return mergedMappings;
                    }
                    return mapToMerge;
                }
                return null;
            }
            if (key.equals("required") && "_routing".equals(parent) && oldValue != newValue) {
                throw new MapperParsingException("contradicting `_routing.required` settings");
            }
            return newValue;
        }

        private boolean shouldMergeFieldMappings(Map<String, Object> mappings1, Map<String, Object> mappings2) {
            String type2;
            String type1 = (String)mappings1.get("type");
            if (type1 == null && mappings1.get("properties") != null) {
                type1 = "object";
            }
            if ((type2 = (String)mappings2.get("type")) == null && mappings2.get("properties") != null) {
                type2 = "object";
            }
            if (type1 == null || type2 == null) {
                return false;
            }
            return MERGEABLE_OBJECT_TYPES.contains(type1) && MERGEABLE_OBJECT_TYPES.contains(type2);
        }
    }
}

