/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.common.geo.SpatialPoint;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.IndexType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.xcontent.XContentParser;

public abstract class AbstractPointGeometryFieldMapper<T>
extends AbstractGeometryFieldMapper<T> {
    protected final T nullValue;

    public static <T> FieldMapper.Parameter<T> nullValueParam(Function<FieldMapper, T> initializer, TriFunction<String, MappingParserContext, Object, T> parser, Supplier<T> def2, FieldMapper.Serializer<T> serializer) {
        return new FieldMapper.Parameter<Object>("null_value", false, def2, parser, initializer, serializer, Objects::toString);
    }

    protected AbstractPointGeometryFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.BuilderParams builderParams, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> ignoreZValue, T nullValue, AbstractGeometryFieldMapper.Parser<T> parser) {
        super(simpleName, mappedFieldType, builderParams, ignoreMalformed, ignoreZValue, parser);
        this.nullValue = nullValue;
    }

    public T getNullValue() {
        return this.nullValue;
    }

    public static abstract class AbstractPointFieldType<T extends SpatialPoint>
    extends AbstractGeometryFieldMapper.AbstractGeometryFieldType<T> {
        protected AbstractPointFieldType(String name, IndexType indexType, boolean stored, AbstractGeometryFieldMapper.Parser<T> geometryParser, T nullValue, Map<String, String> meta) {
            super(name, indexType, stored, geometryParser, nullValue, meta);
        }

        @Override
        protected Object nullValueAsSource(T nullValue) {
            return nullValue == null ? null : nullValue.toWKT();
        }
    }

    protected static abstract class PointParser<T>
    extends AbstractGeometryFieldMapper.Parser<T> {
        protected final String field;
        protected final CheckedFunction<XContentParser, T, IOException> objectParser;
        private final T nullValue;
        private final boolean ignoreZValue;
        protected final boolean ignoreMalformed;
        private final boolean allowMultipleValues;

        protected PointParser(String field, CheckedFunction<XContentParser, T, IOException> objectParser, T nullValue, boolean ignoreZValue, boolean ignoreMalformed, boolean allowMultipleValues) {
            this.field = field;
            this.objectParser = objectParser;
            this.nullValue = nullValue == null ? null : this.validate(nullValue);
            this.ignoreZValue = ignoreZValue;
            this.ignoreMalformed = ignoreMalformed;
            this.allowMultipleValues = allowMultipleValues;
        }

        protected abstract T validate(T var1);

        protected abstract T createPoint(double var1, double var3);

        @Override
        public void parse(XContentParser parser, CheckedConsumer<T, IOException> consumer, AbstractGeometryFieldMapper.MalformedValueHandler malformedHandler) throws IOException {
            if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                XContentParser.Token token = parser.nextToken();
                if (token == XContentParser.Token.VALUE_NUMBER) {
                    double x = parser.doubleValue();
                    parser.nextToken();
                    double y = parser.doubleValue();
                    token = parser.nextToken();
                    if (token == XContentParser.Token.VALUE_NUMBER) {
                        if (!this.ignoreZValue) {
                            throw new ElasticsearchParseException("Exception parsing coordinates: found Z value [{}] but [ignore_z_value] parameter is [{}]", parser.doubleValue(), this.ignoreZValue);
                        }
                    } else if (token != XContentParser.Token.END_ARRAY) {
                        throw new ElasticsearchParseException("field type does not accept > 3 dimensions", new Object[0]);
                    }
                    T point = this.createPoint(x, y);
                    consumer.accept(this.validate(point));
                } else {
                    int count = 0;
                    while (token != XContentParser.Token.END_ARRAY) {
                        if (!this.allowMultipleValues && ++count > 1) {
                            throw new ElasticsearchParseException("field type for [{}] does not accept more than single value", this.field);
                        }
                        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
                            if (this.nullValue != null) {
                                consumer.accept(this.nullValue);
                            }
                        } else {
                            this.parseAndConsumeFromObject(parser, consumer, malformedHandler);
                        }
                        token = parser.nextToken();
                    }
                }
            } else if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
                if (this.nullValue != null) {
                    consumer.accept(this.nullValue);
                }
            } else {
                this.parseAndConsumeFromObject(parser, consumer, malformedHandler);
            }
        }

        protected void parseAndConsumeFromObject(XContentParser parser, CheckedConsumer<T, IOException> consumer, AbstractGeometryFieldMapper.MalformedValueHandler malformedHandler) throws IOException {
            try {
                T point = this.objectParser.apply(parser);
                consumer.accept(this.validate(point));
            }
            catch (Exception e) {
                malformedHandler.notify(e);
            }
        }
    }
}

