/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import org.apache.lucene.search.LongValues;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.MultiPointValues;
import org.elasticsearch.index.fielddata.SortedNumericLongValues;

public class MultiGeoPointValues
extends MultiPointValues<GeoPoint> {
    private final GeoPoint point = new GeoPoint();

    public MultiGeoPointValues(SortedNumericLongValues numericValues) {
        super(numericValues);
    }

    @Override
    public GeoPoint nextValue() throws IOException {
        return this.point.resetFromEncoded(this.numericValues.nextValue());
    }

    protected GeoPointValues getPointValues() {
        LongValues singleton = SortedNumericLongValues.unwrapSingleton(this.numericValues);
        return singleton != null ? new GeoPointValues(singleton) : null;
    }
}

