/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import java.util.function.DoubleToLongFunction;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.DoubleValues;

public abstract class DenseDoubleValues
extends DoubleValues {
    @Override
    public final boolean advanceExact(int doc) throws IOException {
        this.doAdvanceExact(doc);
        return true;
    }

    protected abstract void doAdvanceExact(int var1) throws IOException;

    public static NumericDocValues asNumericDocValues(final DenseDoubleValues in, final int maxDoc, final DoubleToLongFunction converter) {
        return new NumericDocValues(){
            int doc = -1;

            @Override
            public long longValue() throws IOException {
                return converter.applyAsLong(in.doubleValue());
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                this.doc = target;
                return in.advanceExact(target);
            }

            @Override
            public int docID() {
                return this.doc;
            }

            @Override
            public int nextDoc() throws IOException {
                return this.advance(this.doc + 1);
            }

            @Override
            public int advance(int target) throws IOException {
                if (target >= maxDoc) {
                    this.doc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                in.advanceExact(target);
                this.doc = target;
                return this.doc;
            }

            @Override
            public long cost() {
                return maxDoc;
            }
        };
    }
}

