/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.search.similarities.BM25Similarity;
import org.elasticsearch.index.cache.query.TrivialQueryCachingPolicy;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.LuceneChangesSnapshot;
import org.elasticsearch.index.engine.LuceneSyntheticSourceChangesSnapshot;
import org.elasticsearch.index.engine.TranslogDirectoryReader;
import org.elasticsearch.index.mapper.DocumentParser;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;

public abstract class TranslogOperationAsserter {
    public static final TranslogOperationAsserter DEFAULT = new TranslogOperationAsserter(){};

    private TranslogOperationAsserter() {
    }

    public static TranslogOperationAsserter withEngineConfig(final EngineConfig engineConfig) {
        return new TranslogOperationAsserter(){

            @Override
            public boolean assertSameIndexOperation(Translog.Index o1, Translog.Index o2) throws IOException {
                if (super.assertSameIndexOperation(o1, o2)) {
                    return true;
                }
                if (engineConfig.getIndexSettings().isRecoverySourceSyntheticEnabled() || !engineConfig.getMapperService().mappingLookup().inferenceFields().isEmpty() || !engineConfig.getMapperService().mappingLookup().syntheticVectorFields().isEmpty()) {
                    return Translog.Index.equalsWithoutAutoGeneratedTimestamp(2.synthesizeSource(engineConfig, o1), o2, false) || Translog.Index.equalsWithoutAutoGeneratedTimestamp(o1, 2.synthesizeSource(engineConfig, o2), false);
                }
                return false;
            }
        };
    }

    static Translog.Index synthesizeSource(EngineConfig engineConfig, Translog.Index op) throws IOException {
        ShardId shardId = engineConfig.getShardId();
        MappingLookup mappingLookup = engineConfig.getMapperService().mappingLookup();
        DocumentParser documentParser = engineConfig.getMapperService().documentParser();
        try (DirectoryReader reader = TranslogDirectoryReader.create(shardId, op, mappingLookup, documentParser, engineConfig, () -> {}, true);){
            Translog.Index index;
            block13: {
                Engine.Searcher searcher = new Engine.Searcher("assert_translog", reader, new BM25Similarity(), null, TrivialQueryCachingPolicy.NEVER, () -> {});
                Translog.Snapshot snapshot = TranslogOperationAsserter.newSnapshot(engineConfig, op, searcher);
                try {
                    Translog.Operation normalized = snapshot.next();
                    assert (normalized != null) : "expected one operation; got zero";
                    index = (Translog.Index)normalized;
                    if (snapshot == null) break block13;
                }
                catch (Throwable throwable) {
                    if (snapshot != null) {
                        try {
                            snapshot.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                snapshot.close();
            }
            return index;
        }
    }

    static Translog.Snapshot newSnapshot(EngineConfig engineConfig, Translog.Index op, Engine.Searcher searcher) throws IOException {
        if (engineConfig.getIndexSettings().isRecoverySourceSyntheticEnabled()) {
            return new LuceneSyntheticSourceChangesSnapshot(engineConfig.getMapperService(), searcher, 1024, Integer.MAX_VALUE, op.seqNo(), op.seqNo(), true, false, engineConfig.getIndexSettings().getIndexVersionCreated());
        }
        return new LuceneChangesSnapshot(engineConfig.getMapperService(), searcher, 1024, op.seqNo(), op.seqNo(), true, false, false, engineConfig.getIndexSettings().getIndexVersionCreated());
    }

    public boolean assertSameIndexOperation(Translog.Index o1, Translog.Index o2) throws IOException {
        return Translog.Index.equalsWithoutAutoGeneratedTimestamp(o1, o2, true);
    }
}

