/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.es93;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.codecs.hnsw.FlatVectorScorerUtil;
import org.apache.lucene.codecs.hnsw.FlatVectorsReader;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.hnsw.FlatVectorsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.elasticsearch.index.codec.vectors.AbstractFlatVectorsFormat;
import org.elasticsearch.index.codec.vectors.DirectIOCapableFlatVectorsFormat;
import org.elasticsearch.index.codec.vectors.es93.DirectIOCapableLucene99FlatVectorsFormat;
import org.elasticsearch.index.codec.vectors.es93.ES93BFloat16FlatVectorsFormat;
import org.elasticsearch.index.codec.vectors.es93.ES93FlatBitVectorScorer;
import org.elasticsearch.index.codec.vectors.es93.ES93GenericFlatVectorsReader;
import org.elasticsearch.index.codec.vectors.es93.ES93GenericFlatVectorsWriter;
import org.elasticsearch.index.codec.vectors.es93.GenericFormatMetaInformation;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;

public class ES93GenericFlatVectorsFormat
extends AbstractFlatVectorsFormat {
    static final String NAME = "ES93GenericFlatVectorsFormat";
    static final String VECTOR_FORMAT_INFO_EXTENSION = "vfi";
    static final String META_CODEC_NAME = "ES93GenericFlatVectorsFormatMeta";
    public static final int VERSION_START = 0;
    public static final int VERSION_CURRENT = 0;
    private static final GenericFormatMetaInformation META = new GenericFormatMetaInformation("vfi", "ES93GenericFlatVectorsFormatMeta", 0, 0);
    private static final DirectIOCapableFlatVectorsFormat defaultVectorFormat = new DirectIOCapableLucene99FlatVectorsFormat(FlatVectorScorerUtil.getLucene99FlatVectorsScorer());
    private static final DirectIOCapableFlatVectorsFormat bitVectorFormat = new DirectIOCapableLucene99FlatVectorsFormat(ES93FlatBitVectorScorer.INSTANCE){

        @Override
        public String getName() {
            return "ES93BitFlatVectorsFormat";
        }
    };
    private static final DirectIOCapableFlatVectorsFormat bfloat16VectorFormat = new ES93BFloat16FlatVectorsFormat(FlatVectorScorerUtil.getLucene99FlatVectorsScorer());
    private static final Map<String, DirectIOCapableFlatVectorsFormat> supportedFormats = Map.of(defaultVectorFormat.getName(), defaultVectorFormat, bitVectorFormat.getName(), bitVectorFormat, bfloat16VectorFormat.getName(), bfloat16VectorFormat);
    private final DirectIOCapableFlatVectorsFormat writeFormat;
    private final boolean useDirectIO;

    public ES93GenericFlatVectorsFormat() {
        this(DenseVectorFieldMapper.ElementType.FLOAT, false);
    }

    public ES93GenericFlatVectorsFormat(DenseVectorFieldMapper.ElementType elementType, boolean useDirectIO) {
        super(NAME);
        this.writeFormat = switch (elementType) {
            default -> throw new MatchException(null, null);
            case DenseVectorFieldMapper.ElementType.FLOAT, DenseVectorFieldMapper.ElementType.BYTE -> defaultVectorFormat;
            case DenseVectorFieldMapper.ElementType.BIT -> bitVectorFormat;
            case DenseVectorFieldMapper.ElementType.BFLOAT16 -> bfloat16VectorFormat;
        };
        this.useDirectIO = useDirectIO;
    }

    @Override
    public FlatVectorsScorer flatVectorsScorer() {
        return this.writeFormat.flatVectorsScorer();
    }

    @Override
    public FlatVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new ES93GenericFlatVectorsWriter(META, this.writeFormat.getName(), this.useDirectIO, state, this.writeFormat.fieldsWriter(state));
    }

    @Override
    public FlatVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return new ES93GenericFlatVectorsReader(META, state, (f, dio) -> {
            DirectIOCapableFlatVectorsFormat format = supportedFormats.get(f);
            if (format == null) {
                return null;
            }
            return format.fieldsReader(state, dio);
        });
    }

    @Override
    public String toString() {
        return this.getName() + "(name=" + this.getName() + ", format=" + String.valueOf(this.writeFormat) + ")";
    }
}

