/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.es818;

import java.io.IOException;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.VectorUtil;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import org.apache.lucene.util.hnsw.UpdateableRandomVectorScorer;
import org.elasticsearch.index.codec.vectors.BQVectorUtils;
import org.elasticsearch.index.codec.vectors.OptimizedScalarQuantizer;
import org.elasticsearch.index.codec.vectors.es818.BinarizedByteVectorValues;
import org.elasticsearch.index.codec.vectors.es818.ES818BinaryQuantizedVectorsWriter;
import org.elasticsearch.simdvec.ESVectorUtil;

public class ES818BinaryFlatVectorsScorer
implements FlatVectorsScorer {
    private final FlatVectorsScorer nonQuantizedDelegate;
    private static final float FOUR_BIT_SCALE = 0.06666667f;

    public ES818BinaryFlatVectorsScorer(FlatVectorsScorer nonQuantizedDelegate) {
        this.nonQuantizedDelegate = nonQuantizedDelegate;
    }

    @Override
    public RandomVectorScorerSupplier getRandomVectorScorerSupplier(VectorSimilarityFunction similarityFunction, KnnVectorValues vectorValues) throws IOException {
        if (vectorValues instanceof BinarizedByteVectorValues) {
            throw new UnsupportedOperationException("getRandomVectorScorerSupplier(VectorSimilarityFunction,RandomAccessVectorValues) not implemented for binarized format");
        }
        return this.nonQuantizedDelegate.getRandomVectorScorerSupplier(similarityFunction, vectorValues);
    }

    @Override
    public RandomVectorScorer getRandomVectorScorer(final VectorSimilarityFunction similarityFunction, KnnVectorValues vectorValues, float[] target) throws IOException {
        if (vectorValues instanceof BinarizedByteVectorValues) {
            final BinarizedByteVectorValues binarizedVectors = (BinarizedByteVectorValues)vectorValues;
            assert (binarizedVectors.getQuantizer() != null) : "BinarizedByteVectorValues must have a quantizer for ES816BinaryFlatVectorsScorer";
            assert (binarizedVectors.size() > 0) : "BinarizedByteVectorValues must have at least one vector for ES816BinaryFlatVectorsScorer";
            OptimizedScalarQuantizer quantizer = binarizedVectors.getQuantizer();
            float[] centroid = binarizedVectors.getCentroid();
            assert (similarityFunction != VectorSimilarityFunction.COSINE || BQVectorUtils.isUnitVector(target));
            float[] scratch = new float[vectorValues.dimension()];
            int[] initial = new int[target.length];
            final byte[] quantized = new byte[4 * binarizedVectors.discretizedDimensions() / 8];
            final OptimizedScalarQuantizer.QuantizationResult queryCorrections = quantizer.scalarQuantize(target, scratch, initial, (byte)4, centroid);
            ESVectorUtil.transposeHalfByte((int[])initial, (byte[])quantized);
            return new RandomVectorScorer.AbstractRandomVectorScorer(this, vectorValues){

                @Override
                public float score(int i) throws IOException {
                    return ES818BinaryFlatVectorsScorer.quantizedScore(binarizedVectors.dimension(), similarityFunction, binarizedVectors.getCentroidDP(), quantized, queryCorrections, binarizedVectors.vectorValue(i), binarizedVectors.getCorrectiveTerms(i));
                }
            };
        }
        return this.nonQuantizedDelegate.getRandomVectorScorer(similarityFunction, vectorValues, target);
    }

    @Override
    public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction similarityFunction, KnnVectorValues vectorValues, byte[] target) throws IOException {
        return this.nonQuantizedDelegate.getRandomVectorScorer(similarityFunction, vectorValues, target);
    }

    RandomVectorScorerSupplier getRandomVectorScorerSupplier(VectorSimilarityFunction similarityFunction, ES818BinaryQuantizedVectorsWriter.OffHeapBinarizedQueryVectorValues scoringVectors, BinarizedByteVectorValues targetVectors) {
        return new BinarizedRandomVectorScorerSupplier(scoringVectors, targetVectors, similarityFunction);
    }

    public String toString() {
        return "ES818BinaryFlatVectorsScorer(nonQuantizedDelegate=" + String.valueOf(this.nonQuantizedDelegate) + ")";
    }

    private static float quantizedScore(int dims, VectorSimilarityFunction similarityFunction, float centroidDp, byte[] q, OptimizedScalarQuantizer.QuantizationResult queryCorrections, byte[] d, OptimizedScalarQuantizer.QuantizationResult indexCorrections) {
        float qcDist = ESVectorUtil.ipByteBinByte((byte[])q, (byte[])d);
        float x1 = indexCorrections.quantizedComponentSum();
        float ax = indexCorrections.lowerInterval();
        float lx = indexCorrections.upperInterval() - ax;
        float ay = queryCorrections.lowerInterval();
        float ly = (queryCorrections.upperInterval() - ay) * 0.06666667f;
        float y1 = queryCorrections.quantizedComponentSum();
        float score = ax * ay * (float)dims + ay * lx * x1 + ax * ly * y1 + lx * ly * qcDist;
        if (similarityFunction == VectorSimilarityFunction.EUCLIDEAN) {
            score = queryCorrections.additionalCorrection() + indexCorrections.additionalCorrection() - 2.0f * score;
            return Math.max(1.0f / (1.0f + score), 0.0f);
        }
        score += queryCorrections.additionalCorrection() + indexCorrections.additionalCorrection() - centroidDp;
        if (similarityFunction == VectorSimilarityFunction.MAXIMUM_INNER_PRODUCT) {
            return VectorUtil.scaleMaxInnerProductScore(score);
        }
        return Math.max((1.0f + score) / 2.0f, 0.0f);
    }

    static class BinarizedRandomVectorScorerSupplier
    implements RandomVectorScorerSupplier {
        private final ES818BinaryQuantizedVectorsWriter.OffHeapBinarizedQueryVectorValues queryVectors;
        private final BinarizedByteVectorValues targetVectors;
        private final VectorSimilarityFunction similarityFunction;

        BinarizedRandomVectorScorerSupplier(ES818BinaryQuantizedVectorsWriter.OffHeapBinarizedQueryVectorValues queryVectors, BinarizedByteVectorValues targetVectors, VectorSimilarityFunction similarityFunction) {
            this.queryVectors = queryVectors;
            this.targetVectors = targetVectors;
            this.similarityFunction = similarityFunction;
        }

        @Override
        public BinarizedRandomVectorScorer scorer() throws IOException {
            return new BinarizedRandomVectorScorer(this.queryVectors.copy(), this.targetVectors.copy(), this.similarityFunction);
        }

        @Override
        public RandomVectorScorerSupplier copy() throws IOException {
            return new BinarizedRandomVectorScorerSupplier(this.queryVectors, this.targetVectors, this.similarityFunction);
        }
    }

    public static class BinarizedRandomVectorScorer
    extends UpdateableRandomVectorScorer.AbstractUpdateableRandomVectorScorer {
        private final ES818BinaryQuantizedVectorsWriter.OffHeapBinarizedQueryVectorValues queryVectors;
        private final BinarizedByteVectorValues targetVectors;
        private final VectorSimilarityFunction similarityFunction;
        private final byte[] quantizedQuery;
        private OptimizedScalarQuantizer.QuantizationResult queryCorrections = null;
        private int currentOrdinal = -1;

        BinarizedRandomVectorScorer(ES818BinaryQuantizedVectorsWriter.OffHeapBinarizedQueryVectorValues queryVectors, BinarizedByteVectorValues targetVectors, VectorSimilarityFunction similarityFunction) {
            super(targetVectors);
            this.queryVectors = queryVectors;
            this.quantizedQuery = new byte[queryVectors.quantizedDimension()];
            this.targetVectors = targetVectors;
            this.similarityFunction = similarityFunction;
        }

        @Override
        public float score(int targetOrd) throws IOException {
            if (this.queryCorrections == null) {
                throw new IllegalStateException("score() called before setScoringOrdinal()");
            }
            return ES818BinaryFlatVectorsScorer.quantizedScore(this.targetVectors.dimension(), this.similarityFunction, this.targetVectors.getCentroidDP(), this.quantizedQuery, this.queryCorrections, this.targetVectors.vectorValue(targetOrd), this.targetVectors.getCorrectiveTerms(targetOrd));
        }

        @Override
        public void setScoringOrdinal(int i) throws IOException {
            if (i == this.currentOrdinal) {
                return;
            }
            System.arraycopy(this.queryVectors.vectorValue(i), 0, this.quantizedQuery, 0, this.quantizedQuery.length);
            this.queryCorrections = this.queryVectors.getCorrectiveTerms(i);
            this.currentOrdinal = i;
        }
    }
}

