/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.diskbbq;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.FloatVectorValues;
import org.elasticsearch.index.codec.vectors.cluster.KmeansFloatVectorValues;

public interface CentroidSupplier {
    public int size();

    public float[] centroid(int var1) throws IOException;

    public FloatVectorValues asFloatVectorValues() throws IOException;

    public static CentroidSupplier fromArray(final float[][] centroids, final int dims) {
        return new CentroidSupplier(){

            @Override
            public int size() {
                return centroids.length;
            }

            @Override
            public float[] centroid(int centroidOrdinal) {
                return centroids[centroidOrdinal];
            }

            @Override
            public FloatVectorValues asFloatVectorValues() {
                return KmeansFloatVectorValues.build(Arrays.asList(centroids), null, dims);
            }
        };
    }
}

