/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors;

import java.io.IOException;
import org.apache.lucene.search.AcceptDocs;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.hnsw.RandomVectorScorer;

public final class VectorScoringUtils {
    private static final int BULK_SCORE_BLOCKS = 64;

    private VectorScoringUtils() {
    }

    public static void scoreAndCollectAll(KnnCollector knnCollector, AcceptDocs acceptDocs, RandomVectorScorer scorer) throws IOException {
        if (knnCollector.k() == 0 || scorer == null) {
            return;
        }
        Bits acceptedOrds = scorer.getAcceptOrds(acceptDocs.bits());
        int[] ords = new int[64];
        float[] scores = new float[64];
        int numOrds = 0;
        int numVectors = scorer.maxOrd();
        for (int i = 0; i < numVectors; ++i) {
            if (acceptedOrds != null && !acceptedOrds.get(i)) continue;
            if (knnCollector.earlyTerminated()) break;
            ords[numOrds++] = i;
            if (numOrds != ords.length) continue;
            knnCollector.incVisitedCount(numOrds);
            scorer.bulkScore(ords, scores, numOrds);
            for (int j = 0; j < numOrds; ++j) {
                knnCollector.collect(scorer.ordToDoc(ords[j]), scores[j]);
            }
            numOrds = 0;
        }
        if (numOrds > 0) {
            knnCollector.incVisitedCount(numOrds);
            scorer.bulkScore(ords, scores, numOrds);
            for (int j = 0; j < numOrds; ++j) {
                knnCollector.collect(scorer.ordToDoc(ords[j]), scores[j]);
            }
        }
        assert (!knnCollector.earlyTerminated());
    }
}

