/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors;

import java.io.IOException;
import org.apache.lucene.codecs.hnsw.FlatVectorsFormat;
import org.apache.lucene.codecs.hnsw.FlatVectorsReader;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.hnsw.FlatVectorsWriter;
import org.apache.lucene.codecs.lucene99.Lucene99FlatVectorsFormat;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.VectorUtil;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import org.apache.lucene.util.hnsw.UpdateableRandomVectorScorer;
import org.apache.lucene.util.quantization.QuantizedByteVectorValues;

class ES815BitFlatVectorsFormat
extends FlatVectorsFormat {
    static final FlatVectorsFormat delegate = new Lucene99FlatVectorsFormat(FlatBitVectorScorer.INSTANCE);

    protected ES815BitFlatVectorsFormat() {
        super("ES815BitFlatVectorsFormat");
    }

    @Override
    public FlatVectorsWriter fieldsWriter(SegmentWriteState segmentWriteState) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FlatVectorsReader fieldsReader(SegmentReadState segmentReadState) throws IOException {
        return delegate.fieldsReader(segmentReadState);
    }

    @Override
    public int getMaxDimensions(String fieldName) {
        return 4096;
    }

    static float hammingScore(byte[] a, byte[] b) {
        return (float)(a.length * 8 - VectorUtil.xorBitCount(a, b)) / (float)(a.length * 8);
    }

    static class FlatBitVectorScorer
    implements FlatVectorsScorer {
        static final FlatBitVectorScorer INSTANCE = new FlatBitVectorScorer();

        FlatBitVectorScorer() {
        }

        static void checkDimensions(int queryLen, int fieldLen) {
            if (queryLen != fieldLen) {
                throw new IllegalArgumentException("vector query dimension: " + queryLen + " differs from field dimension: " + fieldLen);
            }
        }

        public String toString() {
            return super.toString();
        }

        @Override
        public RandomVectorScorerSupplier getRandomVectorScorerSupplier(VectorSimilarityFunction vectorSimilarityFunction, KnnVectorValues vectorValues) throws IOException {
            assert (vectorValues instanceof ByteVectorValues);
            assert (vectorSimilarityFunction == VectorSimilarityFunction.EUCLIDEAN);
            if (vectorValues instanceof ByteVectorValues) {
                ByteVectorValues byteVectorValues = (ByteVectorValues)vectorValues;
                assert (!(byteVectorValues instanceof QuantizedByteVectorValues));
                switch (vectorSimilarityFunction) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case DOT_PRODUCT: 
                    case MAXIMUM_INNER_PRODUCT: 
                    case COSINE: 
                    case EUCLIDEAN: 
                }
                return new HammingScorerSupplier(byteVectorValues);
            }
            throw new IllegalArgumentException("Unsupported vector type or similarity function");
        }

        @Override
        public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction vectorSimilarityFunction, KnnVectorValues vectorValues, byte[] target) throws IOException {
            assert (vectorValues instanceof ByteVectorValues);
            assert (vectorSimilarityFunction == VectorSimilarityFunction.EUCLIDEAN);
            if (vectorValues instanceof ByteVectorValues) {
                ByteVectorValues byteVectorValues = (ByteVectorValues)vectorValues;
                FlatBitVectorScorer.checkDimensions(target.length, byteVectorValues.dimension());
                switch (vectorSimilarityFunction) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case DOT_PRODUCT: 
                    case MAXIMUM_INNER_PRODUCT: 
                    case COSINE: 
                    case EUCLIDEAN: 
                }
                return new HammingVectorScorer(byteVectorValues, target);
            }
            throw new IllegalArgumentException("Unsupported vector type or similarity function");
        }

        @Override
        public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction similarityFunction, KnnVectorValues vectorValues, float[] target) throws IOException {
            throw new IllegalArgumentException("Unsupported vector type");
        }
    }

    static class HammingScorerSupplier
    implements RandomVectorScorerSupplier {
        private final ByteVectorValues byteValues;
        private final ByteVectorValues targetValues;

        HammingScorerSupplier(ByteVectorValues byteValues) throws IOException {
            this.byteValues = byteValues;
            this.targetValues = byteValues.copy();
        }

        @Override
        public UpdateableRandomVectorScorer scorer() throws IOException {
            return new UpdateableRandomVectorScorer.AbstractUpdateableRandomVectorScorer(this.targetValues){
                private final byte[] query;
                private int currentOrd;
                {
                    super(arg0);
                    this.query = new byte[targetValues.dimension()];
                    this.currentOrd = -1;
                }

                @Override
                public void setScoringOrdinal(int i) throws IOException {
                    if (this.currentOrd == i) {
                        return;
                    }
                    System.arraycopy(targetValues.vectorValue(i), 0, this.query, 0, this.query.length);
                    this.currentOrd = i;
                }

                @Override
                public float score(int i) throws IOException {
                    return ES815BitFlatVectorsFormat.hammingScore(targetValues.vectorValue(i), this.query);
                }
            };
        }

        @Override
        public RandomVectorScorerSupplier copy() throws IOException {
            return new HammingScorerSupplier(this.byteValues);
        }
    }

    static class HammingVectorScorer
    extends RandomVectorScorer.AbstractRandomVectorScorer {
        private final byte[] query;
        private final ByteVectorValues byteValues;

        HammingVectorScorer(ByteVectorValues byteValues, byte[] query) {
            super(byteValues);
            this.query = query;
            this.byteValues = byteValues;
        }

        @Override
        public float score(int i) throws IOException {
            return ES815BitFlatVectorsFormat.hammingScore(this.byteValues.vectorValue(i), this.query);
        }
    }
}

