/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatVectorsFormat;
import org.apache.lucene.codecs.hnsw.FlatVectorsReader;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.search.AcceptDocs;
import org.apache.lucene.search.KnnCollector;
import org.elasticsearch.index.codec.vectors.ES814ScalarQuantizedVectorsFormat;
import org.elasticsearch.index.codec.vectors.VectorScoringUtils;

public class ES813Int8FlatVectorFormat
extends KnnVectorsFormat {
    static final String NAME = "ES813Int8FlatVectorFormat";
    final FlatVectorsFormat format;

    public ES813Int8FlatVectorFormat() {
        this(null, 7, false);
    }

    public ES813Int8FlatVectorFormat(Float confidenceInterval, int bits, boolean compress) {
        super(NAME);
        this.format = new ES814ScalarQuantizedVectorsFormat(confidenceInterval, bits, compress);
    }

    @Override
    public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return new ES813FlatVectorReader(this.format.fieldsReader(state));
    }

    @Override
    public int getMaxDimensions(String fieldName) {
        return 4096;
    }

    public String toString() {
        return "ES813Int8FlatVectorFormat(name=ES813Int8FlatVectorFormat, innerFormat=" + String.valueOf(this.format) + ")";
    }

    public static class ES813FlatVectorReader
    extends KnnVectorsReader {
        private final FlatVectorsReader reader;

        public ES813FlatVectorReader(FlatVectorsReader reader) {
            this.reader = reader;
        }

        @Override
        public void checkIntegrity() throws IOException {
            this.reader.checkIntegrity();
        }

        @Override
        public FloatVectorValues getFloatVectorValues(String field) throws IOException {
            return this.reader.getFloatVectorValues(field);
        }

        @Override
        public ByteVectorValues getByteVectorValues(String field) throws IOException {
            return this.reader.getByteVectorValues(field);
        }

        @Override
        public void search(String field, float[] target, KnnCollector knnCollector, AcceptDocs acceptDocs) throws IOException {
            VectorScoringUtils.scoreAndCollectAll(knnCollector, acceptDocs, this.reader.getRandomVectorScorer(field, target));
        }

        @Override
        public void search(String field, byte[] target, KnnCollector knnCollector, AcceptDocs acceptDocs) throws IOException {
            VectorScoringUtils.scoreAndCollectAll(knnCollector, acceptDocs, this.reader.getRandomVectorScorer(field, target));
        }

        @Override
        public Map<String, Long> getOffHeapByteSize(FieldInfo fieldInfo) {
            return this.reader.getOffHeapByteSize(fieldInfo);
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }
}

