/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors;

import java.util.concurrent.ExecutorService;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.hnsw.FlatVectorsFormat;
import org.apache.lucene.search.TaskExecutor;

public abstract class AbstractHnswVectorsFormat
extends KnnVectorsFormat {
    protected final int maxConn;
    protected final int beamWidth;
    protected final int numMergeWorkers;
    protected final TaskExecutor mergeExec;

    protected AbstractHnswVectorsFormat(String name) {
        this(name, 16, 100, 1, null);
    }

    protected AbstractHnswVectorsFormat(String name, int maxConn, int beamWidth) {
        this(name, maxConn, beamWidth, 1, null);
    }

    protected AbstractHnswVectorsFormat(String name, int maxConn, int beamWidth, int numMergeWorkers, ExecutorService mergeExec) {
        super(name);
        if (maxConn <= 0 || maxConn > 512) {
            throw new IllegalArgumentException("maxConn must be positive and less than or equal to 512; maxConn=" + maxConn);
        }
        if (beamWidth <= 0 || beamWidth > 3200) {
            throw new IllegalArgumentException("beamWidth must be positive and less than or equal to 3200; beamWidth=" + beamWidth);
        }
        this.maxConn = maxConn;
        this.beamWidth = beamWidth;
        if (numMergeWorkers == 1 && mergeExec != null) {
            throw new IllegalArgumentException("No executor service is needed as we'll use single thread to merge");
        }
        this.numMergeWorkers = numMergeWorkers;
        this.mergeExec = mergeExec != null ? new TaskExecutor(mergeExec) : null;
    }

    protected abstract FlatVectorsFormat flatVectorsFormat();

    @Override
    public int getMaxDimensions(String fieldName) {
        return 4096;
    }

    public String toString() {
        return this.getName() + "(name=" + this.getName() + ", maxConn=" + this.maxConn + ", beamWidth=" + this.beamWidth + ", flatVectorFormat=" + String.valueOf(this.flatVectorsFormat()) + ")";
    }
}

