/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.tsdb.es819;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.elasticsearch.index.codec.tsdb.es819.DocValuesConsumerUtil;
import org.elasticsearch.index.codec.tsdb.es819.TsdbDocValuesProducer;

public abstract class XDocValuesConsumer
extends DocValuesConsumer {
    protected XDocValuesConsumer() {
    }

    public void mergeNumericField(DocValuesConsumerUtil.MergeStats mergeStats, final FieldInfo mergeFieldInfo, final MergeState mergeState) throws IOException {
        this.addNumericField(mergeFieldInfo, new TsdbDocValuesProducer(this, mergeStats){

            @Override
            public NumericDocValues getNumeric(FieldInfo fieldInfo) throws IOException {
                if (fieldInfo != mergeFieldInfo) {
                    throw new IllegalArgumentException("wrong fieldInfo");
                }
                return XDocValuesConsumer.getMergedNumericDocValues(mergeState, mergeFieldInfo);
            }
        });
    }

    public void mergeBinaryField(DocValuesConsumerUtil.MergeStats mergeStats, final FieldInfo mergeFieldInfo, final MergeState mergeState) throws IOException {
        this.addBinaryField(mergeFieldInfo, new TsdbDocValuesProducer(this, mergeStats){

            @Override
            public BinaryDocValues getBinary(FieldInfo fieldInfo) throws IOException {
                if (fieldInfo != mergeFieldInfo) {
                    throw new IllegalArgumentException("wrong fieldInfo");
                }
                return XDocValuesConsumer.getMergedBinaryDocValues(mergeFieldInfo, mergeState);
            }
        });
    }

    public void mergeSortedNumericField(DocValuesConsumerUtil.MergeStats mergeStats, final FieldInfo mergeFieldInfo, final MergeState mergeState) throws IOException {
        this.addSortedNumericField(mergeFieldInfo, new TsdbDocValuesProducer(this, mergeStats){

            @Override
            public SortedNumericDocValues getSortedNumeric(FieldInfo fieldInfo) throws IOException {
                if (fieldInfo != mergeFieldInfo) {
                    throw new IllegalArgumentException("wrong FieldInfo");
                }
                return XDocValuesConsumer.getMergedSortedNumericDocValues(mergeFieldInfo, mergeState);
            }
        });
    }

    public void mergeSortedField(DocValuesConsumerUtil.MergeStats mergeStats, final FieldInfo fieldInfo, final MergeState mergeState) throws IOException {
        final OrdinalMap map = XDocValuesConsumer.createOrdinalMapForSortedDV(fieldInfo, mergeState);
        this.addSortedField(fieldInfo, new TsdbDocValuesProducer(this, mergeStats){

            @Override
            public SortedDocValues getSorted(FieldInfo fieldInfoIn) throws IOException {
                if (fieldInfoIn != fieldInfo) {
                    throw new IllegalArgumentException("wrong FieldInfo");
                }
                return XDocValuesConsumer.getMergedSortedSetDocValues(fieldInfo, mergeState, map);
            }
        });
    }

    public void mergeSortedSetField(DocValuesConsumerUtil.MergeStats mergeStats, final FieldInfo mergeFieldInfo, final MergeState mergeState) throws IOException {
        final List<SortedSetDocValues> toMerge = XDocValuesConsumer.selectLeavesToMerge(mergeFieldInfo, mergeState);
        final OrdinalMap map = XDocValuesConsumer.createOrdinalMapForSortedSetDV(toMerge, mergeState);
        this.addSortedSetField(mergeFieldInfo, new TsdbDocValuesProducer(this, mergeStats){

            @Override
            public SortedSetDocValues getSortedSet(FieldInfo fieldInfo) throws IOException {
                if (fieldInfo != mergeFieldInfo) {
                    throw new IllegalArgumentException("wrong FieldInfo");
                }
                return XDocValuesConsumer.getMergedSortedSetDocValues(mergeFieldInfo, mergeState, map, toMerge);
            }
        });
    }
}

