/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.tsdb.es819;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.compressing.Compressor;
import org.apache.lucene.codecs.lucene90.IndexedDISI;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesSkipIndexType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.store.ByteBuffersDataInput;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.ByteBuffersIndexOutput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.LongsRef;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.compress.LZ4;
import org.apache.lucene.util.packed.DirectMonotonicWriter;
import org.apache.lucene.util.packed.PackedInts;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.index.codec.tsdb.BinaryDVCompressionMode;
import org.elasticsearch.index.codec.tsdb.TSDBDocValuesEncoder;
import org.elasticsearch.index.codec.tsdb.es819.BlockMetadataAccumulator;
import org.elasticsearch.index.codec.tsdb.es819.DISIAccumulator;
import org.elasticsearch.index.codec.tsdb.es819.DocValuesConsumerUtil;
import org.elasticsearch.index.codec.tsdb.es819.ES819TSDBDocValuesProducer;
import org.elasticsearch.index.codec.tsdb.es819.OffsetsAccumulator;
import org.elasticsearch.index.codec.tsdb.es819.TsdbDocValuesProducer;
import org.elasticsearch.index.codec.tsdb.es819.XDocValuesConsumer;

final class ES819TSDBDocValuesConsumer
extends XDocValuesConsumer {
    final Directory dir;
    final IOContext context;
    IndexOutput data;
    IndexOutput meta;
    final int maxDoc;
    private byte[] termsDictBuffer;
    private final int skipIndexIntervalSize;
    private final int minDocsPerOrdinalForOrdinalRangeEncoding;
    final boolean enableOptimizedMerge;
    private final int primarySortFieldNumber;
    private final int numericBlockShift;
    private final int numericBlockSize;
    final SegmentWriteState state;
    final BinaryDVCompressionMode binaryDVCompressionMode;
    private final boolean enablePerBlockCompression;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ES819TSDBDocValuesConsumer(BinaryDVCompressionMode binaryDVCompressionMode, boolean enablePerBlockCompression, SegmentWriteState state, int skipIndexIntervalSize, int minDocsPerOrdinalForOrdinalRangeEncoding, boolean enableOptimizedMerge, int numericBlockShift, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        this.binaryDVCompressionMode = binaryDVCompressionMode;
        this.enablePerBlockCompression = enablePerBlockCompression;
        this.state = state;
        this.termsDictBuffer = new byte[16384];
        this.dir = state.directory;
        this.minDocsPerOrdinalForOrdinalRangeEncoding = minDocsPerOrdinalForOrdinalRangeEncoding;
        this.primarySortFieldNumber = ES819TSDBDocValuesProducer.primarySortFieldNumber(state.segmentInfo, state.fieldInfos);
        this.context = state.context;
        this.numericBlockShift = numericBlockShift;
        this.numericBlockSize = 1 << numericBlockShift;
        boolean success = false;
        try {
            String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
            this.data = state.directory.createOutput(dataName, state.context);
            CodecUtil.writeIndexHeader(this.data, dataCodec, 2, state.segmentInfo.getId(), state.segmentSuffix);
            String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
            this.meta = state.directory.createOutput(metaName, state.context);
            CodecUtil.writeIndexHeader(this.meta, metaCodec, 2, state.segmentInfo.getId(), state.segmentSuffix);
            this.meta.writeByte((byte)numericBlockShift);
            this.maxDoc = state.segmentInfo.maxDoc();
            this.skipIndexIntervalSize = skipIndexIntervalSize;
            this.enableOptimizedMerge = enableOptimizedMerge;
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException((Closeable)this);
            }
        }
    }

    @Override
    public void addNumericField(FieldInfo field, final DocValuesProducer valuesProducer) throws IOException {
        this.meta.writeInt(field.number);
        this.meta.writeByte((byte)0);
        TsdbDocValuesProducer producer = new TsdbDocValuesProducer(this, valuesProducer){

            @Override
            public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
                return DocValues.singleton(valuesProducer.getNumeric(field));
            }
        };
        if (field.docValuesSkipIndexType() != DocValuesSkipIndexType.NONE) {
            this.writeSkipIndex(field, producer);
        }
        this.writeField(field, producer, -1L, null);
    }

    private boolean shouldEncodeOrdinalRange(FieldInfo field, long maxOrd, int numDocsWithValue, long numValues) {
        return this.maxDoc > 1 && field.number == this.primarySortFieldNumber && (long)numDocsWithValue == numValues && (long)numDocsWithValue / maxOrd >= (long)this.minDocsPerOrdinalForOrdinalRangeEncoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] writeField(FieldInfo field, TsdbDocValuesProducer valuesProducer, long maxOrd, OffsetsAccumulator offsetsAccumulator) throws IOException {
        SortedNumericDocValues values;
        int numDocsWithValue = 0;
        long numValues = 0L;
        if (valuesProducer.mergeStats.supported()) {
            numDocsWithValue = valuesProducer.mergeStats.sumNumDocsWithField();
            numValues = valuesProducer.mergeStats.sumNumValues();
        } else {
            values = valuesProducer.getSortedNumeric(field);
            int doc = values.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                ++numDocsWithValue;
                int count = values.docValueCount();
                numValues += (long)count;
                doc = values.nextDoc();
            }
        }
        this.meta.writeLong(numValues);
        this.meta.writeInt(numDocsWithValue);
        DISIAccumulator disiAccumulator = null;
        try {
            if (numValues > 0L) {
                assert (numDocsWithValue > 0);
                ByteBuffersDataOutput indexOut = new ByteBuffersDataOutput();
                DirectMonotonicWriter indexWriter = null;
                long valuesDataOffset = this.data.getFilePointer();
                if (maxOrd == 1L) {
                    this.meta.writeInt(-1);
                } else if (this.shouldEncodeOrdinalRange(field, maxOrd, numDocsWithValue, numValues)) {
                    assert (offsetsAccumulator == null);
                    this.meta.writeInt(-2);
                    this.meta.writeVInt(Math.toIntExact(maxOrd));
                    this.meta.writeByte((byte)12);
                    values = valuesProducer.getSortedNumeric(field);
                    if (valuesProducer.mergeStats.supported() && numDocsWithValue < this.maxDoc) {
                        disiAccumulator = new DISIAccumulator(this.dir, this.context, this.data, 9);
                    }
                    DirectMonotonicWriter startDocs = DirectMonotonicWriter.getInstance(this.meta, this.data, maxOrd + 1L, 12);
                    long lastOrd = 0L;
                    startDocs.add(0L);
                    int doc = values.nextDoc();
                    while (doc != Integer.MAX_VALUE) {
                        long nextOrd;
                        if (disiAccumulator != null) {
                            disiAccumulator.addDocId(doc);
                        }
                        if ((nextOrd = values.nextValue()) != lastOrd) {
                            lastOrd = nextOrd;
                            startDocs.add(doc);
                        }
                        doc = values.nextDoc();
                    }
                    startDocs.add(this.maxDoc);
                    startDocs.finish();
                } else {
                    int bitsPerOrd;
                    indexWriter = DirectMonotonicWriter.getInstance(this.meta, new ByteBuffersIndexOutput(indexOut, "temp-dv-index", "temp-dv-index"), 1L + (numValues - 1L >>> this.numericBlockShift), 16);
                    this.meta.writeInt(16);
                    long[] buffer = new long[this.numericBlockSize];
                    int bufferSize = 0;
                    TSDBDocValuesEncoder encoder = new TSDBDocValuesEncoder(this.numericBlockSize);
                    values = valuesProducer.getSortedNumeric(field);
                    int n = bitsPerOrd = maxOrd >= 0L ? PackedInts.bitsRequired(maxOrd - 1L) : -1;
                    if (valuesProducer.mergeStats.supported() && numDocsWithValue < this.maxDoc) {
                        disiAccumulator = new DISIAccumulator(this.dir, this.context, this.data, 9);
                    }
                    int doc = values.nextDoc();
                    while (doc != Integer.MAX_VALUE) {
                        if (disiAccumulator != null) {
                            disiAccumulator.addDocId(doc);
                        }
                        int count = values.docValueCount();
                        if (offsetsAccumulator != null) {
                            offsetsAccumulator.addDoc(count);
                        }
                        for (int i = 0; i < count; ++i) {
                            buffer[bufferSize++] = values.nextValue();
                            if (bufferSize != this.numericBlockSize) continue;
                            indexWriter.add(this.data.getFilePointer() - valuesDataOffset);
                            if (maxOrd >= 0L) {
                                encoder.encodeOrdinals(buffer, this.data, bitsPerOrd);
                            } else {
                                encoder.encode(buffer, this.data);
                            }
                            bufferSize = 0;
                        }
                        doc = values.nextDoc();
                    }
                    if (bufferSize > 0) {
                        indexWriter.add(this.data.getFilePointer() - valuesDataOffset);
                        Arrays.fill(buffer, bufferSize, this.numericBlockSize, 0L);
                        if (maxOrd >= 0L) {
                            encoder.encodeOrdinals(buffer, this.data, bitsPerOrd);
                        } else {
                            encoder.encode(buffer, this.data);
                        }
                    }
                }
                long valuesDataLength = this.data.getFilePointer() - valuesDataOffset;
                if (indexWriter != null) {
                    indexWriter.finish();
                }
                long indexDataOffset = this.data.getFilePointer();
                this.data.copyBytes(indexOut.toDataInput(), indexOut.size());
                this.meta.writeLong(indexDataOffset);
                this.meta.writeLong(this.data.getFilePointer() - indexDataOffset);
                this.meta.writeLong(valuesDataOffset);
                this.meta.writeLong(valuesDataLength);
            }
            if (numDocsWithValue == 0) {
                this.meta.writeLong(-2L);
                this.meta.writeLong(0L);
                this.meta.writeShort((short)-1);
                this.meta.writeByte((byte)-1);
            } else if (numDocsWithValue == this.maxDoc) {
                this.meta.writeLong(-1L);
                this.meta.writeLong(0L);
                this.meta.writeShort((short)-1);
                this.meta.writeByte((byte)-1);
            } else {
                short jumpTableEntryCount;
                long offset = this.data.getFilePointer();
                this.meta.writeLong(offset);
                if (maxOrd != 1L && disiAccumulator != null) {
                    jumpTableEntryCount = disiAccumulator.build(this.data);
                } else {
                    values = valuesProducer.getSortedNumeric(field);
                    jumpTableEntryCount = IndexedDISI.writeBitSet(values, this.data, (byte)9);
                }
                this.meta.writeLong(this.data.getFilePointer() - offset);
                this.meta.writeShort(jumpTableEntryCount);
                this.meta.writeByte((byte)9);
            }
        }
        finally {
            IOUtils.close(disiAccumulator);
        }
        return new long[]{numDocsWithValue, numValues};
    }

    @Override
    public void mergeNumericField(FieldInfo mergeFieldInfo, MergeState mergeState) throws IOException {
        DocValuesConsumerUtil.MergeStats result = DocValuesConsumerUtil.compatibleWithOptimizedMerge(this.enableOptimizedMerge, mergeState, mergeFieldInfo);
        if (result.supported()) {
            this.mergeNumericField(result, mergeFieldInfo, mergeState);
        } else {
            super.mergeNumericField(mergeFieldInfo, mergeState);
        }
    }

    @Override
    public void mergeBinaryField(FieldInfo mergeFieldInfo, MergeState mergeState) throws IOException {
        DocValuesConsumerUtil.MergeStats result = DocValuesConsumerUtil.compatibleWithOptimizedMerge(this.enableOptimizedMerge, mergeState, mergeFieldInfo);
        if (result.supported()) {
            this.mergeBinaryField(result, mergeFieldInfo, mergeState);
        } else {
            super.mergeBinaryField(mergeFieldInfo, mergeState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBinaryField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        block22: {
            block21: {
                this.meta.writeInt(field.number);
                this.meta.writeByte((byte)1);
                this.meta.writeByte(this.binaryDVCompressionMode.code);
                if (!(valuesProducer instanceof TsdbDocValuesProducer)) break block21;
                TsdbDocValuesProducer tsdbValuesProducer = (TsdbDocValuesProducer)valuesProducer;
                if (!tsdbValuesProducer.mergeStats.supported()) break block21;
                int numDocsWithField = tsdbValuesProducer.mergeStats.sumNumDocsWithField();
                int minLength = tsdbValuesProducer.mergeStats.minLength();
                int maxLength = tsdbValuesProducer.mergeStats.maxLength();
                assert (numDocsWithField <= this.maxDoc);
                BinaryDocValues values = valuesProducer.getBinary(field);
                long start = this.data.getFilePointer();
                this.meta.writeLong(start);
                DISIAccumulator disiAccumulator = null;
                BinaryWriter binaryWriter = null;
                try {
                    if (numDocsWithField > 0 && numDocsWithField < this.maxDoc) {
                        disiAccumulator = new DISIAccumulator(this.dir, this.context, this.data, 9);
                    }
                    assert (maxLength >= minLength);
                    if (this.binaryDVCompressionMode == BinaryDVCompressionMode.NO_COMPRESS) {
                        OffsetsAccumulator offsetsAccumulator = maxLength > minLength ? new OffsetsAccumulator(this.dir, this.context, this.data, numDocsWithField) : null;
                        binaryWriter = new DirectBinaryWriter(offsetsAccumulator, null);
                    } else {
                        binaryWriter = new CompressedBinaryBlockWriter(this.binaryDVCompressionMode);
                    }
                    int doc = values.nextDoc();
                    while (doc != Integer.MAX_VALUE) {
                        BytesRef v = values.binaryValue();
                        binaryWriter.addDoc(v);
                        if (disiAccumulator != null) {
                            disiAccumulator.addDocId(doc);
                        }
                        doc = values.nextDoc();
                    }
                    binaryWriter.flushData();
                    this.meta.writeLong(this.data.getFilePointer() - start);
                    if (numDocsWithField == 0) {
                        this.meta.writeLong(-2L);
                        this.meta.writeLong(0L);
                        this.meta.writeShort((short)-1);
                        this.meta.writeByte((byte)-1);
                    } else if (numDocsWithField == this.maxDoc) {
                        this.meta.writeLong(-1L);
                        this.meta.writeLong(0L);
                        this.meta.writeShort((short)-1);
                        this.meta.writeByte((byte)-1);
                    } else {
                        long offset = this.data.getFilePointer();
                        this.meta.writeLong(offset);
                        short jumpTableEntryCount = disiAccumulator.build(this.data);
                        this.meta.writeLong(this.data.getFilePointer() - offset);
                        this.meta.writeShort(jumpTableEntryCount);
                        this.meta.writeByte((byte)9);
                    }
                    this.meta.writeInt(numDocsWithField);
                    this.meta.writeInt(minLength);
                    this.meta.writeInt(maxLength);
                    binaryWriter.writeAddressMetadata(minLength, maxLength, numDocsWithField);
                }
                catch (Throwable throwable) {
                    IOUtils.close(disiAccumulator, binaryWriter);
                    throw throwable;
                }
                IOUtils.close(disiAccumulator, binaryWriter);
                break block22;
            }
            BinaryWriter binaryWriter = null;
            try {
                binaryWriter = this.binaryDVCompressionMode == BinaryDVCompressionMode.NO_COMPRESS ? new DirectBinaryWriter(null, valuesProducer.getBinary(field)) : new CompressedBinaryBlockWriter(this.binaryDVCompressionMode);
                BinaryDocValues values = valuesProducer.getBinary(field);
                long start = this.data.getFilePointer();
                this.meta.writeLong(start);
                int numDocsWithField = 0;
                int minLength = Integer.MAX_VALUE;
                int maxLength = 0;
                int doc = values.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    ++numDocsWithField;
                    BytesRef v = values.binaryValue();
                    int length = v.length;
                    binaryWriter.addDoc(v);
                    minLength = Math.min(length, minLength);
                    maxLength = Math.max(length, maxLength);
                    doc = values.nextDoc();
                }
                binaryWriter.flushData();
                assert (numDocsWithField <= this.maxDoc);
                this.meta.writeLong(this.data.getFilePointer() - start);
                if (numDocsWithField == 0) {
                    this.meta.writeLong(-2L);
                    this.meta.writeLong(0L);
                    this.meta.writeShort((short)-1);
                    this.meta.writeByte((byte)-1);
                } else if (numDocsWithField == this.maxDoc) {
                    this.meta.writeLong(-1L);
                    this.meta.writeLong(0L);
                    this.meta.writeShort((short)-1);
                    this.meta.writeByte((byte)-1);
                } else {
                    long offset = this.data.getFilePointer();
                    this.meta.writeLong(offset);
                    values = valuesProducer.getBinary(field);
                    short jumpTableEntryCount = IndexedDISI.writeBitSet(values, this.data, (byte)9);
                    this.meta.writeLong(this.data.getFilePointer() - offset);
                    this.meta.writeShort(jumpTableEntryCount);
                    this.meta.writeByte((byte)9);
                }
                this.meta.writeInt(numDocsWithField);
                this.meta.writeInt(minLength);
                this.meta.writeInt(maxLength);
                binaryWriter.writeAddressMetadata(minLength, maxLength, numDocsWithField);
            }
            catch (Throwable throwable) {
                IOUtils.close(binaryWriter);
                throw throwable;
            }
            IOUtils.close((Closeable)binaryWriter);
        }
    }

    @Override
    public void addSortedField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.meta.writeInt(field.number);
        this.meta.writeByte((byte)2);
        this.doAddSortedField(field, valuesProducer, false);
    }

    @Override
    public void mergeSortedField(FieldInfo mergeFieldInfo, MergeState mergeState) throws IOException {
        DocValuesConsumerUtil.MergeStats result = DocValuesConsumerUtil.compatibleWithOptimizedMerge(this.enableOptimizedMerge, mergeState, mergeFieldInfo);
        if (result.supported()) {
            this.mergeSortedField(result, mergeFieldInfo, mergeState);
        } else {
            super.mergeSortedField(mergeFieldInfo, mergeState);
        }
    }

    private void doAddSortedField(FieldInfo field, final DocValuesProducer valuesProducer, boolean addTypeByte) throws IOException {
        TsdbDocValuesProducer producer = new TsdbDocValuesProducer(this, valuesProducer){

            @Override
            public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
                final SortedDocValues sorted = valuesProducer.getSorted(field);
                NumericDocValues sortedOrds = new NumericDocValues(this){

                    @Override
                    public long longValue() throws IOException {
                        return sorted.ordValue();
                    }

                    @Override
                    public boolean advanceExact(int target) throws IOException {
                        return sorted.advanceExact(target);
                    }

                    @Override
                    public int docID() {
                        return sorted.docID();
                    }

                    @Override
                    public int nextDoc() throws IOException {
                        return sorted.nextDoc();
                    }

                    @Override
                    public int advance(int target) throws IOException {
                        return sorted.advance(target);
                    }

                    @Override
                    public long cost() {
                        return sorted.cost();
                    }
                };
                return DocValues.singleton(sortedOrds);
            }
        };
        if (field.docValuesSkipIndexType() != DocValuesSkipIndexType.NONE) {
            this.writeSkipIndex(field, producer);
        }
        if (addTypeByte) {
            this.meta.writeByte((byte)0);
        }
        SortedDocValues sorted = valuesProducer.getSorted(field);
        int maxOrd = sorted.getValueCount();
        this.writeField(field, producer, maxOrd, null);
        this.addTermsDict(DocValues.singleton(valuesProducer.getSorted(field)));
    }

    private void addTermsDict(SortedSetDocValues values) throws IOException {
        long size = values.getValueCount();
        this.meta.writeVLong(size);
        int blockMask = 63;
        int shift = 6;
        this.meta.writeInt(16);
        ByteBuffersDataOutput addressBuffer = new ByteBuffersDataOutput();
        ByteBuffersIndexOutput addressOutput = new ByteBuffersIndexOutput(addressBuffer, "temp", "temp");
        long numBlocks = size + (long)blockMask >>> shift;
        DirectMonotonicWriter writer = DirectMonotonicWriter.getInstance(this.meta, addressOutput, numBlocks, 16);
        BytesRefBuilder previous = new BytesRefBuilder();
        long ord = 0L;
        long start = this.data.getFilePointer();
        int maxLength = 0;
        int maxBlockLength = 0;
        TermsEnum iterator = values.termsEnum();
        LZ4.FastCompressionHashTable ht = new LZ4.FastCompressionHashTable();
        ByteArrayDataOutput bufferedOutput = new ByteArrayDataOutput(this.termsDictBuffer);
        int dictLength = 0;
        BytesRef term = iterator.next();
        while (term != null) {
            if ((ord & (long)blockMask) == 0L) {
                if (ord != 0L) {
                    int uncompressedLength = this.compressAndGetTermsDictBlockLength(bufferedOutput, dictLength, ht);
                    maxBlockLength = Math.max(maxBlockLength, uncompressedLength);
                    bufferedOutput.reset(this.termsDictBuffer);
                }
                writer.add(this.data.getFilePointer() - start);
                this.data.writeVInt(term.length);
                this.data.writeBytes(term.bytes, term.offset, term.length);
                bufferedOutput = this.maybeGrowBuffer(bufferedOutput, term.length);
                bufferedOutput.writeBytes(term.bytes, term.offset, term.length);
                dictLength = term.length;
            } else {
                int prefixLength = StringHelper.bytesDifference(previous.get(), term);
                int suffixLength = term.length - prefixLength;
                assert (suffixLength > 0);
                bufferedOutput = this.maybeGrowBuffer(bufferedOutput, suffixLength + 11);
                bufferedOutput.writeByte((byte)(Math.min(prefixLength, 15) | Math.min(15, suffixLength - 1) << 4));
                if (prefixLength >= 15) {
                    bufferedOutput.writeVInt(prefixLength - 15);
                }
                if (suffixLength >= 16) {
                    bufferedOutput.writeVInt(suffixLength - 16);
                }
                bufferedOutput.writeBytes(term.bytes, term.offset + prefixLength, suffixLength);
            }
            maxLength = Math.max(maxLength, term.length);
            previous.copyBytes(term);
            ++ord;
            term = iterator.next();
        }
        if (bufferedOutput.getPosition() > dictLength) {
            int uncompressedLength = this.compressAndGetTermsDictBlockLength(bufferedOutput, dictLength, ht);
            maxBlockLength = Math.max(maxBlockLength, uncompressedLength);
        }
        writer.finish();
        this.meta.writeInt(maxLength);
        this.meta.writeInt(maxBlockLength);
        this.meta.writeLong(start);
        this.meta.writeLong(this.data.getFilePointer() - start);
        start = this.data.getFilePointer();
        addressBuffer.copyTo(this.data);
        this.meta.writeLong(start);
        this.meta.writeLong(this.data.getFilePointer() - start);
        this.writeTermsIndex(values);
    }

    private int compressAndGetTermsDictBlockLength(ByteArrayDataOutput bufferedOutput, int dictLength, LZ4.FastCompressionHashTable ht) throws IOException {
        int uncompressedLength = bufferedOutput.getPosition() - dictLength;
        this.data.writeVInt(uncompressedLength);
        LZ4.compressWithDictionary(this.termsDictBuffer, 0, dictLength, uncompressedLength, this.data, ht);
        return uncompressedLength;
    }

    private ByteArrayDataOutput maybeGrowBuffer(ByteArrayDataOutput bufferedOutput, int termLength) {
        int originalLength;
        int pos = bufferedOutput.getPosition();
        if (pos + termLength >= (originalLength = this.termsDictBuffer.length) - 1) {
            this.termsDictBuffer = ArrayUtil.grow(this.termsDictBuffer, originalLength + termLength);
            bufferedOutput = new ByteArrayDataOutput(this.termsDictBuffer, pos, this.termsDictBuffer.length - pos);
        }
        return bufferedOutput;
    }

    private void writeTermsIndex(SortedSetDocValues values) throws IOException {
        long size = values.getValueCount();
        this.meta.writeInt(10);
        long start = this.data.getFilePointer();
        long numBlocks = 1L + (size + 1023L >>> 10);
        ByteBuffersDataOutput addressBuffer = new ByteBuffersDataOutput();
        try (ByteBuffersIndexOutput addressOutput = new ByteBuffersIndexOutput(addressBuffer, "temp", "temp");){
            DirectMonotonicWriter writer = DirectMonotonicWriter.getInstance(this.meta, addressOutput, numBlocks, 16);
            TermsEnum iterator = values.termsEnum();
            BytesRefBuilder previous = new BytesRefBuilder();
            long offset = 0L;
            long ord = 0L;
            BytesRef term = iterator.next();
            while (term != null) {
                if ((ord & 0x3FFL) == 0L) {
                    writer.add(offset);
                    int sortKeyLength = ord == 0L ? 0 : StringHelper.sortKeyLength(previous.get(), term);
                    offset += (long)sortKeyLength;
                    this.data.writeBytes(term.bytes, term.offset, sortKeyLength);
                } else if ((ord & 0x3FFL) == 1023L) {
                    previous.copyBytes(term);
                }
                ++ord;
                term = iterator.next();
            }
            writer.add(offset);
            writer.finish();
            this.meta.writeLong(start);
            this.meta.writeLong(this.data.getFilePointer() - start);
            start = this.data.getFilePointer();
            addressBuffer.copyTo(this.data);
            this.meta.writeLong(start);
            this.meta.writeLong(this.data.getFilePointer() - start);
        }
    }

    @Override
    public void addSortedNumericField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.meta.writeInt(field.number);
        this.meta.writeByte((byte)4);
        this.writeSortedNumericField(field, new TsdbDocValuesProducer(valuesProducer), -1L);
    }

    private void writeSortedNumericField(FieldInfo field, TsdbDocValuesProducer valuesProducer, long maxOrd) throws IOException {
        if (field.docValuesSkipIndexType() != DocValuesSkipIndexType.NONE) {
            this.writeSkipIndex(field, valuesProducer);
        }
        if (maxOrd > -1L) {
            this.meta.writeByte((byte)1);
        }
        if (valuesProducer.mergeStats.supported()) {
            long numValues;
            int numDocsWithField = valuesProducer.mergeStats.sumNumDocsWithField();
            if ((long)numDocsWithField == (numValues = valuesProducer.mergeStats.sumNumValues())) {
                this.writeField(field, valuesProducer, maxOrd, null);
            } else {
                assert (numValues > (long)numDocsWithField);
                try (OffsetsAccumulator accumulator = new OffsetsAccumulator(this.dir, this.context, this.data, numDocsWithField);){
                    this.writeField(field, valuesProducer, maxOrd, accumulator);
                    accumulator.build(this.meta, this.data);
                }
            }
        } else {
            long[] stats = this.writeField(field, valuesProducer, maxOrd, null);
            int numDocsWithField = Math.toIntExact(stats[0]);
            long numValues = stats[1];
            assert (numValues >= (long)numDocsWithField);
            if (numValues > (long)numDocsWithField) {
                long start = this.data.getFilePointer();
                this.meta.writeLong(start);
                this.meta.writeVInt(16);
                DirectMonotonicWriter addressesWriter = DirectMonotonicWriter.getInstance(this.meta, this.data, (long)numDocsWithField + 1L, 16);
                long addr = 0L;
                addressesWriter.add(addr);
                SortedNumericDocValues values = valuesProducer.getSortedNumeric(field);
                int doc = values.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    addressesWriter.add(addr += (long)values.docValueCount());
                    doc = values.nextDoc();
                }
                addressesWriter.finish();
                this.meta.writeLong(this.data.getFilePointer() - start);
            }
        }
    }

    @Override
    public void mergeSortedNumericField(FieldInfo mergeFieldInfo, MergeState mergeState) throws IOException {
        DocValuesConsumerUtil.MergeStats result = DocValuesConsumerUtil.compatibleWithOptimizedMerge(this.enableOptimizedMerge, mergeState, mergeFieldInfo);
        if (result.supported()) {
            this.mergeSortedNumericField(result, mergeFieldInfo, mergeState);
        } else {
            super.mergeSortedNumericField(mergeFieldInfo, mergeState);
        }
    }

    private static boolean isSingleValued(FieldInfo field, TsdbDocValuesProducer producer) throws IOException {
        if (producer.mergeStats.supported()) {
            return producer.mergeStats.sumNumValues() == (long)producer.mergeStats.sumNumDocsWithField();
        }
        SortedSetDocValues values = producer.getSortedSet(field);
        if (DocValues.unwrapSingleton(values) != null) {
            return true;
        }
        assert (values.docID() == -1);
        int doc = values.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            int docValueCount = values.docValueCount();
            assert (docValueCount > 0);
            if (docValueCount > 1) {
                return false;
            }
            doc = values.nextDoc();
        }
        return true;
    }

    @Override
    public void mergeSortedSetField(FieldInfo mergeFieldInfo, MergeState mergeState) throws IOException {
        DocValuesConsumerUtil.MergeStats result = DocValuesConsumerUtil.compatibleWithOptimizedMerge(this.enableOptimizedMerge, mergeState, mergeFieldInfo);
        if (result.supported()) {
            this.mergeSortedSetField(result, mergeFieldInfo, mergeState);
        } else {
            super.mergeSortedSetField(mergeFieldInfo, mergeState);
        }
    }

    @Override
    public void addSortedSetField(FieldInfo field, final DocValuesProducer valuesProducer) throws IOException {
        this.meta.writeInt(field.number);
        this.meta.writeByte((byte)3);
        if (ES819TSDBDocValuesConsumer.isSingleValued(field, new TsdbDocValuesProducer(valuesProducer))) {
            this.doAddSortedField(field, new TsdbDocValuesProducer(this, valuesProducer){

                @Override
                public SortedDocValues getSorted(FieldInfo field) throws IOException {
                    return SortedSetSelector.wrap(valuesProducer.getSortedSet(field), SortedSetSelector.Type.MIN);
                }
            }, true);
            return;
        }
        SortedSetDocValues values = valuesProducer.getSortedSet(field);
        long maxOrd = values.getValueCount();
        this.writeSortedNumericField(field, new TsdbDocValuesProducer(this, valuesProducer){

            @Override
            public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
                final SortedSetDocValues values = valuesProducer.getSortedSet(field);
                return new SortedNumericDocValues(this){
                    long[] ords = LongsRef.EMPTY_LONGS;
                    int i;
                    int docValueCount;

                    @Override
                    public long nextValue() {
                        return this.ords[this.i++];
                    }

                    @Override
                    public int docValueCount() {
                        return this.docValueCount;
                    }

                    @Override
                    public boolean advanceExact(int target) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public int docID() {
                        return values.docID();
                    }

                    @Override
                    public int nextDoc() throws IOException {
                        int doc = values.nextDoc();
                        if (doc != Integer.MAX_VALUE) {
                            this.docValueCount = values.docValueCount();
                            this.ords = ArrayUtil.grow(this.ords, this.docValueCount);
                            for (int j = 0; j < this.docValueCount; ++j) {
                                this.ords[j] = values.nextOrd();
                            }
                            this.i = 0;
                        }
                        return doc;
                    }

                    @Override
                    public int advance(int target) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public long cost() {
                        return values.cost();
                    }
                };
            }
        }, maxOrd);
        this.addTermsDict(valuesProducer.getSortedSet(field));
    }

    @Override
    public void close() throws IOException {
        block7: {
            block6: {
                boolean success = false;
                try {
                    if (this.meta != null) {
                        this.meta.writeInt(-1);
                        CodecUtil.writeFooter(this.meta);
                    }
                    if (this.data != null) {
                        CodecUtil.writeFooter(this.data);
                    }
                    if (!(success = true)) break block6;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(this.data, this.meta);
                    } else {
                        IOUtils.closeWhileHandlingException(this.data, this.meta);
                    }
                    this.data = null;
                    this.meta = null;
                    throw throwable;
                }
                IOUtils.close(this.data, this.meta);
                break block7;
            }
            IOUtils.closeWhileHandlingException(this.data, this.meta);
        }
        this.data = null;
        this.meta = null;
    }

    private void writeSkipIndex(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        assert (field.docValuesSkipIndexType() != DocValuesSkipIndexType.NONE);
        long start = this.data.getFilePointer();
        SortedNumericDocValues values = valuesProducer.getSortedNumeric(field);
        long globalMaxValue = Long.MIN_VALUE;
        long globalMinValue = Long.MAX_VALUE;
        int globalDocCount = 0;
        int maxDocId = -1;
        ArrayList<SkipAccumulator> accumulators = new ArrayList<SkipAccumulator>();
        SkipAccumulator accumulator = null;
        int maxAccumulators = 512;
        int doc = values.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            long firstValue = values.nextValue();
            if (accumulator != null && accumulator.isDone(this.skipIndexIntervalSize, values.docValueCount(), firstValue, doc)) {
                globalMaxValue = Math.max(globalMaxValue, accumulator.maxValue);
                globalMinValue = Math.min(globalMinValue, accumulator.minValue);
                globalDocCount += accumulator.docCount;
                maxDocId = accumulator.maxDocID;
                accumulator = null;
                if (accumulators.size() == 512) {
                    this.writeLevels(accumulators);
                    accumulators.clear();
                }
            }
            if (accumulator == null) {
                accumulator = new SkipAccumulator(doc);
                accumulators.add(accumulator);
            }
            accumulator.nextDoc(doc);
            accumulator.accumulate(firstValue);
            int end = values.docValueCount();
            for (int i = 1; i < end; ++i) {
                accumulator.accumulate(values.nextValue());
            }
            doc = values.nextDoc();
        }
        if (!accumulators.isEmpty()) {
            globalMaxValue = Math.max(globalMaxValue, accumulator.maxValue);
            globalMinValue = Math.min(globalMinValue, accumulator.minValue);
            globalDocCount += accumulator.docCount;
            maxDocId = accumulator.maxDocID;
            this.writeLevels(accumulators);
        }
        this.meta.writeLong(start);
        this.meta.writeLong(this.data.getFilePointer() - start);
        assert (globalDocCount == 0 || globalMaxValue >= globalMinValue);
        this.meta.writeLong(globalMaxValue);
        this.meta.writeLong(globalMinValue);
        assert (globalDocCount <= maxDocId + 1);
        this.meta.writeInt(globalDocCount);
        this.meta.writeInt(maxDocId);
    }

    private void writeLevels(List<SkipAccumulator> accumulators) throws IOException {
        ArrayList<List<SkipAccumulator>> accumulatorsLevels = new ArrayList<List<SkipAccumulator>>(4);
        accumulatorsLevels.add(accumulators);
        for (int i = 0; i < 3; ++i) {
            accumulatorsLevels.add(ES819TSDBDocValuesConsumer.buildLevel((List)accumulatorsLevels.get(i)));
        }
        int totalAccumulators = accumulators.size();
        for (int index = 0; index < totalAccumulators; ++index) {
            int levels = ES819TSDBDocValuesConsumer.getLevels(index, totalAccumulators);
            this.data.writeByte((byte)levels);
            for (int level = levels - 1; level >= 0; --level) {
                SkipAccumulator accumulator = (SkipAccumulator)((List)accumulatorsLevels.get(level)).get(index >> 3 * level);
                this.data.writeInt(accumulator.maxDocID);
                this.data.writeInt(accumulator.minDocID);
                this.data.writeLong(accumulator.maxValue);
                this.data.writeLong(accumulator.minValue);
                this.data.writeInt(accumulator.docCount);
            }
        }
    }

    private static List<SkipAccumulator> buildLevel(List<SkipAccumulator> accumulators) {
        int levelSize = 8;
        ArrayList<SkipAccumulator> collector = new ArrayList<SkipAccumulator>();
        for (int i = 0; i < accumulators.size() - 8 + 1; i += 8) {
            collector.add(SkipAccumulator.merge(accumulators, i, 8));
        }
        return collector;
    }

    private static int getLevels(int index, int size) {
        if (Integer.numberOfTrailingZeros(index) >= 3) {
            int left = size - index;
            for (int level = 3; level > 0; --level) {
                int numberIntervals = 1 << 3 * level;
                if (left < numberIntervals || index % numberIntervals != 0) continue;
                return level + 1;
            }
        }
        return 1;
    }

    private final class DirectBinaryWriter
    implements BinaryWriter {
        final OffsetsAccumulator offsetsAccumulator;
        final BinaryDocValues values;

        private DirectBinaryWriter(OffsetsAccumulator offsetsAccumulator, BinaryDocValues values) {
            this.offsetsAccumulator = offsetsAccumulator;
            this.values = values;
        }

        @Override
        public void addDoc(BytesRef v) throws IOException {
            ES819TSDBDocValuesConsumer.this.data.writeBytes(v.bytes, v.offset, v.length);
            if (this.offsetsAccumulator != null) {
                this.offsetsAccumulator.addDoc(v.length);
            }
        }

        @Override
        public void writeAddressMetadata(int minLength, int maxLength, int numDocsWithField) throws IOException {
            if (this.offsetsAccumulator != null) {
                this.offsetsAccumulator.build(ES819TSDBDocValuesConsumer.this.meta, ES819TSDBDocValuesConsumer.this.data);
            } else if (this.values != null && maxLength > minLength) {
                long addressStart = ES819TSDBDocValuesConsumer.this.data.getFilePointer();
                ES819TSDBDocValuesConsumer.this.meta.writeLong(addressStart);
                ES819TSDBDocValuesConsumer.this.meta.writeVInt(16);
                DirectMonotonicWriter writer = DirectMonotonicWriter.getInstance(ES819TSDBDocValuesConsumer.this.meta, ES819TSDBDocValuesConsumer.this.data, numDocsWithField + 1, 16);
                long addr = 0L;
                writer.add(addr);
                int doc = this.values.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    writer.add(addr += (long)this.values.binaryValue().length);
                    doc = this.values.nextDoc();
                }
                writer.finish();
                ES819TSDBDocValuesConsumer.this.meta.writeLong(ES819TSDBDocValuesConsumer.this.data.getFilePointer() - addressStart);
            }
        }

        @Override
        public void close() throws IOException {
            IOUtils.close((Closeable)this.offsetsAccumulator);
        }
    }

    private final class CompressedBinaryBlockWriter
    implements BinaryWriter {
        final Compressor compressor;
        final int[] docOffsets = new int[1025];
        int uncompressedBlockLength = 0;
        int maxUncompressedBlockLength = 0;
        int numDocsInCurrentBlock = 0;
        byte[] block = BytesRef.EMPTY_BYTES;
        int totalChunks = 0;
        int maxNumDocsInAnyBlock = 0;
        final BlockMetadataAccumulator blockMetaAcc;

        CompressedBinaryBlockWriter(BinaryDVCompressionMode compressionMode) throws IOException {
            this.compressor = compressionMode.compressionMode().newCompressor();
            long blockAddressesStart = ES819TSDBDocValuesConsumer.this.data.getFilePointer();
            this.blockMetaAcc = new BlockMetadataAccumulator(ES819TSDBDocValuesConsumer.this.state.directory, ES819TSDBDocValuesConsumer.this.state.context, ES819TSDBDocValuesConsumer.this.data, blockAddressesStart);
        }

        @Override
        public void addDoc(BytesRef v) throws IOException {
            this.block = ArrayUtil.grow(this.block, this.uncompressedBlockLength + v.length);
            System.arraycopy(v.bytes, v.offset, this.block, this.uncompressedBlockLength, v.length);
            this.uncompressedBlockLength += v.length;
            ++this.numDocsInCurrentBlock;
            this.docOffsets[this.numDocsInCurrentBlock] = this.uncompressedBlockLength;
            if (this.uncompressedBlockLength >= 131072 || this.numDocsInCurrentBlock >= 1024) {
                this.flushData();
            }
        }

        @Override
        public void flushData() throws IOException {
            if (this.numDocsInCurrentBlock == 0) {
                return;
            }
            ++this.totalChunks;
            long thisBlockStartPointer = ES819TSDBDocValuesConsumer.this.data.getFilePointer();
            boolean shouldCompress = ES819TSDBDocValuesConsumer.this.enablePerBlockCompression;
            BinaryDVCompressionMode.BlockHeader header = new BinaryDVCompressionMode.BlockHeader(shouldCompress);
            ES819TSDBDocValuesConsumer.this.data.writeByte(header.toByte());
            ES819TSDBDocValuesConsumer.this.data.writeVInt(this.uncompressedBlockLength);
            this.maxUncompressedBlockLength = Math.max(this.maxUncompressedBlockLength, this.uncompressedBlockLength);
            this.maxNumDocsInAnyBlock = Math.max(this.maxNumDocsInAnyBlock, this.numDocsInCurrentBlock);
            this.compressOffsets(ES819TSDBDocValuesConsumer.this.data, this.numDocsInCurrentBlock);
            if (shouldCompress) {
                this.compress(this.block, this.uncompressedBlockLength, ES819TSDBDocValuesConsumer.this.data);
            } else {
                ES819TSDBDocValuesConsumer.this.data.writeBytes(this.block, 0, this.uncompressedBlockLength);
            }
            long blockLenBytes = ES819TSDBDocValuesConsumer.this.data.getFilePointer() - thisBlockStartPointer;
            this.blockMetaAcc.addDoc(this.numDocsInCurrentBlock, blockLenBytes);
            this.uncompressedBlockLength = 0;
            this.numDocsInCurrentBlock = 0;
        }

        void compressOffsets(DataOutput output, int numDocsInCurrentBlock) throws IOException {
            int numOffsets = numDocsInCurrentBlock + 1;
            for (int i = numOffsets - 1; i > 0; --i) {
                int n = i;
                this.docOffsets[n] = this.docOffsets[n] - this.docOffsets[i - 1];
            }
            output.writeGroupVInts(this.docOffsets, numOffsets);
        }

        void compress(byte[] data, int uncompressedLength, DataOutput output) throws IOException {
            ByteBuffer inputBuffer = ByteBuffer.wrap(data, 0, uncompressedLength);
            ByteBuffersDataInput input = new ByteBuffersDataInput(List.of(inputBuffer));
            this.compressor.compress(input, output);
        }

        @Override
        public void writeAddressMetadata(int minLength, int maxLength, int numDocsWithField) throws IOException {
            if (this.totalChunks == 0) {
                return;
            }
            long dataAddressesStart = ES819TSDBDocValuesConsumer.this.data.getFilePointer();
            ES819TSDBDocValuesConsumer.this.meta.writeLong(dataAddressesStart);
            ES819TSDBDocValuesConsumer.this.meta.writeVInt(this.totalChunks);
            ES819TSDBDocValuesConsumer.this.meta.writeVInt(this.maxUncompressedBlockLength);
            ES819TSDBDocValuesConsumer.this.meta.writeVInt(this.maxNumDocsInAnyBlock);
            ES819TSDBDocValuesConsumer.this.meta.writeVInt(16);
            this.blockMetaAcc.build(ES819TSDBDocValuesConsumer.this.meta, ES819TSDBDocValuesConsumer.this.data);
        }

        @Override
        public void close() throws IOException {
            IOUtils.close((Closeable)this.blockMetaAcc);
        }
    }

    private static sealed interface BinaryWriter
    extends Closeable
    permits DirectBinaryWriter, CompressedBinaryBlockWriter {
        public void addDoc(BytesRef var1) throws IOException;

        default public void flushData() throws IOException {
        }

        default public void writeAddressMetadata(int minLength, int maxLength, int numDocsWithField) throws IOException {
        }

        @Override
        default public void close() throws IOException {
        }
    }

    private static class SkipAccumulator {
        int minDocID;
        int maxDocID;
        int docCount;
        long minValue;
        long maxValue;

        SkipAccumulator(int docID) {
            this.minDocID = docID;
            this.minValue = Long.MAX_VALUE;
            this.maxValue = Long.MIN_VALUE;
            this.docCount = 0;
        }

        boolean isDone(int skipIndexIntervalSize, int valueCount, long nextValue, int nextDoc) {
            if (this.docCount < skipIndexIntervalSize) {
                return false;
            }
            return valueCount > 1 || this.minValue != this.maxValue || this.minValue != nextValue || this.docCount != nextDoc - this.minDocID;
        }

        void accumulate(long value) {
            this.minValue = Math.min(this.minValue, value);
            this.maxValue = Math.max(this.maxValue, value);
        }

        void accumulate(SkipAccumulator other) {
            assert (this.minDocID <= other.minDocID && this.maxDocID < other.maxDocID);
            this.maxDocID = other.maxDocID;
            this.minValue = Math.min(this.minValue, other.minValue);
            this.maxValue = Math.max(this.maxValue, other.maxValue);
            this.docCount += other.docCount;
        }

        void nextDoc(int docID) {
            this.maxDocID = docID;
            ++this.docCount;
        }

        public static SkipAccumulator merge(List<SkipAccumulator> list, int index, int length) {
            SkipAccumulator acc = new SkipAccumulator(list.get((int)index).minDocID);
            for (int i = 0; i < length; ++i) {
                acc.accumulate(list.get(index + i));
            }
            return acc;
        }
    }
}

