/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.tsdb.es819;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.packed.DirectMonotonicWriter;
import org.elasticsearch.core.IOUtils;

final class BlockMetadataAccumulator
implements Closeable {
    private final DelayedOffsetAccumulator blockAddressAcc;
    private final DelayedOffsetAccumulator blockDocRangeAcc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BlockMetadataAccumulator(Directory dir, IOContext context, IndexOutput data, long addressesStart) throws IOException {
        boolean success = false;
        try {
            this.blockDocRangeAcc = new DelayedOffsetAccumulator(dir, context, data, "block-doc-ranges", 0L);
            this.blockAddressAcc = new DelayedOffsetAccumulator(dir, context, data, "block-addresses", addressesStart);
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException((Closeable)this);
            }
        }
    }

    public void addDoc(long numDocsInBlock, long blockLenInBytes) throws IOException {
        this.blockDocRangeAcc.addDoc(numDocsInBlock);
        this.blockAddressAcc.addDoc(blockLenInBytes);
    }

    public void build(IndexOutput meta, IndexOutput data) throws IOException {
        long dataAddressesStart = data.getFilePointer();
        this.blockAddressAcc.build(meta, data);
        long dataDocRangeStart = data.getFilePointer();
        long addressesLength = dataDocRangeStart - dataAddressesStart;
        meta.writeLong(addressesLength);
        meta.writeLong(dataDocRangeStart);
        this.blockDocRangeAcc.build(meta, data);
        long docRangesLen = data.getFilePointer() - dataDocRangeStart;
        meta.writeLong(docRangesLen);
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeWhileHandlingException(this.blockAddressAcc, this.blockDocRangeAcc);
    }

    static final class DelayedOffsetAccumulator
    implements Closeable {
        private final Directory dir;
        private final long startOffset;
        private int numValues = 0;
        private final IndexOutput tempOutput;
        private final String suffix;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DelayedOffsetAccumulator(Directory dir, IOContext context, IndexOutput data, String suffix, long startOffset) throws IOException {
            this.dir = dir;
            this.startOffset = startOffset;
            this.suffix = suffix;
            boolean success = false;
            try {
                this.tempOutput = dir.createTempOutput(data.getName(), suffix, context);
                CodecUtil.writeHeader(this.tempOutput, "ES819TSDBDocValuesMetadata" + suffix, 2);
                success = true;
            }
            finally {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable)this);
                }
            }
        }

        void addDoc(long delta) throws IOException {
            this.tempOutput.writeVLong(delta);
            ++this.numValues;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void build(IndexOutput meta, IndexOutput data) throws IOException {
            block12: {
                CodecUtil.writeFooter(this.tempOutput);
                IOUtils.close((Closeable)this.tempOutput);
                try (ChecksumIndexInput tempInput = this.dir.openChecksumInput(this.tempOutput.getName());){
                    CodecUtil.checkHeader(tempInput, "ES819TSDBDocValuesMetadata" + this.suffix, 2, 2);
                    Throwable priorE = null;
                    try {
                        DirectMonotonicWriter writer = DirectMonotonicWriter.getInstance(meta, data, this.numValues + 1, 16);
                        long offset = this.startOffset;
                        writer.add(offset);
                        for (int i = 0; i < this.numValues; ++i) {
                            writer.add(offset += tempInput.readVLong());
                        }
                        writer.finish();
                    }
                    catch (Throwable e) {
                        try {
                            priorE = e;
                            break block12;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            CodecUtil.checkFooter(tempInput, priorE);
                        }
                    }
                    CodecUtil.checkFooter(tempInput, priorE);
                }
            }
        }

        @Override
        public void close() throws IOException {
            if (this.tempOutput != null) {
                IOUtils.close(this.tempOutput, () -> this.dir.deleteFile(this.tempOutput.getName()));
            }
        }
    }
}

