/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.storedfields;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.index.codec.bloomfilter.BloomFilter;
import org.elasticsearch.index.codec.bloomfilter.ES93BloomFilterStoredFieldsFormat;

public class TSDBStoredFieldsFormat
extends StoredFieldsFormat {
    private final StoredFieldsFormat delegate;
    private final ES93BloomFilterStoredFieldsFormat bloomFilterStoredFieldsFormat;

    public TSDBStoredFieldsFormat(StoredFieldsFormat delegate, ES93BloomFilterStoredFieldsFormat bloomFilterStoredFieldsFormat) {
        this.delegate = delegate;
        this.bloomFilterStoredFieldsFormat = bloomFilterStoredFieldsFormat;
    }

    @Override
    public StoredFieldsReader fieldsReader(Directory directory, SegmentInfo si, FieldInfos fn, IOContext context) throws IOException {
        return new TSDBStoredFieldsReader(directory, si, fn, context);
    }

    @Override
    public StoredFieldsWriter fieldsWriter(Directory directory, SegmentInfo si, IOContext context) throws IOException {
        return new TSDBStoredFieldsWriter(this, directory, si, context);
    }

    public static BloomFilter getBloomFilterForId(SegmentReadState state) throws IOException {
        Codec codec = state.segmentInfo.getCodec();
        StoredFieldsReader storedFieldsReader = codec.storedFieldsFormat().fieldsReader(state.directory, state.segmentInfo, state.fieldInfos, state.context);
        if (storedFieldsReader instanceof BloomFilter) {
            BloomFilter bloomFilter = (BloomFilter)((Object)storedFieldsReader);
            return bloomFilter;
        }
        storedFieldsReader.close();
        return BloomFilter.NO_FILTER;
    }

    class TSDBStoredFieldsReader
    extends StoredFieldsReader
    implements BloomFilter {
        private final StoredFieldsReader storedFieldsReader;
        private final StoredFieldsReader bloomFilterStoredFieldsReader;
        private final BloomFilter bloomFilter;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TSDBStoredFieldsReader(Directory directory, SegmentInfo si, FieldInfos fn, IOContext context) throws IOException {
            boolean success = false;
            ArrayList<StoredFieldsReader> toClose = new ArrayList<StoredFieldsReader>(2);
            try {
                this.storedFieldsReader = TSDBStoredFieldsFormat.this.delegate.fieldsReader(directory, si, fn, context);
                toClose.add(this.storedFieldsReader);
                this.bloomFilterStoredFieldsReader = TSDBStoredFieldsFormat.this.bloomFilterStoredFieldsFormat.fieldsReader(directory, si, fn, context);
                this.bloomFilter = (BloomFilter)((Object)this.bloomFilterStoredFieldsReader);
                toClose.add(this.bloomFilterStoredFieldsReader);
                success = true;
            }
            finally {
                if (!success) {
                    IOUtils.close(toClose);
                }
            }
        }

        TSDBStoredFieldsReader(StoredFieldsReader storedFieldsReader, StoredFieldsReader bloomFilterStoredFieldsReader) {
            this.storedFieldsReader = storedFieldsReader;
            this.bloomFilterStoredFieldsReader = bloomFilterStoredFieldsReader;
            assert (bloomFilterStoredFieldsReader instanceof BloomFilter);
            this.bloomFilter = (BloomFilter)((Object)bloomFilterStoredFieldsReader);
        }

        @Override
        public StoredFieldsReader clone() {
            return new TSDBStoredFieldsReader(this.storedFieldsReader.clone(), this.bloomFilterStoredFieldsReader.clone());
        }

        @Override
        public StoredFieldsReader getMergeInstance() {
            return new TSDBStoredFieldsReader(this.storedFieldsReader.getMergeInstance(), this.bloomFilterStoredFieldsReader.getMergeInstance());
        }

        @Override
        public void checkIntegrity() throws IOException {
            this.storedFieldsReader.checkIntegrity();
            this.bloomFilterStoredFieldsReader.checkIntegrity();
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.storedFieldsReader, this.bloomFilterStoredFieldsReader);
        }

        @Override
        public void document(int docID, StoredFieldVisitor visitor) throws IOException {
            this.bloomFilterStoredFieldsReader.document(docID, visitor);
            this.storedFieldsReader.document(docID, visitor);
        }

        @Override
        public boolean mayContainTerm(String field, BytesRef term) throws IOException {
            return this.bloomFilter.mayContainTerm(field, term);
        }
    }

    class TSDBStoredFieldsWriter
    extends StoredFieldsWriter {
        private final StoredFieldsWriter storedFieldsWriter;
        private final StoredFieldsWriter bloomFilterStoredFieldsWriter;
        private int idFieldNumber = Integer.MIN_VALUE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TSDBStoredFieldsWriter(TSDBStoredFieldsFormat this$0, Directory directory, SegmentInfo si, IOContext context) throws IOException {
            boolean success = false;
            ArrayList<StoredFieldsWriter> toClose = new ArrayList<StoredFieldsWriter>(2);
            try {
                this.storedFieldsWriter = this$0.delegate.fieldsWriter(directory, si, context);
                toClose.add(this.storedFieldsWriter);
                this.bloomFilterStoredFieldsWriter = this$0.bloomFilterStoredFieldsFormat.fieldsWriter(directory, si, context);
                toClose.add(this.bloomFilterStoredFieldsWriter);
                success = true;
            }
            finally {
                if (!success) {
                    IOUtils.close(toClose);
                }
            }
        }

        @Override
        public void startDocument() throws IOException {
            this.storedFieldsWriter.startDocument();
            this.bloomFilterStoredFieldsWriter.startDocument();
        }

        @Override
        public void finishDocument() throws IOException {
            this.storedFieldsWriter.finishDocument();
            this.bloomFilterStoredFieldsWriter.finishDocument();
        }

        @Override
        public void writeField(FieldInfo info, int value) throws IOException {
            this.getWriterForField(info).writeField(info, value);
        }

        @Override
        public void writeField(FieldInfo info, long value) throws IOException {
            this.getWriterForField(info).writeField(info, value);
        }

        @Override
        public void writeField(FieldInfo info, float value) throws IOException {
            this.getWriterForField(info).writeField(info, value);
        }

        @Override
        public void writeField(FieldInfo info, double value) throws IOException {
            this.getWriterForField(info).writeField(info, value);
        }

        @Override
        public void writeField(FieldInfo info, BytesRef value) throws IOException {
            this.getWriterForField(info).writeField(info, value);
        }

        @Override
        public void writeField(FieldInfo info, String value) throws IOException {
            this.getWriterForField(info).writeField(info, value);
        }

        @Override
        public void finish(int numDocs) throws IOException {
            this.storedFieldsWriter.finish(numDocs);
            this.bloomFilterStoredFieldsWriter.finish(numDocs);
        }

        @Override
        public int merge(MergeState mergeState) throws IOException {
            int totalDocs = 0;
            totalDocs += this.storedFieldsWriter.merge(this.unwrapStoredFieldReaders(mergeState, false));
            return totalDocs += this.bloomFilterStoredFieldsWriter.merge(this.unwrapStoredFieldReaders(mergeState, true));
        }

        private MergeState unwrapStoredFieldReaders(MergeState mergeState, boolean unwrapBloomFilterReaders) {
            StoredFieldsReader[] updatedReaders = new StoredFieldsReader[mergeState.storedFieldsReaders.length];
            for (int i = 0; i < mergeState.storedFieldsReaders.length; ++i) {
                StoredFieldsReader storedFieldsReader = mergeState.storedFieldsReaders[i];
                if (storedFieldsReader instanceof TSDBStoredFieldsReader) {
                    TSDBStoredFieldsReader reader = (TSDBStoredFieldsReader)storedFieldsReader;
                    updatedReaders[i] = unwrapBloomFilterReaders ? reader.bloomFilterStoredFieldsReader : reader.storedFieldsReader;
                    continue;
                }
                updatedReaders[i] = storedFieldsReader;
            }
            return new MergeState(mergeState.docMaps, mergeState.segmentInfo, mergeState.mergeFieldInfos, updatedReaders, mergeState.termVectorsReaders, mergeState.normsProducers, mergeState.docValuesProducers, mergeState.fieldInfos, mergeState.liveDocs, mergeState.fieldsProducers, mergeState.pointsReaders, mergeState.knnVectorsReaders, mergeState.maxDocs, mergeState.infoStream, mergeState.intraMergeTaskExecutor, mergeState.needsIndexSort);
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.storedFieldsWriter, this.bloomFilterStoredFieldsWriter);
        }

        @Override
        public long ramBytesUsed() {
            return this.storedFieldsWriter.ramBytesUsed() + this.bloomFilterStoredFieldsWriter.ramBytesUsed();
        }

        private StoredFieldsWriter getWriterForField(FieldInfo field) {
            if (field.number == this.idFieldNumber || field.name.equals("_id")) {
                this.idFieldNumber = field.number;
                return this.bloomFilterStoredFieldsWriter;
            }
            return this.storedFieldsWriter;
        }
    }
}

