/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.bloomfilter;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.index.codec.bloomfilter.BloomFilter;
import org.elasticsearch.index.codec.bloomfilter.LazyFilterTermsEnum;

public class DelegatingBloomFilterFieldsProducer
extends FieldsProducer {
    private static final Set<String> FIELD_NAMES = Set.of("_id");
    private final FieldsProducer delegate;
    private final BloomFilter bloomFilter;

    public DelegatingBloomFilterFieldsProducer(FieldsProducer delegate, BloomFilter bloomFilter) {
        this.delegate = delegate;
        this.bloomFilter = bloomFilter;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.delegate, this.bloomFilter);
    }

    @Override
    public void checkIntegrity() throws IOException {
        this.delegate.checkIntegrity();
    }

    @Override
    public Iterator<String> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Terms terms(final String field) throws IOException {
        assert (FIELD_NAMES.contains(field)) : "Expected one of " + String.valueOf(FIELD_NAMES) + " but got " + field;
        final Terms terms = this.delegate.terms(field);
        return new FilterLeafReader.FilterTerms(terms){

            @Override
            public TermsEnum iterator() throws IOException {
                return new LazyFilterTermsEnum(){
                    private TermsEnum termsEnum;

                    @Override
                    protected TermsEnum getDelegate() throws IOException {
                        if (this.termsEnum == null) {
                            this.termsEnum = terms.iterator();
                        }
                        return this.termsEnum;
                    }

                    @Override
                    public boolean seekExact(BytesRef text) throws IOException {
                        if (!DelegatingBloomFilterFieldsProducer.this.bloomFilter.mayContainTerm(field, text)) {
                            return false;
                        }
                        return this.getDelegate().seekExact(text);
                    }
                };
            }
        };
    }

    @Override
    public int size() {
        return this.delegate.size();
    }
}

