/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.codecs.FilterCodec;
import org.apache.lucene.codecs.lucene103.Lucene103Codec;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.FeatureFlag;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.codec.CodecProvider;
import org.elasticsearch.index.codec.DeduplicatingFieldInfosFormat;
import org.elasticsearch.index.codec.ES93TSDBDefaultCompressionLucene103Codec;
import org.elasticsearch.index.codec.LegacyPerFieldMapperCodec;
import org.elasticsearch.index.codec.PerFieldMapperCodec;
import org.elasticsearch.index.codec.zstd.Zstd814StoredFieldsFormat;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.threadpool.ThreadPool;

public class CodecService
implements CodecProvider {
    public static final boolean ZSTD_STORED_FIELDS_FEATURE_FLAG = new FeatureFlag("zstd_stored_fields").isEnabled();
    private final Map<String, Codec> codecs;
    public static final String DEFAULT_CODEC = "default";
    public static final String LEGACY_DEFAULT_CODEC = "legacy_default";
    public static final String BEST_COMPRESSION_CODEC = "best_compression";
    public static final String LEGACY_BEST_COMPRESSION_CODEC = "legacy_best_compression";
    public static final String LUCENE_DEFAULT_CODEC = "lucene_default";

    public CodecService(@Nullable MapperService mapperService, BigArrays bigArrays, @Nullable ThreadPool threadPool) {
        HashMap<String, Codec> codecs = new HashMap<String, Codec>();
        boolean useSyntheticId = mapperService != null && mapperService.getIndexSettings().useTimeSeriesSyntheticId() && mapperService.getIndexSettings().getIndexVersionCreated().onOrAfter(IndexVersions.TIME_SERIES_USE_STORED_FIELDS_BLOOM_FILTER_FOR_ID);
        LegacyPerFieldMapperCodec legacyBestSpeedCodec = new LegacyPerFieldMapperCodec(Lucene103Codec.Mode.BEST_SPEED, mapperService, bigArrays, threadPool);
        if (useSyntheticId) {
            codecs.put(DEFAULT_CODEC, new ES93TSDBDefaultCompressionLucene103Codec(legacyBestSpeedCodec, bigArrays));
        } else if (ZSTD_STORED_FIELDS_FEATURE_FLAG) {
            codecs.put(DEFAULT_CODEC, new PerFieldMapperCodec(Zstd814StoredFieldsFormat.Mode.BEST_SPEED, mapperService, bigArrays, threadPool));
        } else {
            codecs.put(DEFAULT_CODEC, legacyBestSpeedCodec);
        }
        codecs.put(LEGACY_DEFAULT_CODEC, legacyBestSpeedCodec);
        codecs.put(BEST_COMPRESSION_CODEC, new PerFieldMapperCodec(Zstd814StoredFieldsFormat.Mode.BEST_COMPRESSION, mapperService, bigArrays, threadPool));
        LegacyPerFieldMapperCodec legacyBestCompressionCodec = new LegacyPerFieldMapperCodec(Lucene103Codec.Mode.BEST_COMPRESSION, mapperService, bigArrays, threadPool);
        codecs.put(LEGACY_BEST_COMPRESSION_CODEC, legacyBestCompressionCodec);
        codecs.put(LUCENE_DEFAULT_CODEC, Codec.getDefault());
        for (String codec : Codec.availableCodecs()) {
            codecs.put(codec, Codec.forName(codec));
        }
        this.codecs = codecs.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> {
            DeduplicateFieldInfosCodec dedupCodec;
            Object patt0$temp = e.getValue();
            DeduplicateFieldInfosCodec codec = patt0$temp instanceof DeduplicateFieldInfosCodec ? (dedupCodec = (DeduplicateFieldInfosCodec)patt0$temp) : new DeduplicateFieldInfosCodec(((Codec)e.getValue()).getName(), (Codec)e.getValue());
            return codec;
        }));
    }

    @Override
    public Codec codec(String name) {
        Codec codec = this.codecs.get(name);
        if (codec == null) {
            throw new IllegalArgumentException("failed to find codec [" + name + "]");
        }
        return codec;
    }

    @Override
    public String[] availableCodecs() {
        return this.codecs.keySet().toArray(new String[0]);
    }

    public static class DeduplicateFieldInfosCodec
    extends FilterCodec {
        private final DeduplicatingFieldInfosFormat deduplicatingFieldInfosFormat = new DeduplicatingFieldInfosFormat(super.fieldInfosFormat());

        protected DeduplicateFieldInfosCodec(String name, Codec delegate) {
            super(name, delegate);
        }

        @Override
        public final FieldInfosFormat fieldInfosFormat() {
            return this.deduplicatingFieldInfosFormat;
        }

        public final Codec delegate() {
            return this.delegate;
        }
    }
}

