/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.Locale;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.SuppressForbidden;

public class LenientBooleans {
    private static final String DEPRECATED_MESSAGE_TEMPLATE = "Usage of lenient boolean value [{}] for {} [{}] was deprecated. Future releases of Elasticsearch may only accept `true` or `false`.";

    @SuppressForbidden(reason="wrap lenient parsing of booleans for deprecation logging.")
    public static boolean parseAndCheckForDeprecatedUsage(String value, UsageCategory usageCategory, String name, DeprecationCategory deprecationCategory) {
        if (!Booleans.isBoolean(value)) {
            String key = String.format(Locale.ROOT, "lenient.%s.%s", new Object[]{usageCategory, name});
            DeprecationLoggerHolder.deprecationLogger.critical(deprecationCategory, key, DEPRECATED_MESSAGE_TEMPLATE, value, usageCategory.displayValue(), name);
        }
        return Boolean.parseBoolean(value);
    }

    static class DeprecationLoggerHolder {
        static DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(LenientBooleans.class);

        DeprecationLoggerHolder() {
        }
    }

    public static enum UsageCategory {
        SYSTEM_PROPERTY("system property"),
        INDEX_METADATA("index metadata"),
        SETTING("setting");

        private final String displayValue;

        private UsageCategory(String displayValue) {
            this.displayValue = displayValue;
        }

        public String displayValue() {
            return this.displayValue;
        }
    }
}

