/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging.internal;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.elasticsearch.common.SuppressLoggerChecks;
import org.elasticsearch.common.logging.internal.LevelUtil;
import org.elasticsearch.logging.Level;

@SuppressLoggerChecks(reason="safely delegates to logger")
public final class LoggerImpl
implements org.elasticsearch.logging.Logger {
    private final Logger log4jLogger;

    public LoggerImpl(Logger log4jLogger) {
        this.log4jLogger = log4jLogger;
    }

    private static Supplier<?> mapSupplier(java.util.function.Supplier<String> msgSupplier) {
        return () -> msgSupplier.get();
    }

    @Override
    public void log(Level level, String message) {
        this.log4jLogger.log(LevelUtil.log4jLevel(level), message);
    }

    @Override
    public void log(Level level, java.util.function.Supplier<String> messageSupplier, Throwable throwable) {
        this.log4jLogger.log(LevelUtil.log4jLevel(level), LoggerImpl.mapSupplier(messageSupplier), throwable);
    }

    @Override
    public String getName() {
        return this.log4jLogger.getName();
    }

    @Override
    public boolean isFatalEnabled() {
        return this.log4jLogger.isFatalEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.log4jLogger.isErrorEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.log4jLogger.isWarnEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log4jLogger.isInfoEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log4jLogger.isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.log4jLogger.isTraceEnabled();
    }

    @Override
    public boolean isEnabled(Level level) {
        return this.log4jLogger.isEnabled(LevelUtil.log4jLevel(level));
    }

    @Override
    public void fatal(java.util.function.Supplier<String> messageSupplier) {
        this.log4jLogger.fatal(LoggerImpl.mapSupplier(messageSupplier));
    }

    @Override
    public void fatal(java.util.function.Supplier<String> messageSupplier, Throwable throwable) {
        this.log4jLogger.fatal(LoggerImpl.mapSupplier(messageSupplier), throwable);
    }

    @Override
    public void fatal(String message) {
        this.log4jLogger.fatal(message);
    }

    @Override
    public void fatal(String message, Throwable throwable) {
        this.log4jLogger.fatal(message, throwable);
    }

    @Override
    public void fatal(String message, Object ... params) {
        this.log4jLogger.fatal(message, params);
    }

    @Override
    public void error(java.util.function.Supplier<String> messageSupplier) {
        this.log4jLogger.error(LoggerImpl.mapSupplier(messageSupplier));
    }

    @Override
    public void error(java.util.function.Supplier<String> messageSupplier, Throwable throwable) {
        this.log4jLogger.error(LoggerImpl.mapSupplier(messageSupplier), throwable);
    }

    @Override
    public void error(String message) {
        this.log4jLogger.error(message);
    }

    @Override
    public void error(String message, Throwable throwable) {
        this.log4jLogger.error(message, throwable);
    }

    @Override
    public void error(String message, Object ... params) {
        this.log4jLogger.error(message, params);
    }

    @Override
    public void warn(java.util.function.Supplier<String> messageSupplier) {
        this.log4jLogger.warn(LoggerImpl.mapSupplier(messageSupplier));
    }

    @Override
    public void warn(java.util.function.Supplier<String> messageSupplier, Throwable throwable) {
        this.log4jLogger.warn(LoggerImpl.mapSupplier(messageSupplier), throwable);
    }

    @Override
    public void warn(String message) {
        this.log4jLogger.warn(message);
    }

    @Override
    public void warn(String message, Throwable throwable) {
        this.log4jLogger.warn(message, throwable);
    }

    @Override
    public void warn(String message, Object ... params) {
        this.log4jLogger.warn(message, params);
    }

    @Override
    public void info(java.util.function.Supplier<String> messageSupplier) {
        this.log4jLogger.info(LoggerImpl.mapSupplier(messageSupplier));
    }

    @Override
    public void info(java.util.function.Supplier<String> messageSupplier, Throwable throwable) {
        this.log4jLogger.info(LoggerImpl.mapSupplier(messageSupplier), throwable);
    }

    @Override
    public void info(String message) {
        this.log4jLogger.info(message);
    }

    @Override
    public void info(String message, Throwable throwable) {
        this.log4jLogger.info(message, throwable);
    }

    @Override
    public void info(String message, Object ... params) {
        this.log4jLogger.info(message, params);
    }

    @Override
    public void debug(java.util.function.Supplier<String> messageSupplier) {
        this.log4jLogger.debug(LoggerImpl.mapSupplier(messageSupplier));
    }

    @Override
    public void debug(java.util.function.Supplier<String> messageSupplier, Throwable throwable) {
        this.log4jLogger.debug(LoggerImpl.mapSupplier(messageSupplier), throwable);
    }

    @Override
    public void debug(String message) {
        this.log4jLogger.debug(message);
    }

    @Override
    public void debug(String message, Throwable throwable) {
        this.log4jLogger.debug(message, throwable);
    }

    @Override
    public void debug(String message, Object ... params) {
        this.log4jLogger.debug(message, params);
    }

    @Override
    public void trace(java.util.function.Supplier<String> messageSupplier) {
        this.log4jLogger.trace(LoggerImpl.mapSupplier(messageSupplier));
    }

    @Override
    public void trace(java.util.function.Supplier<String> messageSupplier, Throwable throwable) {
        this.log4jLogger.trace(LoggerImpl.mapSupplier(messageSupplier), throwable);
    }

    @Override
    public void trace(String message) {
        this.log4jLogger.trace(message);
    }

    @Override
    public void trace(String message, Throwable throwable) {
        this.log4jLogger.trace(message, throwable);
    }

    @Override
    public void trace(String message, Object ... params) {
        this.log4jLogger.trace(message, params);
    }
}

