/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.allocation.NodeAllocationStats;
import org.elasticsearch.cluster.routing.allocation.NodeAllocationStatsAndWeightsCalculator;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalance;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalanceShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.transport.Transports;

public class AllocationStatsService {
    private final ClusterService clusterService;
    private final ClusterInfoService clusterInfoService;
    private final Supplier<DesiredBalance> desiredBalanceSupplier;
    private final NodeAllocationStatsAndWeightsCalculator nodeAllocationStatsAndWeightsCalculator;

    public AllocationStatsService(ClusterService clusterService, ClusterInfoService clusterInfoService, ShardsAllocator shardsAllocator, NodeAllocationStatsAndWeightsCalculator nodeAllocationStatsAndWeightsCalculator) {
        Supplier<DesiredBalance> supplier;
        this.clusterService = clusterService;
        this.clusterInfoService = clusterInfoService;
        this.nodeAllocationStatsAndWeightsCalculator = nodeAllocationStatsAndWeightsCalculator;
        if (shardsAllocator instanceof DesiredBalanceShardsAllocator) {
            DesiredBalanceShardsAllocator allocator = (DesiredBalanceShardsAllocator)shardsAllocator;
            supplier = allocator::getDesiredBalance;
        } else {
            supplier = () -> null;
        }
        this.desiredBalanceSupplier = supplier;
    }

    public Map<String, NodeAllocationStats> stats() {
        return this.stats(() -> {});
    }

    public Map<String, NodeAllocationStats> stats(Runnable ensureNotCancelled) {
        assert (Transports.assertNotTransportThread("too expensive for a transport worker"));
        ClusterState clusterState = this.clusterService.state();
        Map<String, NodeAllocationStatsAndWeightsCalculator.NodeAllocationStatsAndWeight> nodesStatsAndWeights = this.nodeAllocationStatsAndWeightsCalculator.nodesAllocationStatsAndWeights(clusterState.metadata(), clusterState.getRoutingNodes(), this.clusterInfoService.getClusterInfo(), ensureNotCancelled, this.desiredBalanceSupplier.get());
        return nodesStatsAndWeights.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new NodeAllocationStats(((NodeAllocationStatsAndWeightsCalculator.NodeAllocationStatsAndWeight)e.getValue()).shards(), ((NodeAllocationStatsAndWeightsCalculator.NodeAllocationStatsAndWeight)e.getValue()).undesiredShards(), ((NodeAllocationStatsAndWeightsCalculator.NodeAllocationStatsAndWeight)e.getValue()).forecastedIngestLoad(), ((NodeAllocationStatsAndWeightsCalculator.NodeAllocationStatsAndWeight)e.getValue()).forecastedDiskUsage(), ((NodeAllocationStatsAndWeightsCalculator.NodeAllocationStatsAndWeight)e.getValue()).currentDiskUsage())));
    }
}

