/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class View
implements Writeable,
ToXContentObject {
    private static final ParseField NAME = new ParseField("name", new String[0]);
    private static final ParseField QUERY = new ParseField("query", new String[0]);
    static final ConstructingObjectParser<View, Void> PARSER = new ConstructingObjectParser<View, Void>("view", false, (args, ctx) -> new View((String)args[0], (String)args[1]));
    private final String name;
    private final String query;

    public static ConstructingObjectParser<View, Void> parser(String name) {
        ConstructingObjectParser<View, Void> parser = new ConstructingObjectParser<View, Void>("view", false, (args, ctx) -> new View(name, (String)args[0]));
        parser.declareString(ConstructingObjectParser.constructorArg(), QUERY);
        return parser;
    }

    public View(String name, String query) {
        this.name = Objects.requireNonNull(name, "view name must not be null");
        this.query = Objects.requireNonNull(query, "view query must not be null");
    }

    public View(StreamInput in) throws IOException {
        this.name = in.readString();
        this.query = in.readString();
    }

    public static View fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.query);
    }

    public String name() {
        return this.name;
    }

    public String query() {
        return this.query;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME.getPreferredName(), this.name);
        builder.field(QUERY.getPreferredName(), this.query);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        View other = (View)o;
        return Objects.equals(this.name, other.name) && Objects.equals(this.query, other.query);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.query);
    }

    public String toString() {
        return Strings.toString(this);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), QUERY);
    }
}

