/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.cluster.routing.allocation.ShardAllocationDecision;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class ShutdownShardMigrationStatus
implements Writeable,
ChunkedToXContentObject {
    public static final String NODE_ALLOCATION_DECISION_KEY = "node_allocation_decision";
    private final SingleNodeShutdownMetadata.Status status;
    private final long startedShards;
    private final long relocatingShards;
    private final long initializingShards;
    private final long shardsRemaining;
    @Nullable
    private final String explanation;
    @Nullable
    private final ShardAllocationDecision allocationDecision;

    public ShutdownShardMigrationStatus(SingleNodeShutdownMetadata.Status status, long shardsRemaining, @Nullable String explanation, @Nullable ShardAllocationDecision allocationDecision) {
        this(status, -1L, -1L, -1L, shardsRemaining, explanation, allocationDecision);
    }

    public ShutdownShardMigrationStatus(SingleNodeShutdownMetadata.Status status, long startedShards, long relocatingShards, long initializingShards) {
        this(status, startedShards, relocatingShards, initializingShards, startedShards + relocatingShards + initializingShards, null, null);
    }

    public ShutdownShardMigrationStatus(SingleNodeShutdownMetadata.Status status, long startedShards, long relocatingShards, long initializingShards, @Nullable String explanation) {
        this(status, startedShards, relocatingShards, initializingShards, startedShards + relocatingShards + initializingShards, explanation, null);
    }

    public ShutdownShardMigrationStatus(SingleNodeShutdownMetadata.Status status, long startedShards, long relocatingShards, long initializingShards, @Nullable String explanation, @Nullable ShardAllocationDecision allocationDecision) {
        this(status, startedShards, relocatingShards, initializingShards, startedShards + relocatingShards + initializingShards, explanation, allocationDecision);
    }

    private ShutdownShardMigrationStatus(SingleNodeShutdownMetadata.Status status, long startedShards, long relocatingShards, long initializingShards, long shardsRemaining, @Nullable String explanation, @Nullable ShardAllocationDecision allocationDecision) {
        this.status = Objects.requireNonNull(status, "status must not be null");
        this.startedShards = startedShards;
        this.relocatingShards = relocatingShards;
        this.initializingShards = initializingShards;
        this.shardsRemaining = shardsRemaining;
        this.explanation = explanation;
        this.allocationDecision = allocationDecision;
    }

    public ShutdownShardMigrationStatus(StreamInput in) throws IOException {
        this.status = in.readEnum(SingleNodeShutdownMetadata.Status.class);
        this.startedShards = in.readZLong();
        this.relocatingShards = in.readZLong();
        this.initializingShards = in.readZLong();
        this.shardsRemaining = in.readZLong();
        this.explanation = in.readOptionalString();
        this.allocationDecision = in.readOptionalWriteable(ShardAllocationDecision::new);
    }

    public long getShardsRemaining() {
        return this.shardsRemaining;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public SingleNodeShutdownMetadata.Status getStatus() {
        return this.status;
    }

    public ShardAllocationDecision getAllocationDecision() {
        return this.allocationDecision;
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat(ChunkedToXContentHelper.startObject(), ChunkedToXContentHelper.chunk((builder, p) -> this.buildHeader(builder)), Objects.nonNull(this.allocationDecision) ? ChunkedToXContentHelper.object(NODE_ALLOCATION_DECISION_KEY, this.allocationDecision.toXContentChunked(params)) : Collections.emptyIterator(), ChunkedToXContentHelper.endObject());
    }

    private XContentBuilder buildHeader(XContentBuilder builder) throws IOException {
        builder.field("status", this.status);
        if (this.startedShards != -1L) {
            builder.field("started_shards", this.startedShards);
            builder.field("relocating_shards", this.relocatingShards);
            builder.field("initializing_shards", this.initializingShards);
        }
        builder.field("shard_migrations_remaining", this.shardsRemaining);
        if (Objects.nonNull(this.explanation)) {
            builder.field("explanation", this.explanation);
        }
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this.status);
        out.writeZLong(this.startedShards);
        out.writeZLong(this.relocatingShards);
        out.writeZLong(this.initializingShards);
        out.writeZLong(this.shardsRemaining);
        out.writeOptionalString(this.explanation);
        out.writeOptionalWriteable(this.allocationDecision);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShutdownShardMigrationStatus that = (ShutdownShardMigrationStatus)o;
        return this.startedShards == that.startedShards && this.relocatingShards == that.relocatingShards && this.initializingShards == that.initializingShards && this.shardsRemaining == that.shardsRemaining && this.status == that.status && Objects.equals(this.explanation, that.explanation) && Objects.equals(this.allocationDecision, that.allocationDecision);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.startedShards, this.relocatingShards, this.initializingShards, this.shardsRemaining, this.explanation, this.allocationDecision});
    }

    public String toString() {
        return Strings.toString((b, p) -> this.buildHeader(b), false, false);
    }
}

